/*
 * Decompiled with CFR 0.152.
 */
package wuemeli.utils.globalchat;

import com.google.gson.JsonObject;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import wuemeli.utils.config.ConfigManager;
import wuemeli.utils.config.ModConfig;
import wuemeli.utils.connection.ConnectionManager;
import wuemeli.utils.logger.Logger;

@Environment(value=EnvType.CLIENT)
public class GlobalChatManager {
    private static boolean initialized = false;
    private static boolean noConnectionWarningShown = false;
    private static long lastMessageTime = 0L;
    private static final long MESSAGE_COOLDOWN = 1000L;

    public static void init() {
        if (initialized) {
            Logger.debug("Global chat already initialized");
            return;
        }
        try {
            initialized = true;
            noConnectionWarningShown = false;
            Logger.debug("Global chat system initialized");
        }
        catch (Exception e) {
            Logger.error("Failed to initialize global chat system", e);
        }
    }

    public static void sendGlobalMessage(String message) {
        if (message == null || message.trim().isEmpty()) {
            Logger.warn("Cannot send empty global chat message");
            return;
        }
        try {
            ConfigManager configManager = ConfigManager.getInstance();
            if (configManager == null || !configManager.isLoaded()) {
                GlobalChatManager.sendChatMessage("\u00a7cGlobal chat not available - configuration not loaded");
                return;
            }
            ModConfig config = configManager.getConfig();
            if (!config.globalChat.enabled) {
                GlobalChatManager.sendChatMessage("\u00a7cGlobal chat is disabled in configuration");
                return;
            }
            long currentTime = System.currentTimeMillis();
            if (currentTime - lastMessageTime < 1000L) {
                long remainingCooldown = 1000L - (currentTime - lastMessageTime);
                GlobalChatManager.sendChatMessage("\u00a7cPlease wait " + (double)remainingCooldown / 1000.0 + " seconds before sending another message");
                return;
            }
            if (!ConnectionManager.isConnected()) {
                if (!noConnectionWarningShown) {
                    Logger.warn("No server connection, global chat not available");
                    GlobalChatManager.sendChatMessage("\u00a7cGlobal chat not available - no server connection");
                    noConnectionWarningShown = true;
                }
                return;
            }
            noConnectionWarningShown = false;
            try {
                class_310 mc = class_310.method_1551();
                if (mc.field_1724 == null) {
                    Logger.warn("Player not available for global chat");
                    return;
                }
                String playerName = mc.field_1724.method_5477().getString();
                JsonObject globalChatMessage = new JsonObject();
                globalChatMessage.addProperty("type", "send_global_message");
                globalChatMessage.addProperty("senderName", playerName);
                globalChatMessage.addProperty("message", message);
                ConnectionManager.sendMessage(globalChatMessage.toString());
                Logger.debug("Sent global chat message: " + message.substring(0, Math.min(50, message.length())));
                String formattedMessage = config.globalChat.ownMessageFormat.replace("{prefix}", config.globalChat.prefix).replace("{message}", message);
                GlobalChatManager.sendChatMessage(formattedMessage);
                lastMessageTime = currentTime;
            }
            catch (Exception e) {
                Logger.error("Failed to send global chat message", e);
                GlobalChatManager.sendChatMessage("\u00a7cFailed to send global chat message");
            }
        }
        catch (Exception e) {
            Logger.error("Error in sendGlobalMessage", e);
        }
    }

    public static void handleGlobalChatResponse(JsonObject response) {
        if (!initialized) {
            Logger.debug("Global chat not initialized, ignoring response");
            return;
        }
        try {
            String subType;
            switch (subType = response.get("subType").getAsString()) {
                case "global_message": {
                    GlobalChatManager.handleIncomingGlobalMessage(response);
                    break;
                }
                case "message_sent": {
                    Logger.debug("Global chat message sent successfully");
                    break;
                }
                case "rate_limited": {
                    String cooldownTime = response.has("cooldown") ? response.get("cooldown").getAsString() : "a few seconds";
                    GlobalChatManager.sendChatMessage("\u00a7cYou are sending messages too quickly. Please wait " + cooldownTime + " before sending another message.");
                    break;
                }
                case "message_too_long": {
                    GlobalChatManager.sendChatMessage("\u00a7cYour message is too long for global chat");
                    break;
                }
                case "global_chat_disabled": {
                    GlobalChatManager.sendChatMessage("\u00a7cGlobal chat is currently disabled on the server");
                    break;
                }
                default: {
                    Logger.warn("Unknown global chat response type: " + subType);
                    break;
                }
            }
        }
        catch (Exception e) {
            Logger.error("Error handling global chat response", e);
        }
    }

    private static void handleIncomingGlobalMessage(JsonObject response) {
        try {
            ConfigManager configManager2;
            String senderName = response.get("senderName").getAsString();
            String message = response.get("message").getAsString();
            ConfigManager configManager = ConfigManager.getInstance();
            if (configManager != null && configManager.isLoaded()) {
                class_310 mc = class_310.method_1551();
                if (mc.field_1724 != null && senderName.equals(mc.field_1724.method_5477().getString())) {
                    return;
                }
            }
            if ((configManager2 = ConfigManager.getInstance()) == null || !configManager2.isLoaded()) {
                return;
            }
            ModConfig config = configManager2.getConfig();
            String formattedMessage = config.globalChat.messageFormat.replace("{prefix}", config.globalChat.prefix).replace("{sender}", senderName).replace("{message}", message);
            GlobalChatManager.sendChatMessage(formattedMessage);
            Logger.debug("Received global chat message from: " + senderName);
        }
        catch (Exception e) {
            Logger.error("Error handling incoming global chat message", e);
        }
    }

    public static boolean toggleGlobalChat() {
        try {
            ConfigManager configManager = ConfigManager.getInstance();
            if (configManager == null || !configManager.isLoaded()) {
                Logger.warn("Cannot toggle global chat - configuration not loaded");
                return false;
            }
            ModConfig config = configManager.getConfig();
            config.globalChat.enabled = !config.globalChat.enabled;
            configManager.save();
            String status = config.globalChat.enabled ? "enabled" : "disabled";
            GlobalChatManager.sendChatMessage("\u00a7aGlobal chat " + status);
            Logger.info("Global chat " + status);
            return config.globalChat.enabled;
        }
        catch (Exception e) {
            Logger.error("Error toggling global chat", e);
            GlobalChatManager.sendChatMessage("\u00a7cError toggling global chat");
            return false;
        }
    }

    public static boolean isEnabled() {
        try {
            if (!initialized) {
                return false;
            }
            ConfigManager configManager = ConfigManager.getInstance();
            if (configManager == null || !configManager.isLoaded()) {
                return false;
            }
            return configManager.getConfig().globalChat.enabled;
        }
        catch (Exception e) {
            Logger.error("Error checking global chat enabled state", e);
            return false;
        }
    }

    public static boolean isReady() {
        return initialized && GlobalChatManager.isEnabled() && ConnectionManager.isConnected();
    }

    private static void sendChatMessage(String message) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 != null) {
            mc.field_1724.method_7353((class_2561)class_2561.method_43470((String)message), false);
        }
    }
}

