/*
 * Decompiled with CFR 0.152.
 */
package wuemeli.utils.privatemsg;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import wuemeli.utils.logger.Logger;

@Environment(value=EnvType.CLIENT)
public class PGPKeyManager {
    private static final int KEY_SIZE = 1024;
    private static KeyPair keyPair;
    private static final String ALGORITHM = "RSA";

    public static void generateKeyPair() {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance(ALGORITHM);
            keyGen.initialize(1024);
            keyPair = keyGen.generateKeyPair();
            Logger.info("Generated new RSA key pair for private messaging");
        }
        catch (Exception e) {
            Logger.error("Failed to generate key pair", e);
        }
    }

    public static String getPublicKeyString() {
        if (keyPair == null) {
            return null;
        }
        return Base64.getEncoder().encodeToString(keyPair.getPublic().getEncoded());
    }

    public static PrivateKey getPrivateKey() {
        return keyPair != null ? keyPair.getPrivate() : null;
    }

    public static String encryptMessage(String message, String publicKeyString) {
        try {
            byte[] publicKeyBytes = Base64.getDecoder().decode(publicKeyString);
            PublicKey publicKey = KeyFactory.getInstance(ALGORITHM).generatePublic(new X509EncodedKeySpec(publicKeyBytes));
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(1, publicKey);
            byte[] encryptedBytes = cipher.doFinal(message.getBytes());
            return Base64.getEncoder().encodeToString(encryptedBytes);
        }
        catch (Exception e) {
            Logger.error("Failed to encrypt message", e);
            return null;
        }
    }

    public static String decryptMessage(String encryptedMessage) {
        try {
            if (keyPair == null) {
                return null;
            }
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(2, keyPair.getPrivate());
            byte[] encryptedBytes = Base64.getDecoder().decode(encryptedMessage);
            byte[] decryptedBytes = cipher.doFinal(encryptedBytes);
            return new String(decryptedBytes);
        }
        catch (Exception e) {
            Logger.warn("Failed to decrypt message: " + e.getMessage());
            return null;
        }
    }

    public static boolean hasKeyPair() {
        return keyPair != null;
    }
}

