/*
 * Decompiled with CFR 0.152.
 */
package wuemeli.utils.services;

import dev.firstdark.rpc.DiscordRpc;
import dev.firstdark.rpc.enums.ActivityType;
import dev.firstdark.rpc.enums.ErrorCode;
import dev.firstdark.rpc.handlers.DiscordEventHandler;
import dev.firstdark.rpc.models.DiscordJoinRequest;
import dev.firstdark.rpc.models.DiscordRichPresence;
import dev.firstdark.rpc.models.User;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import wuemeli.utils.logger.Logger;

@Environment(value=EnvType.CLIENT)
public class DiscordRpcService {
    private static DiscordRpcService instance;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final AtomicBoolean connected = new AtomicBoolean(false);
    private DiscordRpc rpc;
    private DiscordEventHandler eventHandler;

    private DiscordRpcService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DiscordRpcService getInstance() {
        if (instance != null) return instance;
        Class<DiscordRpcService> clazz = DiscordRpcService.class;
        synchronized (DiscordRpcService.class) {
            if (instance != null) return instance;
            instance = new DiscordRpcService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void initialize() {
        if (this.initialized.get()) {
            Logger.warn("Discord RPC service already initialized");
            return;
        }
        try {
            this.rpc = new DiscordRpc();
            this.rpc.setDebugMode(false);
            this.eventHandler = new DiscordEventHandler(){

                public void ready(User user) {
                    Logger.info("Discord RPC connected for user: " + user.getUsername());
                    DiscordRpcService.this.connected.set(true);
                    DiscordRpcService.this.updateDefaultPresence();
                }

                public void disconnected(ErrorCode errorCode, String message) {
                    Logger.warn("Discord RPC disconnected: " + String.valueOf(errorCode) + " - " + message);
                    DiscordRpcService.this.connected.set(false);
                    CompletableFuture.delayedExecutor(5L, TimeUnit.SECONDS).execute(() -> {
                        if (DiscordRpcService.this.initialized.get()) {
                            DiscordRpcService.this.attemptReconnect();
                        }
                    });
                }

                public void errored(ErrorCode errorCode, String message) {
                    Logger.warn("Discord RPC error: " + String.valueOf(errorCode) + " - " + message);
                }

                public void joinGame(String joinSecret) {
                    Logger.debug("Discord RPC join game request: " + joinSecret);
                }

                public void spectateGame(String spectateSecret) {
                    Logger.debug("Discord RPC spectate game request: " + spectateSecret);
                }

                public void joinRequest(DiscordJoinRequest joinRequest) {
                    Logger.debug("Discord RPC join request from");
                }
            };
            this.rpc.init("1385698721936965757", this.eventHandler, false);
            this.initialized.set(true);
            Logger.info("Discord RPC service initialized successfully");
        }
        catch (Exception e) {
            Logger.error("Failed to initialize Discord RPC service", e);
            this.initialized.set(false);
        }
    }

    public void updateDefaultPresence() {
        if (!this.isConnected()) {
            return;
        }
        try {
            DiscordRichPresence presence = DiscordRichPresence.builder().details("Playing Minecraft with Wuemeli's Utils").state("Version 1.0.5").activityType(ActivityType.PLAYING).largeImageKey("flower").largeImageText("Wuemeli's Utils v1.0.5").button(DiscordRichPresence.RPCButton.of((String)"Download Mod", (String)"https://modrinth.com/mod/wuemelis-utils")).build();
            this.rpc.updatePresence(presence);
            Logger.debug("Updated Discord presence with default information");
        }
        catch (Exception e) {
            Logger.error("Failed to update Discord presence", e);
        }
    }

    public void updatePresence(String details, String state) {
        if (!this.isConnected()) {
            return;
        }
        try {
            DiscordRichPresence presence = DiscordRichPresence.builder().details(details != null ? details : "Playing Minecraft with Wuemeli's Utils").state(state != null ? state : "Version 1.0.5").activityType(ActivityType.PLAYING).largeImageKey("flower").largeImageText("Wuemeli's Utils v1.0.5").button(DiscordRichPresence.RPCButton.of((String)"Download Mod", (String)"https://modrinth.com/mod/wuemelis-utils")).build();
            this.rpc.updatePresence(presence);
            Logger.debug("Updated Discord presence: " + details + " | " + state);
        }
        catch (Exception e) {
            Logger.error("Failed to update Discord presence", e);
        }
    }

    private void attemptReconnect() {
        if (!this.initialized.get() || this.connected.get()) {
            return;
        }
        try {
            Logger.info("Attempting to reconnect to Discord RPC...");
            this.rpc.init("1385698721936965757", this.eventHandler, false);
        }
        catch (Exception e) {
            Logger.error("Failed to reconnect to Discord RPC", e);
        }
    }

    public boolean isInitialized() {
        return this.initialized.get();
    }

    public boolean isConnected() {
        return this.initialized.get() && this.connected.get();
    }
}

