/*
 * Decompiled with CFR 0.152.
 */
package wuemeli.utils.services;

import io.sentry.IScope;
import io.sentry.Sentry;
import io.sentry.SentryLevel;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import wuemeli.utils.logger.Logger;

@Environment(value=EnvType.CLIENT)
public class SentryService {
    private static SentryService instance;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final Map<String, String> additionalContext = new HashMap<String, String>();

    private SentryService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SentryService getInstance() {
        if (instance != null) return instance;
        Class<SentryService> clazz = SentryService.class;
        synchronized (SentryService.class) {
            if (instance != null) return instance;
            instance = new SentryService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void initialize() {
        if (this.initialized.get()) {
            Logger.warn("Sentry service already initialized");
            return;
        }
        try {
            Sentry.init(options -> {
                options.setDsn("https://8f8cc205d6144a2084d18aa94614af5c@gossip.wuemeli.com/42");
                options.setRelease("1.0.5");
                options.setEnvironment("production");
                options.setDebug(false);
                options.setDiagnosticLevel(SentryLevel.ERROR);
                options.setTracesSampleRate(Double.valueOf(0.1));
                options.setTag("mod.name", "Wuemeli's Utils");
                options.setTag("mod.version", "1.0.5");
                options.setTag("mod.id", "wuemelis-utils");
                options.setBeforeSend((event, hint) -> {
                    this.additionalContext.forEach((key, value) -> event.setTag(key, value));
                    return event;
                });
            });
            this.initialized.set(true);
            Logger.info("Sentry service initialized successfully");
        }
        catch (Exception e) {
            Logger.error("Failed to initialize Sentry service", e);
            this.initialized.set(false);
        }
    }

    public void addContext(String key, String value) {
        if (!this.initialized.get()) {
            return;
        }
        this.additionalContext.put(key, value);
        Sentry.setTag((String)key, (String)value);
        Logger.debug("Added context: " + key + " = " + value);
    }

    public void removeContext(String key) {
        if (!this.initialized.get()) {
            return;
        }
        this.additionalContext.remove(key);
        Sentry.removeTag((String)key);
        Logger.debug("Removed context: " + key);
    }

    public void reportException(Throwable exception) {
        if (!this.initialized.get()) {
            return;
        }
        try {
            Sentry.captureException((Throwable)exception);
            Logger.debug("Reported exception to Sentry: " + exception.getClass().getSimpleName());
        }
        catch (Exception e) {
            Logger.error("Failed to report exception to Sentry", e);
        }
    }

    public void reportException(Throwable exception, Map<String, String> context) {
        if (!this.initialized.get()) {
            return;
        }
        try {
            Sentry.withScope(scope -> {
                context.forEach((arg_0, arg_1) -> ((IScope)scope).setTag(arg_0, arg_1));
                Sentry.captureException((Throwable)exception);
            });
            Logger.debug("Reported exception with context to Sentry: " + exception.getClass().getSimpleName());
        }
        catch (Exception e) {
            Logger.error("Failed to report exception with context to Sentry", e);
        }
    }

    public void reportMessage(String message, SentryLevel level) {
        if (!this.initialized.get()) {
            return;
        }
        try {
            Sentry.captureMessage((String)message, (SentryLevel)level);
            Logger.debug("Reported message to Sentry: " + message);
        }
        catch (Exception e) {
            Logger.error("Failed to report message to Sentry", e);
        }
    }

    public void reportError(String message) {
        this.reportMessage(message, SentryLevel.ERROR);
    }

    public void reportWarning(String message) {
        this.reportMessage(message, SentryLevel.WARNING);
    }

    public void reportInfo(String message) {
        this.reportMessage(message, SentryLevel.INFO);
    }

    public void setLevel(String level) {
        if (!this.initialized.get()) {
            return;
        }
        this.addContext("level", level);
    }

    public void setServerContext(String serverName, String serverIp) {
        if (!this.initialized.get()) {
            return;
        }
        if (serverName != null) {
            this.addContext("server.name", serverName);
        }
        if (serverIp != null) {
            this.addContext("server.ip", serverIp);
        }
    }

    public void clearServerContext() {
        if (!this.initialized.get()) {
            return;
        }
        this.removeContext("server.name");
        this.removeContext("server.ip");
    }

    public void addBreadcrumb(String message, String category) {
        if (!this.initialized.get()) {
            return;
        }
        try {
            Sentry.addBreadcrumb((String)message, (String)category);
            Logger.debug("Added breadcrumb: " + category + " - " + message);
        }
        catch (Exception e) {
            Logger.error("Failed to add breadcrumb", e);
        }
    }

    public boolean isInitialized() {
        return this.initialized.get();
    }
}

