/*
 * Decompiled with CFR 0.152.
 */
package wuemeli.utils.ui;

import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.gui.controllers.BooleanController;
import dev.isxander.yacl3.gui.controllers.ColorController;
import dev.isxander.yacl3.gui.controllers.dropdown.EnumDropdownController;
import dev.isxander.yacl3.gui.controllers.slider.IntegerSliderController;
import dev.isxander.yacl3.gui.controllers.string.StringController;
import java.awt.Color;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import wuemeli.utils.config.ConfigManager;
import wuemeli.utils.config.ModConfig;
import wuemeli.utils.config.ModConstants;
import wuemeli.utils.logger.Logger;

@Environment(value=EnvType.CLIENT)
public class ConfigScreenBuilder {
    public static ConfigScreenFactory<?> createScreenFactory() {
        return parent -> {
            try {
                ConfigManager configManager = ConfigManager.getInstance();
                ModConfig config = configManager.getConfig();
                return YetAnotherConfigLib.createBuilder().save(configManager::save).title((class_2561)class_2561.method_43470((String)"Wuemeli's Utils")).category(ConfigScreenBuilder.createGeneralCategory(config)).category(ConfigScreenBuilder.createPlayerTabGlowCategory(config)).category(ConfigScreenBuilder.createCustomBrandCategory(config)).category(ConfigScreenBuilder.createAutoRespawnCategory(config)).category(ConfigScreenBuilder.createCongraterCategory(config)).category(ConfigScreenBuilder.createHealthAlarmCategory(config)).category(ConfigScreenBuilder.createEffectAlarmCategory(config)).category(ConfigScreenBuilder.createPrivateMessagingCategory(config)).category(ConfigScreenBuilder.createGlobalChatCategory(config)).build().generateScreen(parent);
            }
            catch (Exception e) {
                Logger.error("Failed to create config screen", e);
                throw new RuntimeException("Failed to create configuration screen", e);
            }
        };
    }

    private static ConfigCategory createGeneralCategory(ModConfig config) {
        return ConfigCategory.createBuilder().name((class_2561)class_2561.method_43470((String)"General")).option(ConfigScreenBuilder.createLogLevelOption(config)).build();
    }

    private static ConfigCategory createPlayerTabGlowCategory(ModConfig config) {
        return ConfigCategory.createBuilder().name((class_2561)class_2561.method_43470((String)"Player Tab Glow")).option(ConfigScreenBuilder.createPlayerTabGlowEnabledOption(config)).option(ConfigScreenBuilder.createPlayerTabGlowColorOption(config)).build();
    }

    private static ConfigCategory createCustomBrandCategory(ModConfig config) {
        return ConfigCategory.createBuilder().name((class_2561)class_2561.method_43470((String)"Custom Client Brand")).option(ConfigScreenBuilder.createCustomBrandEnabledOption(config)).option(ConfigScreenBuilder.createCustomBrandOption(config)).build();
    }

    private static ConfigCategory createAutoRespawnCategory(ModConfig config) {
        return ConfigCategory.createBuilder().name((class_2561)class_2561.method_43470((String)"Auto Respawn")).option(ConfigScreenBuilder.createAutoRespawnEnabledOption(config)).option(ConfigScreenBuilder.createAutoRespawnDelayOption(config)).build();
    }

    private static ConfigCategory createCongraterCategory(ModConfig config) {
        return ConfigCategory.createBuilder().name((class_2561)class_2561.method_43470((String)"Congrater")).option(ConfigScreenBuilder.createCongraterEnabledOption(config)).option(ConfigScreenBuilder.createSendDeathMessageOption(config)).option(ConfigScreenBuilder.createDeathMessageOption(config)).option(ConfigScreenBuilder.createSendKillMessageOption(config)).option(ConfigScreenBuilder.createKillMessageOption(config)).option(ConfigScreenBuilder.createCongraterMessageDelayOption(config)).build();
    }

    private static ConfigCategory createHealthAlarmCategory(ModConfig config) {
        return ConfigCategory.createBuilder().name((class_2561)class_2561.method_43470((String)"Health Alarm")).option(ConfigScreenBuilder.createHealthAlarmEnabledOption(config)).option(ConfigScreenBuilder.createHealthAlarmThresholdOption(config)).option(ConfigScreenBuilder.createHealthAlarmSoundIntervalOption(config)).build();
    }

    private static ConfigCategory createEffectAlarmCategory(ModConfig config) {
        return ConfigCategory.createBuilder().name((class_2561)class_2561.method_43470((String)"Effect Alarm")).option(ConfigScreenBuilder.createEffectAlarmEnabledOption(config)).option(ConfigScreenBuilder.createEffectAlarmThresholdsOption(config)).option(ConfigScreenBuilder.createEffectAlarmSoundIntervalOption(config)).build();
    }

    private static ConfigCategory createPrivateMessagingCategory(ModConfig config) {
        return ConfigCategory.createBuilder().name((class_2561)class_2561.method_43470((String)"Private Messaging")).option(ConfigScreenBuilder.createPrivateMessagingEnabledOption(config)).option(ConfigScreenBuilder.createAlwaysFallbackToVanillaOption(config)).option(ConfigScreenBuilder.createFallbackVanillaCommandOption(config)).option(ConfigScreenBuilder.createFallbackCommandSyntaxOption(config)).option(ConfigScreenBuilder.createIncomingFormatOption(config)).option(ConfigScreenBuilder.createOutgoingFormatOption(config)).build();
    }

    private static ConfigCategory createGlobalChatCategory(ModConfig config) {
        return ConfigCategory.createBuilder().name((class_2561)class_2561.method_43470((String)"Global Chat")).option(ConfigScreenBuilder.createGlobalChatEnabledOption(config)).option(ConfigScreenBuilder.createGlobalChatPrefixOption(config)).option(ConfigScreenBuilder.createGlobalChatMessageFormatOption(config)).option(ConfigScreenBuilder.createGlobalChatOwnMessageFormatOption(config)).build();
    }

    private static Option<Logger.LogLevel> createLogLevelOption(ModConfig config) {
        return Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Log Level")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Set the minimum severity level for log messages")})).binding((Object)ModConstants.Defaults.LOG_LEVEL, () -> config.general.logLevel, value -> {
            config.general.logLevel = value;
        }).customController(opt -> new EnumDropdownController(opt, level -> class_2561.method_43470((String)level.name()))).build();
    }

    private static Option<Boolean> createPlayerTabGlowEnabledOption(ModConfig config) {
        return Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Enabled")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Enable the player head outline feature")})).binding((Object)false, () -> config.playerTabGlow.enabled, value -> {
            config.playerTabGlow.enabled = value;
        }).customController(opt -> new BooleanController(opt, true)).build();
    }

    private static Option<Color> createPlayerTabGlowColorOption(ModConfig config) {
        return Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Glow Color")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Change the color shown around players' heads in the tab list")})).binding((Object)ModConstants.Defaults.PLAYER_TAB_GLOW_COLOR, () -> config.playerTabGlow.color, value -> {
            config.playerTabGlow.color = value;
        }).customController(opt -> new ColorController(opt, true)).build();
    }

    private static Option<Boolean> createCustomBrandEnabledOption(ModConfig config) {
        return Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Enabled")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Enable custom client brand")})).binding((Object)false, () -> config.customBrand.enabled, value -> {
            config.customBrand.enabled = value;
        }).customController(opt -> new BooleanController(opt, true)).build();
    }

    private static Option<String> createCustomBrandOption(ModConfig config) {
        return Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Brand Text")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Custom brand text to display")})).binding((Object)"fabric", () -> config.customBrand.brand, value -> {
            config.customBrand.brand = value;
        }).customController(StringController::new).build();
    }

    private static Option<Boolean> createAutoRespawnEnabledOption(ModConfig config) {
        return Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Enabled")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Automatically respawn after death")})).binding((Object)false, () -> config.autoRespawn.enabled, value -> {
            config.autoRespawn.enabled = value;
        }).customController(opt -> new BooleanController(opt, true)).build();
    }

    private static Option<Integer> createAutoRespawnDelayOption(ModConfig config) {
        return Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Respawn Delay")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Delay before auto respawn (in milliseconds)")})).binding((Object)1000, () -> config.autoRespawn.delay, value -> {
            config.autoRespawn.delay = value;
        }).customController(option -> new IntegerSliderController(option, 100, 10000, 100)).build();
    }

    private static Option<Boolean> createCongraterEnabledOption(ModConfig config) {
        return Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Enabled")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Automatically send messages on death/kill")})).binding((Object)false, () -> config.congrater.enabled, value -> {
            config.congrater.enabled = value;
        }).customController(opt -> new BooleanController(opt, true)).build();
    }

    private static Option<Boolean> createSendDeathMessageOption(ModConfig config) {
        return Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Send Death Message")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Send message when you die")})).binding((Object)true, () -> config.congrater.sendDeathMessage, value -> {
            config.congrater.sendDeathMessage = value;
        }).customController(opt -> new BooleanController(opt, true)).build();
    }

    private static Option<String> createDeathMessageOption(ModConfig config) {
        return Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Death Message")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Message to send when you die")})).binding((Object)"gg", () -> config.congrater.deathMessage, value -> {
            config.congrater.deathMessage = value;
        }).customController(StringController::new).build();
    }

    private static Option<Boolean> createSendKillMessageOption(ModConfig config) {
        return Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Send Kill Message")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Send message when you kill someone")})).binding((Object)true, () -> config.congrater.sendKillMessage, value -> {
            config.congrater.sendKillMessage = value;
        }).customController(opt -> new BooleanController(opt, true)).build();
    }

    private static Option<String> createKillMessageOption(ModConfig config) {
        return Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Kill Message")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Message to send when you kill someone")})).binding((Object)"gg ez", () -> config.congrater.killMessage, value -> {
            config.congrater.killMessage = value;
        }).customController(StringController::new).build();
    }

    private static Option<Integer> createCongraterMessageDelayOption(ModConfig config) {
        return Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Message Delay")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Delay before sending congrater messages (in milliseconds)")})).binding((Object)500, () -> config.congrater.messageDelay, value -> {
            config.congrater.messageDelay = value;
        }).customController(option -> new IntegerSliderController(option, 0, 5000, 50)).build();
    }

    private static Option<Boolean> createHealthAlarmEnabledOption(ModConfig config) {
        return Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Enabled")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Play alarm when health is low")})).binding((Object)false, () -> config.healthAlarm.enabled, value -> {
            config.healthAlarm.enabled = value;
        }).customController(opt -> new BooleanController(opt, true)).build();
    }

    private static Option<Integer> createHealthAlarmThresholdOption(ModConfig config) {
        return Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Health Threshold")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Health level (in half hearts) to trigger alarm")})).binding((Object)6, () -> config.healthAlarm.threshold, value -> {
            config.healthAlarm.threshold = value;
        }).customController(option -> new IntegerSliderController(option, 1, 20, 1)).build();
    }

    private static Option<Integer> createHealthAlarmSoundIntervalOption(ModConfig config) {
        return Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Sound Interval")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Interval between alarm sounds (in seconds)")})).binding((Object)5, () -> config.healthAlarm.soundInterval, value -> {
            config.healthAlarm.soundInterval = value;
        }).customController(option -> new IntegerSliderController(option, 1, 60, 1)).build();
    }

    private static Option<Boolean> createEffectAlarmEnabledOption(ModConfig config) {
        return Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Enabled")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Play alarm when effects are running out")})).binding((Object)false, () -> config.effectAlarm.enabled, value -> {
            config.effectAlarm.enabled = value;
        }).customController(opt -> new BooleanController(opt, true)).build();
    }

    private static Option<Integer> createEffectAlarmThresholdsOption(ModConfig config) {
        return Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Effect Threshold")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Time remaining (in seconds) to trigger alarm")})).binding((Object)15, () -> config.effectAlarm.thresholds, value -> {
            config.effectAlarm.thresholds = value;
        }).customController(option -> new IntegerSliderController(option, 1, 60, 1)).build();
    }

    private static Option<Integer> createEffectAlarmSoundIntervalOption(ModConfig config) {
        return Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Sound Interval")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Interval between alarm sounds (in seconds)")})).binding((Object)5, () -> config.effectAlarm.soundInterval, value -> {
            config.effectAlarm.soundInterval = value;
        }).customController(option -> new IntegerSliderController(option, 1, 60, 1)).build();
    }

    private static Option<Boolean> createPrivateMessagingEnabledOption(ModConfig config) {
        return Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Enabled")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Enable private messaging features")})).binding((Object)true, () -> config.privateMessaging.enabled, value -> {
            config.privateMessaging.enabled = value;
        }).customController(opt -> new BooleanController(opt, true)).build();
    }

    private static Option<Boolean> createAlwaysFallbackToVanillaOption(ModConfig config) {
        return Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Always Fallback to Vanilla")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Always use vanilla commands for private messaging")})).binding((Object)false, () -> config.privateMessaging.alwaysFallbackToVanilla, value -> {
            config.privateMessaging.alwaysFallbackToVanilla = value;
        }).customController(opt -> new BooleanController(opt, true)).build();
    }

    private static Option<String> createFallbackVanillaCommandOption(ModConfig config) {
        return Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Fallback Command")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Vanilla command to use for private messaging")})).binding((Object)"msg", () -> config.privateMessaging.fallbackVanillaCommand, value -> {
            config.privateMessaging.fallbackVanillaCommand = value;
        }).customController(StringController::new).build();
    }

    private static Option<String> createFallbackCommandSyntaxOption(ModConfig config) {
        return Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Command Syntax")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Syntax for fallback command: {command} {player} {message}")})).binding((Object)"{command} {player} {message}", () -> config.privateMessaging.fallbackCommandSyntax, value -> {
            config.privateMessaging.fallbackCommandSyntax = value;
        }).customController(StringController::new).build();
    }

    private static Option<String> createIncomingFormatOption(ModConfig config) {
        return Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Incoming Message Format")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Format for incoming private messages")})).binding((Object)"{sender} whispers to you: \u00a7r{message}", () -> config.privateMessaging.incomingFormat, value -> {
            config.privateMessaging.incomingFormat = value;
        }).customController(StringController::new).build();
    }

    private static Option<String> createOutgoingFormatOption(ModConfig config) {
        return Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Outgoing Message Format")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Format for outgoing private messages")})).binding((Object)"You whisper to {recipient}: \u00a7r{message}", () -> config.privateMessaging.outgoingFormat, value -> {
            config.privateMessaging.outgoingFormat = value;
        }).customController(StringController::new).build();
    }

    private static Option<Boolean> createGlobalChatEnabledOption(ModConfig config) {
        return Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Global Chat Enabled")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Enable encrypted global chat across all connected players")})).binding((Object)false, () -> config.globalChat.enabled, value -> {
            config.globalChat.enabled = value;
        }).customController(BooleanController::new).build();
    }

    private static Option<String> createGlobalChatPrefixOption(ModConfig config) {
        return Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Global Chat Prefix")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Prefix displayed before global chat messages")})).binding((Object)"\u00a78[\u00a76Global\u00a78]\u00a7r", () -> config.globalChat.prefix, value -> {
            config.globalChat.prefix = value;
        }).customController(StringController::new).build();
    }

    private static Option<String> createGlobalChatMessageFormatOption(ModConfig config) {
        return Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Message Format")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Format for displaying global chat messages. Use {prefix}, {sender}, {message}")})).binding((Object)"{prefix} \u00a77{sender}\u00a7r: {message}", () -> config.globalChat.messageFormat, value -> {
            config.globalChat.messageFormat = value;
        }).customController(StringController::new).build();
    }

    private static Option<String> createGlobalChatOwnMessageFormatOption(ModConfig config) {
        return Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Own Message Format")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Format for displaying your own global chat messages. Use {prefix}, {message}")})).binding((Object)"{prefix} \u00a77You\u00a7r: {message}", () -> config.globalChat.ownMessageFormat, value -> {
            config.globalChat.ownMessageFormat = value;
        }).customController(StringController::new).build();
    }
}

