/*
 * Decompiled with CFR 0.152.
 */
package wuemeli.utils.updater;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import wuemeli.utils.updater.ModrinthData;
import wuemeli.utils.updater.UpdateContext;

@Environment(value=EnvType.CLIENT)
public class ModrinthUpdateSource {
    private final String projectId;

    public ModrinthUpdateSource(String projectId) {
        this.projectId = projectId;
    }

    public CompletableFuture<ModrinthData> checkUpdate() {
        return CompletableFuture.supplyAsync(() -> {
            int updatePreference = 0;
            String currentVersion = UpdateContext.getCurrentVersion();
            if (UpdateContext.getStream().equalsIgnoreCase("beta")) {
                updatePreference = 2;
            } else if (UpdateContext.getStream().equalsIgnoreCase("release")) {
                updatePreference = 1;
            }
            try {
                URL url = new URL("https://api.modrinth.com/v2/project/" + this.projectId + "/version");
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("Accept", "application/json");
                if (connection.getResponseCode() == 200) {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    JsonArray versions = JsonParser.parseReader((Reader)reader).getAsJsonArray();
                    reader.close();
                    JsonObject selectedVersion = null;
                    for (JsonElement version : versions) {
                        boolean isStable;
                        JsonObject versionObj = version.getAsJsonObject();
                        String versionNumber = versionObj.get("version_number").getAsString();
                        boolean bl = isStable = !versionObj.get("version_type").getAsString().equalsIgnoreCase("beta");
                        if ((updatePreference != 1 || !isStable) && updatePreference != 2) continue;
                        if (currentVersion.equals(versionNumber)) {
                            System.out.println("No update needed, latest version already installed: " + currentVersion);
                            return null;
                        }
                        selectedVersion = versionObj;
                        break;
                    }
                    if (selectedVersion != null) {
                        JsonArray files = selectedVersion.getAsJsonArray("files");
                        for (JsonElement file : files) {
                            JsonObject fileObj = file.getAsJsonObject();
                            if (!fileObj.get("primary").getAsBoolean()) continue;
                            return new ModrinthData(selectedVersion.get("version_number").getAsString(), fileObj.get("url").getAsString(), fileObj.get("filename").getAsString());
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        });
    }
}

