/*
 * Decompiled with CFR 0.152.
 */
package wuemeli.utils.updater;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import wuemeli.utils.updater.UpdateAction;

@Environment(value=EnvType.CLIENT)
public class ShutdownHookManager {
    private static boolean isHookRegistered = false;
    private static List<UpdateAction> actions;
    private static File updaterJar;
    private static boolean cancelled;
    private static String identifier;
    private static UUID uuid;

    public static synchronized void setExitHook(String identifier, UUID uuid, File updaterJar, List<UpdateAction> actions) {
        if (!isHookRegistered) {
            Runtime.getRuntime().addShutdownHook(new Thread(ShutdownHookManager::runExitHook));
            isHookRegistered = true;
        }
        ShutdownHookManager.identifier = identifier;
        ShutdownHookManager.uuid = uuid;
        cancelled = false;
        ShutdownHookManager.actions = actions;
        ShutdownHookManager.updaterJar = updaterJar;
    }

    private static synchronized String[] buildInvocation() {
        String javaBinary = new File(System.getProperty("java.home"), "bin/java" + (System.getProperty("os.name", "").startsWith("Windows") ? ".exe" : "")).getAbsolutePath();
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(javaBinary);
        arguments.add("-jar");
        arguments.add(updaterJar.getAbsolutePath());
        arguments.add(identifier);
        arguments.add(uuid.toString());
        actions.forEach(action -> action.encode(arguments));
        return arguments.toArray(new String[0]);
    }

    private static void runExitHook() {
        if (!cancelled) {
            try {
                Runtime.getRuntime().exec(ShutdownHookManager.buildInvocation());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    static {
        cancelled = false;
    }
}

