/*
 * Decompiled with CFR 0.152.
 */
package wuemeli.utils.updater;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import wuemeli.utils.updater.ModrinthData;
import wuemeli.utils.updater.ModrinthUpdateSource;
import wuemeli.utils.updater.UpdateSetup;
import wuemeli.utils.updater.UpdateTarget;

@Environment(value=EnvType.CLIENT)
public class UpdateContext {
    private final ModrinthUpdateSource source;
    private static String currentVersion;
    private static String stream;
    private final String identifier;
    private final UpdateTarget target;

    public UpdateContext(String projectId, String currentVersion, String stream, String identifier, UpdateTarget target) {
        this.source = new ModrinthUpdateSource(projectId);
        UpdateContext.currentVersion = currentVersion;
        UpdateContext.stream = stream;
        this.identifier = identifier;
        this.target = target;
    }

    public static String getCurrentVersion() {
        return currentVersion;
    }

    public static String getStream() {
        return stream;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public UpdateTarget getTarget() {
        return this.target;
    }

    public void setStream(String stream) {
        UpdateContext.stream = stream;
    }

    public void cleanup() {
        File file = new File(".autoupdates", this.identifier).getAbsoluteFile();
        try {
            if (!file.exists()) {
                return;
            }
            Files.walkFileTree(file.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public CompletableFuture<UpdateSetup> checkUpdate() {
        return this.source.checkUpdate().thenApply(it -> {
            if (it == null) {
                return null;
            }
            return new UpdateSetup((ModrinthData)it, this);
        });
    }
}

