/*
 * Decompiled with CFR 0.152.
 */
package wuemeli.utils.updater;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import wuemeli.utils.updater.ModrinthData;
import wuemeli.utils.updater.ShutdownHookManager;
import wuemeli.utils.updater.UpdateContext;

@Environment(value=EnvType.CLIENT)
public class UpdateSetup {
    private final ModrinthData update;
    private final UpdateContext context;
    private final UUID updateUUID = UUID.randomUUID();

    public UpdateSetup(ModrinthData update, UpdateContext context) {
        this.update = update;
        this.context = context;
    }

    public ModrinthData getUpdate() {
        return this.update;
    }

    public File getTempJarFile() {
        return this.getFile("temp.jar");
    }

    private File getFile(String name) {
        this.getUpdateDirectory().mkdirs();
        return new File(this.getUpdateDirectory(), name);
    }

    public File getUpdateDirectory() {
        return new File(".autoupdates", this.context.getIdentifier() + "/" + String.valueOf(this.updateUUID));
    }

    public CompletableFuture<Void> launchUpdate() {
        return CompletableFuture.runAsync(() -> {
            try {
                this.executeUpdate();
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
        });
    }

    public void executeUpdate() throws IOException {
        this.prepareUpdate();
        this.executeUpdater();
    }

    public void prepareUpdate() throws IOException {
        this.extractUpdater();
        this.downloadUpdate();
    }

    public void extractUpdater() throws IOException {
        try (InputStream from = this.getClass().getResourceAsStream("/updater.jar");
             FileOutputStream to = new FileOutputStream(this.getFile("updater.jar"));){
            int bytesRead;
            if (from == null) {
                throw new IOException("Could not find updater.jar in resources");
            }
            byte[] buffer = new byte[4096];
            while ((bytesRead = from.read(buffer)) != -1) {
                to.write(buffer, 0, bytesRead);
            }
        }
    }

    private void downloadUpdate() {
        try (InputStream from = this.update.getDownloadUrl().openStream();
             FileOutputStream to = new FileOutputStream(this.getTempJarFile());){
            int bytesRead;
            byte[] buffer = new byte[4096];
            while ((bytesRead = from.read(buffer)) != -1) {
                to.write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void executeUpdater() {
        ShutdownHookManager.setExitHook(this.context.getIdentifier(), this.updateUUID, this.getFile("updater.jar"), this.context.getTarget().createActions(this));
    }
}

