/*
 * Decompiled with CFR 0.152.
 */
package wuemeli.utils.updater;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import wuemeli.utils.updater.ReplaceWithNewUpdateTarget;
import wuemeli.utils.updater.UpdateAction;
import wuemeli.utils.updater.UpdateSetup;

@Environment(value=EnvType.CLIENT)
public interface UpdateTarget {
    public List<UpdateAction> createActions(UpdateSetup var1);

    public static UpdateTarget deleteAndSaveInTheSameFolder(Class<?> containedClass) {
        File file = UpdateTarget.getJarFileContainingClass(containedClass);
        return new ReplaceWithNewUpdateTarget(file);
    }

    public static File getJarFileContainingClass(Class<?> clazz) {
        URL location = clazz.getProtectionDomain().getCodeSource().getLocation();
        if (location == null) {
            return null;
        }
        String path = location.toString();
        if ((path = path.split("!", 2)[0]).startsWith("jar:")) {
            path = path.substring(4);
        }
        try {
            return new File(new URI(path));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }
}

