/*
 * Decompiled with CFR 0.152.
 */
package wuemeli.utils;

import java.util.List;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

@Environment(value=EnvType.CLIENT)
public class IMixinPlugin
implements IMixinConfigPlugin {
    private static boolean feather;
    private static boolean lunar;
    private static MinecraftVersion mcver;

    public void onLoad(String mixinPackage) {
        FabricLoader loader = FabricLoader.getInstance();
        feather = loader.getModContainer("feather").isPresent() || loader.getModContainer("feather-loader").isPresent();
        try {
            Class.forName("com.moonsworth.client.javafx.MicrosoftAuthApp");
            lunar = true;
        }
        catch (Exception e) {
            lunar = false;
        }
        try {
            Version ver = ((ModContainer)loader.getModContainer("minecraft").orElseThrow()).getMetadata().getVersion();
            if (ver.compareTo((Object)Version.parse((String)"1.21.3")) >= 0) {
                mcver = MinecraftVersion.MC1213;
            } else if (ver.compareTo((Object)Version.parse((String)"1.21.1")) >= 0) {
                mcver = MinecraftVersion.MC1211;
            } else if (ver.compareTo((Object)Version.parse((String)"1.20.2")) >= 0) {
                mcver = MinecraftVersion.MC1202;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getRefMapperConfig() {
        return "";
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (mixinClassName.contains("NoLF")) {
            return !feather && !lunar;
        }
        if (mixinClassName.contains("1213")) {
            return mcver == MinecraftVersion.MC1213;
        }
        if (mixinClassName.contains("1211")) {
            return mcver == MinecraftVersion.MC1211;
        }
        if (mixinClassName.contains("1202")) {
            return mcver == MinecraftVersion.MC1202;
        }
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return List.of();
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    @Environment(value=EnvType.CLIENT)
    private static enum MinecraftVersion {
        MC1202,
        MC1211,
        MC1213;

    }
}

