/*
 * Decompiled with CFR 0.152.
 */
package wuemeli.utils;

import com.mojang.brigadier.CommandDispatcher;
import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import dev.firstdark.rpc.DiscordRpc;
import dev.firstdark.rpc.enums.ActivityType;
import dev.firstdark.rpc.enums.ErrorCode;
import dev.firstdark.rpc.handlers.DiscordEventHandler;
import dev.firstdark.rpc.models.DiscordJoinRequest;
import dev.firstdark.rpc.models.DiscordRichPresence;
import dev.firstdark.rpc.models.User;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import dev.isxander.yacl3.config.v2.api.serializer.GsonConfigSerializerBuilder;
import dev.isxander.yacl3.gui.controllers.BooleanController;
import dev.isxander.yacl3.gui.controllers.ColorController;
import dev.isxander.yacl3.gui.controllers.dropdown.EnumDropdownController;
import dev.isxander.yacl3.gui.controllers.slider.IntegerSliderController;
import dev.isxander.yacl3.gui.controllers.string.StringController;
import io.sentry.Sentry;
import io.sentry.SentryLevel;
import java.awt.Color;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import wuemeli.utils.alarm.Alarm;
import wuemeli.utils.alarm.EffectAlarm;
import wuemeli.utils.autorespawn.AutoRespawn;
import wuemeli.utils.congrater.Congrater;
import wuemeli.utils.connection.ConnectionManager;
import wuemeli.utils.cosmetics.ParticleRenderer;
import wuemeli.utils.logger.Logger;
import wuemeli.utils.privatemsg.PrivateMessageCommand;
import wuemeli.utils.privatemsg.PrivateMessageManager;
import wuemeli.utils.updater.UpdateContext;
import wuemeli.utils.updater.UpdateTarget;

@Environment(value=EnvType.CLIENT)
public class Main
implements ModMenuApi,
ClientModInitializer {
    private static final UpdateContext UPDATE_CONTEXT;
    @SerialEntry
    public static boolean playerTabGlowEnabled;
    @SerialEntry
    public static Color playerTabGlowColor;
    @SerialEntry
    public static boolean customBrandEnabled;
    @SerialEntry
    public static String customBrand;
    @SerialEntry
    public static boolean autoRespawnEnabled;
    @SerialEntry
    public static int autoRespawnDelay;
    @SerialEntry
    public static boolean congraterEnabled;
    @SerialEntry
    public static String deathMessage;
    @SerialEntry
    public static String killMessage;
    @SerialEntry
    public static boolean sendDeathMessage;
    @SerialEntry
    public static boolean sendKillMessage;
    @SerialEntry
    public static int congraterMessageDelay;
    @SerialEntry
    public static boolean healthAlarmEnabled;
    @SerialEntry
    public static int healthAlarmThreshold;
    @SerialEntry
    public static int healthAlarmSoundInterval;
    @SerialEntry
    public static boolean effectAlarmEnabled;
    @SerialEntry
    public static int effectAlarmThresholds;
    @SerialEntry
    public static int effectAlarmSoundInterval;
    @SerialEntry
    public static boolean privateMessagingEnabled;
    @SerialEntry
    public static boolean alwaysFallbackToVanilla;
    @SerialEntry
    public static String fallbackVanillaCommand;
    @SerialEntry
    public static String fallbackCommandSyntax;
    @SerialEntry
    public static String privateMessageIncomingFormat;
    @SerialEntry
    public static String privateMessageOutgoingFormat;
    @SerialEntry
    public static Logger.LogLevel logLevel;
    @SerialEntry
    public static boolean cosmeticsEnabled;
    @SerialEntry
    public static int particleTickInterval;
    public static final ConfigClassHandler<Main> CONFIG;

    public void onInitializeClient() {
        Sentry.init(options -> {
            options.setDsn("https://8f8cc205d6144a2084d18aa94614af5c@gossip.wuemeli.com/42");
            options.setRelease("1.0.3");
            options.setDebug(false);
            options.setDiagnosticLevel(SentryLevel.ERROR);
        });
        try {
            UPDATE_CONTEXT.cleanup();
            UPDATE_CONTEXT.checkUpdate().thenAccept(potentialUpdate -> {
                if (potentialUpdate != null) {
                    potentialUpdate.launchUpdate();
                    Logger.info("Update will be applied after application closes");
                } else {
                    Logger.info("No updates available");
                }
            });
            CONFIG.load();
            final DiscordRpc rpc = new DiscordRpc();
            rpc.setDebugMode(false);
            DiscordEventHandler handler = new DiscordEventHandler(){

                public void ready(User user) {
                    DiscordRichPresence presence = DiscordRichPresence.builder().details("Playing Minecraft with Wuemeli's Utils").activityType(ActivityType.PLAYING).largeImageKey("flower").button(DiscordRichPresence.RPCButton.of((String)"Download mod", (String)"https://modrinth.com/mod/wuemelis-utils")).build();
                    rpc.updatePresence(presence);
                }

                public void disconnected(ErrorCode errorCode, String message) {
                    Logger.error("Discord RPC disconnected: " + String.valueOf(errorCode) + " - " + message);
                }

                public void errored(ErrorCode errorCode, String message) {
                    Logger.error("Discord RPC error: " + String.valueOf(errorCode) + " - " + message);
                }

                public void joinGame(String joinSecret) {
                }

                public void spectateGame(String spectateSecret) {
                }

                public void joinRequest(DiscordJoinRequest joinRequest) {
                }
            };
            rpc.init("1385698721936965757", handler, false);
            Logger.info("Initializing Wuemeli's Utils");
            ConnectionManager.init();
            AutoRespawn.init();
            PrivateMessageManager.init();
            Congrater.init();
            Alarm.init();
            EffectAlarm.init();
            ParticleRenderer.init();
            ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> PrivateMessageCommand.register((CommandDispatcher<FabricClientCommandSource>)dispatcher));
            Logger.info("Wuemeli's Utils initialization complete");
        }
        catch (Exception e) {
            Logger.error("Error during initialization: " + e.getMessage());
        }
    }

    public ConfigScreenFactory<?> getModConfigScreenFactory() {
        return parent -> YetAnotherConfigLib.create(CONFIG, (defaults, config, builder) -> builder.save(() -> CONFIG.save()).title((class_2561)class_2561.method_43470((String)"Wuemeli's Utils")).category(ConfigCategory.createBuilder().name((class_2561)class_2561.method_43470((String)"General")).option(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Log Level")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Set the minimum severity level for log messages")})).binding((Object)logLevel, () -> logLevel, value -> {
            logLevel = value;
        }).customController(opt -> new EnumDropdownController(opt, level -> class_2561.method_43470((String)level.name()))).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Cosmetics Enabled")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Enable cosmetics for cool players")})).binding((Object)cosmeticsEnabled, () -> cosmeticsEnabled, value -> {
            cosmeticsEnabled = value;
        }).customController(opt -> new BooleanController(opt, true)).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Particle Tick Interval")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"How often to render particles (in ticks, 20 ticks = 1 second)")})).binding((Object)particleTickInterval, () -> particleTickInterval, value -> {
            particleTickInterval = value;
        }).customController(option -> new IntegerSliderController(option, 1, 60, 1)).build()).build()).category(ConfigCategory.createBuilder().name((class_2561)class_2561.method_43470((String)"Player Tab Glow")).option(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Enabled")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Enable the player head outline feature")})).binding((Object)playerTabGlowEnabled, () -> playerTabGlowEnabled, value -> {
            playerTabGlowEnabled = value;
        }).customController(opt -> new BooleanController(opt, true)).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Glow Color")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Change the color shown around players' heads in the tab list")})).binding((Object)playerTabGlowColor, () -> playerTabGlowColor, value -> {
            playerTabGlowColor = value;
        }).customController(opt -> new ColorController(opt, true)).build()).build()).category(ConfigCategory.createBuilder().name((class_2561)class_2561.method_43470((String)"Custom Client Brand")).option(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Enabled")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Enable custom client brand feature")})).binding((Object)customBrandEnabled, () -> customBrandEnabled, value -> {
            customBrandEnabled = value;
        }).customController(opt -> new BooleanController(opt, true)).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Custom Brand")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"The custom client brand to use")})).binding((Object)customBrand, () -> customBrand, value -> {
            customBrand = value;
        }).customController(StringController::new).build()).build()).category(ConfigCategory.createBuilder().name((class_2561)class_2561.method_43470((String)"Auto Respawn")).option(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Enabled")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Enable the auto respawn feature")})).binding((Object)autoRespawnEnabled, () -> autoRespawnEnabled, value -> {
            autoRespawnEnabled = value;
        }).customController(opt -> new BooleanController(opt, true)).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Respawn Delay")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"How long to wait before respawning (in milliseconds)")})).binding((Object)autoRespawnDelay, () -> autoRespawnDelay, value -> {
            autoRespawnDelay = value;
        }).customController(option -> new IntegerSliderController(option, 0, 10000, 100)).build()).build()).category(ConfigCategory.createBuilder().name((class_2561)class_2561.method_43470((String)"Congrater")).option(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Enabled")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Enable automatic messages on death/kill")})).binding((Object)congraterEnabled, () -> congraterEnabled, value -> {
            congraterEnabled = value;
        }).customController(opt -> new BooleanController(opt, true)).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Send Death Message")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Send custom message when you die")})).binding((Object)sendDeathMessage, () -> sendDeathMessage, value -> {
            sendDeathMessage = value;
        }).customController(opt -> new BooleanController(opt, true)).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Death Message")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Message to send when you die")})).binding((Object)deathMessage, () -> deathMessage, value -> {
            deathMessage = value;
        }).customController(StringController::new).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Send Kill Message")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Send custom message when you kill someone")})).binding((Object)sendKillMessage, () -> sendKillMessage, value -> {
            sendKillMessage = value;
        }).customController(opt -> new BooleanController(opt, true)).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Kill Message")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Message to send when you kill someone")})).binding((Object)killMessage, () -> killMessage, value -> {
            killMessage = value;
        }).customController(StringController::new).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Message Delay")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"How long to wait before sending death message (in milliseconds)")})).binding((Object)congraterMessageDelay, () -> congraterMessageDelay, value -> {
            congraterMessageDelay = value;
        }).customController(option -> new IntegerSliderController(option, 0, 5000, 100)).build()).build()).category(ConfigCategory.createBuilder().name((class_2561)class_2561.method_43470((String)"Alarm")).option(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Enable Health Alarm")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Enable low health alarm")})).binding((Object)healthAlarmEnabled, () -> healthAlarmEnabled, value -> {
            healthAlarmEnabled = value;
        }).customController(opt -> new BooleanController(opt, true)).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Health Alarm Threshold")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Health threshold to trigger alarm (in half hearts)")})).binding((Object)healthAlarmThreshold, () -> healthAlarmThreshold, value -> {
            healthAlarmThreshold = value;
        }).customController(option -> new IntegerSliderController(option, 1, 20, 1)).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Health Alarm Sound Interval")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"How often to play alarm sound (in ticks, 20 ticks = 1 second)")})).binding((Object)healthAlarmSoundInterval, () -> healthAlarmSoundInterval, value -> {
            healthAlarmSoundInterval = value;
        }).customController(option -> new IntegerSliderController(option, 1, 20, 1)).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Enable Effect Alarm")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Enable potion effect expiration alarms")})).binding((Object)effectAlarmEnabled, () -> effectAlarmEnabled, value -> {
            effectAlarmEnabled = value;
        }).customController(opt -> new BooleanController(opt, true)).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Effect Alarm Thresholds")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"How many seconds before potion effect expires to trigger alarm (in seconds)")})).binding((Object)effectAlarmThresholds, () -> effectAlarmThresholds, value -> {
            effectAlarmThresholds = value;
        }).customController(opt -> new IntegerSliderController(opt, 1, 60, 1)).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Effect Alarm Sound Interval")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"How often to play effect alarm sound (in ticks, 20 ticks = 1 second)")})).binding((Object)effectAlarmSoundInterval, () -> effectAlarmSoundInterval, value -> {
            effectAlarmSoundInterval = value;
        }).customController(option -> new IntegerSliderController(option, 1, 60, 1)).build()).build()).category(ConfigCategory.createBuilder().name((class_2561)class_2561.method_43470((String)"Private Messaging")).option(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Enabled")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Enable encrypted private messaging")})).binding((Object)privateMessagingEnabled, () -> privateMessagingEnabled, value -> {
            privateMessagingEnabled = value;
        }).customController(opt -> new BooleanController(opt, true)).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Always Fallback to Vanilla")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Always use vanilla messaging instead of encrypted messaging")})).binding((Object)alwaysFallbackToVanilla, () -> alwaysFallbackToVanilla, value -> {
            alwaysFallbackToVanilla = value;
        }).customController(opt -> new BooleanController(opt, true)).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Fallback Vanilla Command")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"The vanilla command to use for messaging")})).binding((Object)fallbackVanillaCommand, () -> fallbackVanillaCommand, value -> {
            fallbackVanillaCommand = value;
        }).customController(StringController::new).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Fallback Command Syntax")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Syntax for fallback command. Use {command}, {player}, and {message} as placeholders")})).binding((Object)fallbackCommandSyntax, () -> fallbackCommandSyntax, value -> {
            fallbackCommandSyntax = value;
        }).customController(StringController::new).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Incoming Message Format")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Format for incoming messages. Use {sender} and {message} as placeholders")})).binding((Object)privateMessageIncomingFormat, () -> privateMessageIncomingFormat, value -> {
            privateMessageIncomingFormat = value;
        }).customController(StringController::new).build()).option(Option.createBuilder().name((class_2561)class_2561.method_43470((String)"Outgoing Message Format")).description(OptionDescription.of((class_2561[])new class_2561[]{class_2561.method_43470((String)"Format for outgoing messages. Use {recipient} and {message} as placeholders")})).binding((Object)privateMessageOutgoingFormat, () -> privateMessageOutgoingFormat, value -> {
            privateMessageOutgoingFormat = value;
        }).customController(StringController::new).build()).build())).generateScreen(parent);
    }

    static {
        playerTabGlowEnabled = false;
        playerTabGlowColor = new Color(0xFFFFFF);
        customBrandEnabled = false;
        customBrand = "fabric";
        autoRespawnEnabled = false;
        autoRespawnDelay = 1000;
        congraterEnabled = false;
        deathMessage = "gg";
        killMessage = "gg ez";
        sendDeathMessage = true;
        sendKillMessage = true;
        congraterMessageDelay = 500;
        healthAlarmEnabled = false;
        healthAlarmThreshold = 6;
        healthAlarmSoundInterval = 5;
        effectAlarmEnabled = false;
        effectAlarmThresholds = 15;
        effectAlarmSoundInterval = 5;
        privateMessagingEnabled = true;
        alwaysFallbackToVanilla = false;
        fallbackVanillaCommand = "msg";
        fallbackCommandSyntax = "{command} {player} {message}";
        privateMessageIncomingFormat = "{sender} whispers to you: \u00a7r{message}";
        privateMessageOutgoingFormat = "You whisper to {recipient}: \u00a7r{message}";
        logLevel = Logger.LogLevel.INFO;
        cosmeticsEnabled = true;
        particleTickInterval = 10;
        CONFIG = ConfigClassHandler.createBuilder(Main.class).serializer(config -> GsonConfigSerializerBuilder.create((ConfigClassHandler)config).setPath(FabricLoader.getInstance().getConfigDir().resolve("wuemeli.json")).build()).build();
        UPDATE_CONTEXT = new UpdateContext("Ueey2eHa", "1.0.3", "release", "Ueey2eHa", UpdateTarget.deleteAndSaveInTheSameFolder(UpdateTarget.class));
    }
}

