/*
 * Decompiled with CFR 0.152.
 */
package wuemeli.utils.congrater;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_310;
import net.minecraft.class_746;
import wuemeli.utils.Main;
import wuemeli.utils.logger.Logger;

@Environment(value=EnvType.CLIENT)
public class Congrater {
    private static boolean wasDead = false;
    private static boolean messageScheduled = false;
    private static long deathTime = 0L;

    public static void init() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (!Main.congraterEnabled || client.field_1724 == null) {
                Congrater.resetState();
                return;
            }
            if (Main.sendDeathMessage) {
                boolean isDead = client.field_1724.method_29504();
                if (isDead && !wasDead && !messageScheduled) {
                    wasDead = true;
                    messageScheduled = true;
                    deathTime = System.currentTimeMillis();
                    Logger.debug("Death detected, will send message in " + Main.congraterMessageDelay + "ms");
                } else if (isDead && messageScheduled && System.currentTimeMillis() - deathTime >= (long)Main.congraterMessageDelay) {
                    Congrater.sendChatMessage(client.field_1724, Main.deathMessage);
                    messageScheduled = false;
                    Logger.info("Death message sent");
                } else if (!isDead && wasDead) {
                    Congrater.resetState();
                }
            }
        });
    }

    private static void resetState() {
        wasDead = false;
        messageScheduled = false;
        deathTime = 0L;
    }

    public static void onPlayerKilled(String killerName) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || !Main.congraterEnabled || !Main.sendKillMessage) {
            return;
        }
        class_746 player = client.field_1724;
        if (player.method_5477().getString().equals(killerName)) {
            Logger.info("Player got a kill, sending kill message");
            Congrater.sendChatMessage(player, Main.killMessage);
        }
    }

    private static void sendChatMessage(class_746 player, String message) {
        if (message == null || message.isEmpty()) {
            return;
        }
        player.field_3944.method_45729(message);
    }
}

