/*
 * Decompiled with CFR 0.152.
 */
package wuemeli.utils.privatemsg;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import wuemeli.utils.Main;
import wuemeli.utils.privatemsg.PrivateMessageManager;

@Environment(value=EnvType.CLIENT)
public class PrivateMessageCommand {
    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"pmsg").then(ClientCommandManager.argument((String)"player", (ArgumentType)StringArgumentType.word()).then(ClientCommandManager.argument((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(PrivateMessageCommand::sendPrivateMessage))));
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"r").then(ClientCommandManager.argument((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(PrivateMessageCommand::sendReply)));
    }

    private static int sendPrivateMessage(CommandContext<FabricClientCommandSource> context) {
        String playerName = StringArgumentType.getString(context, (String)"player");
        String message = StringArgumentType.getString(context, (String)"message");
        PrivateMessageManager.setLastMessagedPlayer(playerName);
        PrivateMessageManager.sendPrivateMessage(playerName, message);
        if (!PrivateMessageManager.isUsingFallbackMode) {
            String formattedMessage = Main.privateMessageOutgoingFormat.replace("{recipient}", playerName).replace("{message}", message);
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)formattedMessage));
        }
        return 1;
    }

    private static int sendReply(CommandContext<FabricClientCommandSource> context) {
        String message = StringArgumentType.getString(context, (String)"message");
        String lastPlayer = PrivateMessageManager.getLastMessagedPlayer();
        if (lastPlayer == null || lastPlayer.isEmpty()) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"You have nobody to reply to"));
            return 0;
        }
        PrivateMessageManager.sendPrivateMessage(lastPlayer, message);
        if (!PrivateMessageManager.isUsingFallbackMode) {
            String formattedMessage = Main.privateMessageOutgoingFormat.replace("{recipient}", lastPlayer).replace("{message}", message);
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)formattedMessage));
        }
        return 1;
    }
}

