/*
 * Decompiled with CFR 0.152.
 */
package wuemeli.utils.updater;

import java.io.File;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public abstract class UpdateAction {
    private UpdateAction() {
    }

    public abstract void encode(List<String> var1);

    @Environment(value=EnvType.CLIENT)
    public static class MoveDownloadedFile
    extends UpdateAction {
        private final File sourceFile;
        private final File destinationFile;

        public MoveDownloadedFile(File sourceFile, File destinationFile) {
            this.sourceFile = sourceFile;
            this.destinationFile = destinationFile;
        }

        @Override
        public void encode(List<String> arguments) {
            arguments.add("move");
            arguments.add(this.sourceFile.getAbsolutePath());
            arguments.add(this.destinationFile.getAbsolutePath());
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class DeleteFile
    extends UpdateAction {
        private final File toDelete;

        public DeleteFile(File toDelete) {
            this.toDelete = toDelete;
        }

        @Override
        public void encode(List<String> arguments) {
            arguments.add("delete");
            arguments.add(this.toDelete.getAbsolutePath());
        }
    }
}

