/*
 * Decompiled with CFR 0.152.
 */
package com.example.client.gui;

import com.example.config.HotbarPriorityConfig;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.ConfigHolder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

@Environment(value=EnvType.CLIENT)
public class HotbarPriorityConfigScreen
extends class_437 {
    private static final int MAX_COLUMNS = 2;
    private static final int LABEL_WIDTH = 64;
    private static final int FIELD_WIDTH = 30;
    private static final int FIELD_HEIGHT = 20;
    private static final int RESET_BUTTON_WIDTH = 42;
    private static final int RESET_BUTTON_HEIGHT = 20;
    private static final int LABEL_FIELD_GAP = 6;
    private static final int FIELD_BUTTON_GAP = 6;
    private static final int COLUMN_GAP = 28;
    private static final int PANEL_MARGIN = 22;
    private static final int ROW_SPACING = 30;
    private static final int CONTENT_BOTTOM_PADDING = 96;
    private static final int CONTENT_TOP_PADDING = 48;
    private static final int MIN_TOP_MARGIN = 72;
    private static final int DEFAULT_ROWS_PER_COLUMN = 5;
    private static final int SLOT_COUNT = 10;
    private final class_437 parent;
    private final ConfigHolder<HotbarPriorityConfig> holder;
    private final List<SlotField> slotFields = new ArrayList<SlotField>();
    private class_4185 saveButton;
    private class_2561 errorText;
    private int baseY;
    private int firstColumnX;
    private int panelLeft;
    private int panelRight;
    private int panelTop;
    private int panelBottom;
    private int columnCount;
    private int rowsPerColumn;
    private int columnContentWidth;
    private int labelColumnWidth;

    public HotbarPriorityConfigScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"text.autoconfig.hotbarpriority.title"));
        this.parent = parent;
        this.holder = AutoConfig.getConfigHolder(HotbarPriorityConfig.class);
    }

    protected void method_25426() {
        int desiredColumns;
        int requiredWidth;
        int columns;
        super.method_25426();
        this.method_37067();
        this.slotFields.clear();
        int centerX = this.field_22789 / 2;
        ArrayList<class_5250> labels = new ArrayList<class_5250>(10);
        int maxLabelTextWidth = 0;
        for (int slot = 0; slot < 10; ++slot) {
            class_5250 label = class_2561.method_43469((String)"hotbarpriority.slot_label", (Object[])new Object[]{slot});
            labels.add(label);
            maxLabelTextWidth = Math.max(maxLabelTextWidth, this.field_22793.method_27525((class_5348)label));
        }
        this.labelColumnWidth = Math.max(64, maxLabelTextWidth + 6);
        int columnInnerWidth = this.labelColumnWidth + 6 + 30 + 6 + 42;
        int usableWidth = Math.max(columnInnerWidth, this.field_22789 - 44);
        for (columns = desiredColumns = Math.min(2, Math.max(1, 2)); columns > 1 && (requiredWidth = columns * columnInnerWidth + (columns - 1) * 28) > usableWidth; --columns) {
        }
        this.columnCount = Math.max(1, columns);
        this.rowsPerColumn = (int)Math.ceil(10.0 / (double)this.columnCount);
        this.columnContentWidth = columnInnerWidth;
        int totalColumnsWidth = this.columnCount * this.columnContentWidth + (this.columnCount - 1) * 28;
        this.firstColumnX = centerX - totalColumnsWidth / 2;
        this.panelLeft = Math.max(24, this.firstColumnX - 22);
        this.panelRight = Math.min(this.field_22789 - 24, this.firstColumnX + totalColumnsWidth + 22);
        int contentHeight = Math.max(5, this.rowsPerColumn) * 30;
        int idealBaseY = (this.field_22790 - contentHeight) / 2;
        int minBaseY = 72;
        int maxBaseY = Math.max(minBaseY, this.field_22790 - 96 - contentHeight - 24);
        this.baseY = Math.min(Math.max(idealBaseY, minBaseY), maxBaseY);
        this.panelTop = Math.max(24, this.baseY - 48);
        this.panelBottom = Math.min(this.field_22790 - 24, this.baseY + contentHeight + 96);
        HotbarPriorityConfig config = (HotbarPriorityConfig)this.holder.getConfig();
        for (int slot = 0; slot < 10; ++slot) {
            int columnX;
            int column = slot / this.rowsPerColumn;
            if (column >= this.columnCount) {
                column = this.columnCount - 1;
            }
            int row = slot % this.rowsPerColumn;
            int labelX = columnX = this.firstColumnX + column * (this.columnContentWidth + 28);
            int fieldX = labelX + this.labelColumnWidth + 6;
            int y = this.baseY + row * 30;
            Objects.requireNonNull(this.field_22793);
            int labelY = y + (20 - 9) / 2;
            int resetX = fieldX + 30 + 6;
            class_2561 label = (class_2561)labels.get(slot);
            class_342 field = new class_342(this.field_22793, fieldX, y, 30, 20, (class_2561)class_2561.method_43473());
            field.method_1880(1);
            field.method_1890(text -> text.isEmpty() || text.matches("[0-9]"));
            field.method_1852(String.valueOf(config.getSlotPriority(slot)));
            field.method_1863(value -> this.updateState());
            class_342 finalField = field;
            int finalSlot = slot;
            class_4185 resetButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"hotbarpriority.button.reset_slot"), b -> this.resetSlotToDefault(finalField, finalSlot)).method_46434(resetX, y, 42, 20).method_46431();
            SlotField entry = new SlotField(slot, label, field, labelX, labelY, resetButton);
            this.slotFields.add(entry);
            this.method_37063((class_364)field);
            this.method_37063((class_364)resetButton);
        }
        this.saveButton = null;
        this.updateState();
    }

    private void save() {
        Optional<class_2561> validationError = this.validateInput();
        if (validationError.isPresent()) {
            this.errorText = validationError.get();
            this.updateState();
            return;
        }
        HotbarPriorityConfig config = (HotbarPriorityConfig)this.holder.getConfig();
        for (SlotField slotField : this.slotFields) {
            int value = Integer.parseInt(slotField.field.method_1882());
            config.setSlotPriority(slotField.slotIndex, value);
        }
        this.commitConfig(config);
        this.method_25419();
    }

    private void cancel() {
        class_310.method_1551().method_1507(this.parent);
    }

    private void updateState() {
        Optional<class_2561> validationError = this.validateInput();
        this.errorText = validationError.orElse(null);
        if (this.saveButton != null) {
            this.saveButton.field_22763 = validationError.isEmpty();
        }
    }

    private Optional<class_2561> validateInput() {
        HashSet<Integer> seen = new HashSet<Integer>();
        for (SlotField slotField : this.slotFields) {
            int value;
            String raw = slotField.field.method_1882();
            if (raw == null || raw.isEmpty()) {
                return Optional.of(class_2561.method_43471((String)"hotbarpriority.error.missing"));
            }
            try {
                value = Integer.parseInt(raw);
            }
            catch (NumberFormatException ex) {
                return Optional.of(class_2561.method_43471((String)"hotbarpriority.error.out_of_range"));
            }
            if (value < 0 || value > 9) {
                return Optional.of(class_2561.method_43471((String)"hotbarpriority.error.out_of_range"));
            }
            if (seen.add(value)) continue;
            return Optional.of(class_2561.method_43469((String)"hotbarpriority.error.duplicate_value", (Object[])new Object[]{value}));
        }
        return Optional.empty();
    }

    private boolean commitConfig(HotbarPriorityConfig config) {
        try {
            config.ensureValid();
            this.holder.save();
            return true;
        }
        catch (ConfigData.ValidationException e) {
            this.errorText = class_2561.method_43471((String)"hotbarpriority.error.conflict").method_27692(class_124.field_1061);
            return false;
        }
    }

    private void resetSlotToDefault(class_342 field, int slotIndex) {
        field.method_1852(String.valueOf(HotbarPriorityConfig.getDefaultPriority(slotIndex)));
        this.updateState();
    }

    public void method_25419() {
        Optional<class_2561> validationError = this.validateInput();
        if (validationError.isEmpty()) {
            HotbarPriorityConfig config = (HotbarPriorityConfig)this.holder.getConfig();
            for (SlotField slotField : this.slotFields) {
                int value = Integer.parseInt(slotField.field.method_1882());
                config.setSlotPriority(slotField.slotIndex, value);
            }
            if (!this.commitConfig(config)) {
                return;
            }
        } else {
            this.errorText = validationError.get();
            this.updateState();
            return;
        }
        class_310.method_1551().method_1507(this.parent);
    }

    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float delta) {
        this.method_25420(drawContext, mouseX, mouseY, delta);
        drawContext.method_25294(this.panelLeft, this.panelTop, this.panelRight, this.panelBottom, -871362536);
        drawContext.method_25294(this.panelLeft, this.panelTop, this.panelRight, this.panelTop + 2, -10724097);
        drawContext.method_25294(this.panelLeft, this.panelBottom - 2, this.panelRight, this.panelBottom, -10724097);
        super.method_25394(drawContext, mouseX, mouseY, delta);
        drawContext.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, this.panelTop - 18, 0xFFFFFF);
        class_5250 instructions = class_2561.method_43471((String)"text.autoconfig.hotbarpriority.option.slotPriority.description").method_27692(class_124.field_1080);
        drawContext.method_27534(this.field_22793, (class_2561)instructions, this.field_22789 / 2, this.panelTop + 14, 0xAAAAAA);
        for (SlotField slotField : this.slotFields) {
            drawContext.method_51439(this.field_22793, slotField.label, slotField.labelX, slotField.labelY, 0xFFFFFF, false);
        }
        if (this.errorText != null) {
            drawContext.method_27534(this.field_22793, this.errorText, this.field_22789 / 2, this.panelBottom - 38, 0xFF5555);
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static final class SlotField {
        final int slotIndex;
        final class_2561 label;
        final class_342 field;
        final int labelX;
        final int labelY;
        final class_4185 resetButton;

        SlotField(int slotIndex, class_2561 label, class_342 field, int labelX, int labelY, class_4185 resetButton) {
            this.slotIndex = slotIndex;
            this.label = label;
            this.field = field;
            this.labelX = labelX;
            this.labelY = labelY;
            this.resetButton = resetButton;
        }
    }
}

