/*
 * Decompiled with CFR 0.152.
 */
package com.example.config;

import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;

@Config(name="hotbarpriority")
public class HotbarPriorityConfig
implements ConfigData {
    public int slot0Priority = 0;
    public int slot1Priority = 1;
    public int slot2Priority = 2;
    public int slot3Priority = 3;
    public int slot4Priority = 4;
    public int slot5Priority = 5;
    public int slot6Priority = 6;
    public int slot7Priority = 7;
    public int slot8Priority = 8;

    public int[] getSlotPriorities() {
        int[] slotPriorities = new int[9];
        for (int i = 0; i < 9; ++i) {
            slotPriorities[i] = this.getSlotPriority(i);
        }
        return slotPriorities;
    }

    public static int getDefaultPriority(int index) {
        if (index < 0 || index >= 9) {
            throw new IllegalArgumentException("Invalid hotbar slot index: " + index);
        }
        return index;
    }

    public int getSlotPriority(int index) {
        return switch (index) {
            case 0 -> this.slot0Priority;
            case 1 -> this.slot1Priority;
            case 2 -> this.slot2Priority;
            case 3 -> this.slot3Priority;
            case 4 -> this.slot4Priority;
            case 5 -> this.slot5Priority;
            case 6 -> this.slot6Priority;
            case 7 -> this.slot7Priority;
            case 8 -> this.slot8Priority;
            default -> throw new IllegalArgumentException("Invalid hotbar slot index: " + index);
        };
    }

    public void setSlotPriority(int index, int value) {
        switch (index) {
            case 0: {
                this.slot0Priority = value;
                break;
            }
            case 1: {
                this.slot1Priority = value;
                break;
            }
            case 2: {
                this.slot2Priority = value;
                break;
            }
            case 3: {
                this.slot3Priority = value;
                break;
            }
            case 4: {
                this.slot4Priority = value;
                break;
            }
            case 5: {
                this.slot5Priority = value;
                break;
            }
            case 6: {
                this.slot6Priority = value;
                break;
            }
            case 7: {
                this.slot7Priority = value;
                break;
            }
            case 8: {
                this.slot8Priority = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid hotbar slot index: " + index);
            }
        }
    }

    public void ensureValid() throws ConfigData.ValidationException {
        boolean[] seen = new boolean[10];
        for (int i = 0; i < 9; ++i) {
            int priority = this.getSlotPriority(i);
            if (priority < 0 || priority > 9) {
                throw new ConfigData.ValidationException("Priorities must be between 0 and 9.");
            }
            if (seen[priority]) {
                throw new ConfigData.ValidationException("Each priority value must be unique.");
            }
            seen[priority] = true;
        }
    }
}

