/*
 * Decompiled with CFR 0.152.
 */
package com.example.config;

import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;

@Config(name="hotbarpriority")
public class HotbarPriorityConfig
implements ConfigData {
    public int slot0Priority = 1;
    public int slot1Priority = 2;
    public int slot2Priority = 3;
    public int slot3Priority = 4;
    public int slot4Priority = 5;
    public int slot5Priority = 6;
    public int slot6Priority = 7;
    public int slot7Priority = 8;
    public int slot8Priority = 9;

    public int[] getSlotPriorities() {
        return new int[]{this.slot0Priority, this.slot1Priority, this.slot2Priority, this.slot3Priority, this.slot4Priority, this.slot5Priority, this.slot6Priority, this.slot7Priority, this.slot8Priority};
    }

    public static int getDefaultPriority(int index) {
        if (index < 0 || index >= 9) {
            throw new IllegalArgumentException("Invalid hotbar slot index: " + index);
        }
        return index + 1;
    }

    public int getSlotPriority(int index) {
        return switch (index) {
            case 0 -> this.slot0Priority;
            case 1 -> this.slot1Priority;
            case 2 -> this.slot2Priority;
            case 3 -> this.slot3Priority;
            case 4 -> this.slot4Priority;
            case 5 -> this.slot5Priority;
            case 6 -> this.slot6Priority;
            case 7 -> this.slot7Priority;
            case 8 -> this.slot8Priority;
            default -> throw new IllegalArgumentException("Invalid hotbar slot index: " + index);
        };
    }

    public void setSlotPriority(int index, int value) {
        switch (index) {
            case 0: {
                this.slot0Priority = value;
                break;
            }
            case 1: {
                this.slot1Priority = value;
                break;
            }
            case 2: {
                this.slot2Priority = value;
                break;
            }
            case 3: {
                this.slot3Priority = value;
                break;
            }
            case 4: {
                this.slot4Priority = value;
                break;
            }
            case 5: {
                this.slot5Priority = value;
                break;
            }
            case 6: {
                this.slot6Priority = value;
                break;
            }
            case 7: {
                this.slot7Priority = value;
                break;
            }
            case 8: {
                this.slot8Priority = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid hotbar slot index: " + index);
            }
        }
    }

    public void ensureValid() throws ConfigData.ValidationException {
        boolean[] seen = new boolean[10];
        for (int i = 0; i < 9; ++i) {
            int priority = this.getSlotPriority(i);
            if (priority < 1 || priority > 9) {
                throw new ConfigData.ValidationException("Priorities must be between 1 and 9.");
            }
            if (seen[priority]) {
                throw new ConfigData.ValidationException("Each priority value must be unique.");
            }
            seen[priority] = true;
        }
    }
}

