/*
 * Decompiled with CFR 0.152.
 */
package me.andy.chatmod.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Iterator;
import java.util.List;
import me.andy.chatmod.Broadcaster;
import me.andy.chatmod.config.BroadcasterConfig;
import me.andy.chatmod.config.ConfigManager;
import me.andy.chatmod.config.InfoFileConfig;
import me.andy.chatmod.config.MessagesConfig;
import me.andy.chatmod.config.PredefinedBroadcast;
import me.andy.chatmod.data.PlayerDataManager;
import me.andy.chatmod.event.PlayerJoinHandler;
import me.andy.chatmod.gui.PredefinedItemsInventory;
import me.andy.chatmod.info.InfoManager;
import me.andy.chatmod.manager.PredefinedBroadcastManager;
import me.andy.chatmod.manager.PredefinedItemManager;
import me.andy.chatmod.manager.ScheduledBroadcastManager;
import me.andy.chatmod.message.BroadcastManager;
import me.andy.chatmod.message.MessageFormatter;
import me.andy.chatmod.message.PlaceholderResolver;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1707;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3917;
import net.minecraft.class_5250;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_747;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class BroadcasterCommand {
    private static final String PERM_MODINFO = "chatmod.modinfo";
    private static final String PERM_CREATE = "chatmod.create";
    private static final String PERM_LIST = "chatmod.list";
    public static final String PERM_NAME_MODIFY = "chatmod.name.modify";
    private static final String PERM_TESTMOTD = "chatmod.testmotd";
    private static final String PERM_TESTBROADCAST = "chatmod.testbroadcast";
    private static final String PERM_RELOAD = "chatmod.reload";
    private static final String PERM_BC_LIST = "chatmod.bc.list";
    private static final String PERM_BC_SENDNAMED = "chatmod.bc.sendnamed";
    private static final String PERM_BC_NOW = "chatmod.bc.now";
    private static final String PERM_BC_SHOW = "chatmod.bc.show";
    private static final String PERM_INTERNAL_PAGE = "chatmod.internal.page";
    private static final String PERM_INTERNAL_DISPLAY = "chatmod.internal.display";
    private static final String PERM_ITEMS_VIEW = "chatmod.items";
    private static final String PERM_ITEMS_EDIT = "chatmod.items.edit";
    private static final String PERM_ITEMS_FORMAT = "chatmod.items.format";
    private static final String PERM_TAG_COMMAND = "chatmod.tag.command";
    private static final String INTERNAL_COMMAND_BASE = "modinternal";
    private static final List<String> PAGE1_HELP_LINES = List.of(" ", " ", "&6&m                    &r  &6ChatMod Helpful Commands:  &6&m                    ", "&7\u27a1                                                                         {click the chat commands to auto fill your chat}<action:suggest_command,:)>", "&a/chatmod create 'name'{Create custom commands that return text. &=Config in config/chatmod_info}<action:suggest_command,/cm create>", "&a/chatmod list{Shows a list of command 'names'}<action:suggest_command,/cm list>", "&a/chatmod items{Manage predefined items for [item:#] placeholder.}<action:suggest_command,/cm items>", "&a/chatmod items format <prefix> <suffix>{Customize chat name prefix/suffix.}<action:suggest_command,/cm items format >", "&7Tag players in chat use &e@username{Tag everyone with &e@Everyone&r &=Use with caution.}<action:suggest_command,@everyone>", "&eClick me to see more on custom commands:{}<action:run_command,/modinternal page 2>", "&7\u27a1                                                                         {click the chat commands to auto fill your chat}<action:suggest_command,:)>", "&a/chatmod bc 'name'{This is a predefined broadcast &=(/chatmod bclist)}<action:suggest_command,/cm bc>", "&a/chatmod bcnow <type> 'text'{Send an ad-hoc broadcast. Type can be chat, title, etc.}<action:suggest_command,/cm bcnow >", "&a/chatmod bclist{List of configured broadcasts for &=/chatmod bc 'name'}<action:suggest_command,/cm bclist>", "&a/chatmod bcshow 'name'{Preview the global broadcast}<action:suggest_command,/cm bcshow>", "&eClick me to see more on broadcasts:{}<action:run_command,/modinternal page 3>", "&7\u27a1                                                                         {click the chat commands to auto fill your chat}<action:suggest_command,:)>", "&a/chatmod testmotd{Test the MOTD (message on server join)}<action:suggest_command,/cm testmotd>", "&a/chatmod testbroadcast{Cycle through broadcast messages}<action:suggest_command,/cm testbroadcast>", "&d/chatmod reload{Reloads all ChatMod configs after edits.}<action:suggest_command,/cm reload>", "&e/cm is an Alias :)                       &6[CrateBundle Help Link]{This is my discord i dont have a github etc yet will look into it :)}<action:open_url,https://discord.gg/GpryZU8QHK>", "&7\u27a1                                                                         {click the chat commands to auto fill your chat}<action:suggest_command,:)>");
    private static final List<String> PAGE2_HELP_LINES = List.of(" ", " ", "&6&m                    &r  &6ChatMod Helpful Commands:  &6&m                    ", "&7\u27a1                                                                         {}<action:suggest_command,:)>", "&eInfo Commands Setup:", "&7/'name' &7- View main section (See /cm list)", "&7/'name' [page] &7- View more pages", "&7/'name' work &7- Toggle /'name' on/off", "&7/'name' permission &7- Toggle permission requirement for /'name'", "&7/'name' permission set 'node' &7- Set permission node for /'name'", "&7/'name' alias add 'alias' &7- Add alias like /'names' for /'name'", "&7/'name' alias remove 'alias' &7- Remove alias like /'n' for /'name'", "&7\u27a1                                                                         {}<action:suggest_command,:)>", " ", " ");
    private static final List<String> PAGE3_HELP_LINES = List.of(" ", " ", "&6&m                    &r  &6ChatMod Helpful Commands:  &6&m                    ", "&7\u27a1                                                                         {}<action:suggest_command,:)>", "&eBroadcast Time / Amount:", "&7/chatmod time 20m often 5 bc 'name'", "&7This command says the broadcast 'name', &=Will be played 5 times in 20minutes of time. &=&7    On command &=    3times during 20min &=    on the 20min mark", "&7\u27a1                                                                         {}<action:suggest_command,:)>", "&7/chatmod time 30m often 7 bcnow t 'Your Title'", "&7This command allows you to Broadcast your own 'text' &=Will be played 7 times in 30minutes of time. &=&7    On command &=    5times during 30min &=    on the 30min mark", "&7\u27a1                                                                         {}<action:suggest_command,:)>", " ", " ");
    private static final List<String> PAGE4_HELP_LINES = List.of("&6&m                    &r  &6ChatMod Help (Page 4/4)  &6&m                    ", "&eOther Admin Commands (from original Page 4):", "&a/cm reload{Reloads all ChatMod configs.}<action:suggest_command,/chatmod reload>", "&a/cm testmotd{Shows you the current MOTD.}<action:suggest_command,/chatmod testmotd>", "&a/cm testbroadcast{Triggers next legacy cycling broadcast.}<action:suggest_command,/chatmod testbroadcast>", "&7-----------------------------------------------------", "&7{&7<- Broadcast Time (Page 3)}<action:run_command,/chatmod page 3>                                       {&7Back to Page 1}<action:run_command,/chatmod page 1>");

    public static boolean checkPermission(class_2168 source, String permissionNode) {
        if (PERM_MODINFO.equals(permissionNode)) {
            return Permissions.check((class_2172)source, (String)permissionNode, (boolean)true);
        }
        if (PERM_INTERNAL_PAGE.equals(permissionNode) || PERM_INTERNAL_DISPLAY.equals(permissionNode)) {
            return Permissions.check((class_2172)source, (String)permissionNode, (boolean)true);
        }
        return Permissions.check((class_2172)source, (String)permissionNode, (boolean)source.method_9259(2));
    }

    private static void registerChatModCommands(CommandDispatcher<class_2168> dispatcher, String commandName, ConfigManager configManager, BroadcastManager legacyBroadcastManager, PlayerDataManager playerDataManager, InfoManager infoManager, PredefinedBroadcastManager predefinedBroadcastManager, ScheduledBroadcastManager scheduledBroadcastManager) {
        List<String> broadcastTypes = List.of("c", "t", "b", "a", "chat", "title", "bossbar", "actionbar");
        LiteralArgumentBuilder timeNode = (LiteralArgumentBuilder)class_2170.method_9247((String)"time").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"interval", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9247((String)"often").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"count", (ArgumentType)IntegerArgumentType.integer((int)0)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"bc").requires(source -> BroadcasterCommand.checkPermission(source, PERM_BC_SENDNAMED))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests((ctx, sb) -> class_2172.method_9265(predefinedBroadcastManager.getPermittedBroadcastNames((class_2168)ctx.getSource()), (SuggestionsBuilder)sb)).executes(context -> BroadcasterCommand.executePredefinedBroadcast((CommandContext<class_2168>)context, predefinedBroadcastManager, scheduledBroadcastManager, StringArgumentType.getString((CommandContext)context, (String)"name"), StringArgumentType.getString((CommandContext)context, (String)"interval"), IntegerArgumentType.getInteger((CommandContext)context, (String)"count")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"bcnow").requires(source -> BroadcasterCommand.checkPermission(source, PERM_BC_NOW))).then(class_2170.method_9244((String)"type", (ArgumentType)StringArgumentType.word()).suggests((ctx, sb) -> class_2172.method_9265((Iterable)broadcastTypes, (SuggestionsBuilder)sb)).then(class_2170.method_9244((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(context -> BroadcasterCommand.executeAdHocBroadcast((CommandContext<class_2168>)context, scheduledBroadcastManager, StringArgumentType.getString((CommandContext)context, (String)"type"), StringArgumentType.getString((CommandContext)context, (String)"message"), StringArgumentType.getString((CommandContext)context, (String)"interval"), IntegerArgumentType.getInteger((CommandContext)context, (String)"count"))))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"bc").requires(source -> BroadcasterCommand.checkPermission(source, PERM_BC_SENDNAMED))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests((ctx, sb) -> class_2172.method_9265(predefinedBroadcastManager.getPermittedBroadcastNames((class_2168)ctx.getSource()), (SuggestionsBuilder)sb)).executes(context -> BroadcasterCommand.executePredefinedBroadcast((CommandContext<class_2168>)context, predefinedBroadcastManager, scheduledBroadcastManager, StringArgumentType.getString((CommandContext)context, (String)"name"), StringArgumentType.getString((CommandContext)context, (String)"interval"), -1))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"bcnow").requires(source -> BroadcasterCommand.checkPermission(source, PERM_BC_NOW))).then(class_2170.method_9244((String)"type", (ArgumentType)StringArgumentType.word()).suggests((ctx, sb) -> class_2172.method_9265((Iterable)broadcastTypes, (SuggestionsBuilder)sb)).then(class_2170.method_9244((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(context -> BroadcasterCommand.executeAdHocBroadcast((CommandContext<class_2168>)context, scheduledBroadcastManager, StringArgumentType.getString((CommandContext)context, (String)"type"), StringArgumentType.getString((CommandContext)context, (String)"message"), StringArgumentType.getString((CommandContext)context, (String)"interval"), -1))))));
        LiteralArgumentBuilder itemsNode = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"items").requires(source -> BroadcasterCommand.checkPermission(source, PERM_ITEMS_VIEW) || BroadcasterCommand.checkPermission(source, PERM_ITEMS_EDIT))).executes(BroadcasterCommand::openPredefinedItemsGui)).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"format").requires(source -> BroadcasterCommand.checkPermission(source, PERM_ITEMS_FORMAT))).then(class_2170.method_9244((String)"prefix", (ArgumentType)StringArgumentType.string()).suggests((ctx, sb) -> class_2172.method_9265(List.of("\"<\"", "\"&r\"", "\"\""), (SuggestionsBuilder)sb)).then(class_2170.method_9244((String)"suffix", (ArgumentType)StringArgumentType.string()).suggests((ctx, sb) -> class_2172.method_9265(List.of("\">\"", "\"&r\"", "\"\""), (SuggestionsBuilder)sb)).executes(context -> BroadcasterCommand.setChatFormat((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"prefix"), StringArgumentType.getString((CommandContext)context, (String)"suffix")))))).then(class_2170.method_9247((String)"reset").executes(BroadcasterCommand::resetChatFormat)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)commandName).requires(source -> BroadcasterCommand.checkPermission(source, PERM_MODINFO))).executes(context -> BroadcasterCommand.showHelpPage((CommandContext<class_2168>)context, 1))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reload").requires(source -> BroadcasterCommand.checkPermission(source, PERM_RELOAD))).executes(context -> BroadcasterCommand.reloadAllConfigs((CommandContext<class_2168>)context, configManager, legacyBroadcastManager, infoManager, predefinedBroadcastManager)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"testmotd").requires(source -> BroadcasterCommand.checkPermission(source, PERM_TESTMOTD))).executes(context -> BroadcasterCommand.testMotd((CommandContext<class_2168>)context, configManager, playerDataManager)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"testbroadcast").requires(source -> BroadcasterCommand.checkPermission(source, PERM_TESTBROADCAST))).executes(context -> BroadcasterCommand.testLegacyBroadcast((CommandContext<class_2168>)context, legacyBroadcastManager)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"create").requires(source -> BroadcasterCommand.checkPermission(source, PERM_CREATE))).then(class_2170.method_9244((String)"filename", (ArgumentType)StringArgumentType.word()).executes(context -> BroadcasterCommand.createInfoFile((CommandContext<class_2168>)context, infoManager))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"list").requires(source -> BroadcasterCommand.checkPermission(source, PERM_LIST))).executes(context -> BroadcasterCommand.listInfoFiles((CommandContext<class_2168>)context, infoManager)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"bclist").requires(source -> BroadcasterCommand.checkPermission(source, PERM_BC_LIST))).executes(context -> BroadcasterCommand.listPredefinedBroadcasts((CommandContext<class_2168>)context, predefinedBroadcastManager)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"bcshow").requires(source -> BroadcasterCommand.checkPermission(source, PERM_BC_SHOW))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests((ctx, sb) -> class_2172.method_9265(predefinedBroadcastManager.getPermittedBroadcastNames((class_2168)ctx.getSource()), (SuggestionsBuilder)sb)).executes(context -> BroadcasterCommand.showPredefinedBroadcastToSender((CommandContext<class_2168>)context, predefinedBroadcastManager, StringArgumentType.getString((CommandContext)context, (String)"name")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"bc").requires(source -> BroadcasterCommand.checkPermission(source, PERM_BC_SENDNAMED))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests((ctx, sb) -> class_2172.method_9265(predefinedBroadcastManager.getPermittedBroadcastNames((class_2168)ctx.getSource()), (SuggestionsBuilder)sb)).executes(context -> BroadcasterCommand.executePredefinedBroadcast((CommandContext<class_2168>)context, predefinedBroadcastManager, scheduledBroadcastManager, StringArgumentType.getString((CommandContext)context, (String)"name"), null, -1))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"bcnow").requires(source -> BroadcasterCommand.checkPermission(source, PERM_BC_NOW))).then(class_2170.method_9244((String)"type", (ArgumentType)StringArgumentType.word()).suggests((ctx, sb) -> class_2172.method_9265((Iterable)broadcastTypes, (SuggestionsBuilder)sb)).then(class_2170.method_9244((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(context -> BroadcasterCommand.executeAdHocBroadcast((CommandContext<class_2168>)context, scheduledBroadcastManager, StringArgumentType.getString((CommandContext)context, (String)"type"), StringArgumentType.getString((CommandContext)context, (String)"message"), null, -1)))))).then((ArgumentBuilder)timeNode)).then((ArgumentBuilder)itemsNode));
    }

    public static void register(CommandDispatcher<class_2168> dispatcher, ConfigManager configManager, BroadcastManager legacyBroadcastManager, PlayerDataManager playerDataManager, InfoManager infoManager, PredefinedBroadcastManager predefinedBroadcastManager, ScheduledBroadcastManager scheduledBroadcastManager) {
        BroadcasterCommand.registerChatModCommands(dispatcher, "chatmod", configManager, legacyBroadcastManager, playerDataManager, infoManager, predefinedBroadcastManager, scheduledBroadcastManager);
        BroadcasterCommand.registerChatModCommands(dispatcher, "cm", configManager, legacyBroadcastManager, playerDataManager, infoManager, predefinedBroadcastManager, scheduledBroadcastManager);
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tag").requires(source -> BroadcasterCommand.checkPermission(source, PERM_TAG_COMMAND))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> BroadcasterCommand.tagPlayerCommand((CommandContext<class_2168>)context, class_2186.method_9315((CommandContext)context, (String)"player"), ""))).then(class_2170.method_9244((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(context -> BroadcasterCommand.tagPlayerCommand((CommandContext<class_2168>)context, class_2186.method_9315((CommandContext)context, (String)"player"), StringArgumentType.getString((CommandContext)context, (String)"message"))))));
        LiteralArgumentBuilder modinternalNode = class_2170.method_9247((String)INTERNAL_COMMAND_BASE);
        modinternalNode.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"page").requires(source -> BroadcasterCommand.checkPermission(source, PERM_INTERNAL_PAGE))).then(class_2170.method_9244((String)"pagenum", (ArgumentType)IntegerArgumentType.integer((int)1, (int)4)).executes(context -> BroadcasterCommand.showHelpPage((CommandContext<class_2168>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"pagenum")))));
        modinternalNode.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"display").requires(source -> BroadcasterCommand.checkPermission(source, PERM_INTERNAL_DISPLAY))).then(class_2170.method_9244((String)"filename", (ArgumentType)StringArgumentType.word()).suggests(infoManager::suggestLoadedInfoFiles).then(class_2170.method_9244((String)"sectionname", (ArgumentType)StringArgumentType.word()).executes(context -> {
            String fileName = StringArgumentType.getString((CommandContext)context, (String)"filename");
            String sectionName = StringArgumentType.getString((CommandContext)context, (String)"sectionname");
            return infoManager.displayInfoFileSection((class_2168)context.getSource(), fileName, sectionName);
        }))));
        dispatcher.register(modinternalNode);
    }

    private static int setChatFormat(CommandContext<class_2168> context, String prefix, String suffix) {
        MessagesConfig messagesConfig = Broadcaster.getMessagesManager().getMessagesConfig();
        messagesConfig.chatNamePrefixFormat = prefix;
        messagesConfig.chatNameSuffixFormat = suffix;
        Broadcaster.getMessagesManager().saveMessages();
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        MinecraftServer server = source.method_9211();
        class_2561 examplePrefixText = (class_2561)MessageFormatter.formatLines(List.of(prefix), player, server, Broadcaster.getPlayerDataManager()).stream().findFirst().orElse(class_2561.method_43473());
        class_2561 exampleSuffixText = (class_2561)MessageFormatter.formatLines(List.of(suffix), player, server, Broadcaster.getPlayerDataManager()).stream().findFirst().orElse(class_2561.method_43473());
        class_5250 examplePlayerName = class_2561.method_43470((String)"PlayerName").method_27692(class_124.field_1054);
        class_5250 feedback = class_2561.method_43470((String)"Chat name format set to: ").method_27692(class_124.field_1060);
        feedback.method_10852(examplePrefixText).method_10852((class_2561)examplePlayerName).method_10852(exampleSuffixText).method_10852((class_2561)class_2561.method_43470((String)" MessageContent"));
        source.method_9226(() -> feedback, true);
        return 1;
    }

    private static int resetChatFormat(CommandContext<class_2168> context) {
        MessagesConfig messagesConfig = Broadcaster.getMessagesManager().getMessagesConfig();
        messagesConfig.chatNamePrefixFormat = "<";
        messagesConfig.chatNameSuffixFormat = ">";
        Broadcaster.getMessagesManager().saveMessages();
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        MinecraftServer server = source.method_9211();
        class_2561 examplePrefixText = (class_2561)MessageFormatter.formatLines(List.of("<"), player, server, Broadcaster.getPlayerDataManager()).stream().findFirst().orElse(class_2561.method_43473());
        class_2561 exampleSuffixText = (class_2561)MessageFormatter.formatLines(List.of(">"), player, server, Broadcaster.getPlayerDataManager()).stream().findFirst().orElse(class_2561.method_43473());
        class_5250 examplePlayerName = class_2561.method_43470((String)"PlayerName").method_27692(class_124.field_1054);
        class_5250 feedback = class_2561.method_43470((String)"Chat name format reset to default: ").method_27692(class_124.field_1060);
        feedback.method_10852(examplePrefixText).method_10852((class_2561)examplePlayerName).method_10852(exampleSuffixText).method_10852((class_2561)class_2561.method_43470((String)" MessageContent"));
        source.method_9226(() -> feedback, true);
        return 1;
    }

    private static int openPredefinedItemsGui(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        PredefinedItemManager itemManager = Broadcaster.getPredefinedItemManager();
        MinecraftServer server = Broadcaster.getServerInstance();
        if (server == null || itemManager == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Server or Item Manager not available. Cannot open GUI."));
            return 0;
        }
        boolean canEdit = BroadcasterCommand.checkPermission((class_2168)context.getSource(), PERM_ITEMS_EDIT);
        class_5455.class_6890 registryLookup = server.method_30611();
        PredefinedItemsInventory predefinedItemsInventory = new PredefinedItemsInventory(itemManager, (class_7225.class_7874)registryLookup, (class_1657)player, canEdit);
        class_2561 guiTitle = MessageFormatter.formatLines(List.of("&6ChatMod Items placeholder GUI"), player, server, Broadcaster.getPlayerDataManager()).get(0);
        player.method_17355((class_3908)new class_747((syncId, playerInventory, p) -> new class_1707(class_3917.field_17327, syncId, playerInventory, (class_1263)predefinedItemsInventory, 6), guiTitle));
        return 1;
    }

    private static int showItemsHelpOrStatus(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        source.method_9226(() -> class_2561.method_43470((String)"--- ChatMod Predefined Items ---").method_27692(class_124.field_1065), false);
        source.method_9226(() -> class_2561.method_43470((String)"Manage items for the [item:#] placeholder via the GUI: /cm items").method_27692(class_124.field_1054), false);
        return 1;
    }

    private static int listPredefinedItems(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        PredefinedItemManager itemManager = Broadcaster.getPredefinedItemManager();
        MinecraftServer server = source.method_9211();
        if (server == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Server instance not available. Cannot list items."));
            return 0;
        }
        class_5455.class_6890 registryLookup = server.method_30611();
        source.method_9226(() -> class_2561.method_43470((String)"--- Predefined Items (Slots 1-54) ---").method_27692(class_124.field_1065), false);
        boolean foundAny = false;
        for (int i = 1; i <= 54; ++i) {
            class_1799 stack = itemManager.getItemStack(i, (class_7225.class_7874)registryLookup);
            if (stack.method_7960()) continue;
            foundAny = true;
            class_5250 itemText = class_2561.method_43470((String)("- Slot " + i + ": ")).method_27692(class_124.field_1080);
            itemText.method_10852(stack.method_7954());
            source.method_9226(() -> itemText, false);
        }
        if (!foundAny) {
            source.method_9226(() -> class_2561.method_43470((String)"No items are currently defined. Use /cm items to manage them.").method_27692(class_124.field_1054), false);
        }
        return 1;
    }

    private static int setPredefinedItemFromHand(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        int slot = IntegerArgumentType.getInteger(context, (String)"slot");
        if (slot < 1 || slot > 54) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Slot must be between 1 and 54."));
            return 0;
        }
        class_1799 heldItem = player.method_6047();
        if (heldItem.method_7960()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"You are not holding any item in your main hand."));
            return 0;
        }
        MinecraftServer server = source.method_9211();
        if (server == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Server instance not available. Cannot set item."));
            return 0;
        }
        class_5455.class_6890 registryLookup = server.method_30611();
        PredefinedItemManager itemManager = Broadcaster.getPredefinedItemManager();
        itemManager.setItemStack(slot, heldItem.method_7972(), (class_7225.class_7874)registryLookup);
        source.method_9226(() -> class_2561.method_43470((String)"Item '").method_10852(heldItem.method_7954()).method_10852((class_2561)class_2561.method_43470((String)("' set to slot " + slot + ". View with /cm items."))).method_27692(class_124.field_1060), true);
        return 1;
    }

    private static int removePredefinedItem(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        int slot = IntegerArgumentType.getInteger(context, (String)"slot");
        if (slot < 1 || slot > 54) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Slot must be between 1 and 54."));
            return 0;
        }
        MinecraftServer server = source.method_9211();
        if (server == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Server instance not available. Cannot remove item."));
            return 0;
        }
        class_5455.class_6890 registryLookup = server.method_30611();
        PredefinedItemManager itemManager = Broadcaster.getPredefinedItemManager();
        class_1799 currentItem = itemManager.getItemStack(slot, (class_7225.class_7874)registryLookup);
        itemManager.removeItemStack(slot);
        if (!currentItem.method_7960()) {
            source.method_9226(() -> class_2561.method_43470((String)"Item ").method_10852(currentItem.method_7954()).method_10852((class_2561)class_2561.method_43470((String)(" removed from slot " + slot + ". View with /cm items."))).method_27692(class_124.field_1060), true);
        } else {
            source.method_9226(() -> class_2561.method_43470((String)("Slot " + slot + " was already empty.")).method_27692(class_124.field_1054), false);
        }
        return 1;
    }

    private static int showHelpPage(CommandContext<class_2168> context, int pageNum) {
        List<String> helpLines = switch (pageNum) {
            case 1 -> PAGE1_HELP_LINES;
            case 2 -> PAGE2_HELP_LINES;
            case 3 -> PAGE3_HELP_LINES;
            case 4 -> PAGE4_HELP_LINES;
            default -> List.of("&cInvalid help page: " + pageNum + ". Valid pages: 1-4.", "&7Usage: Click navigation in &e/chatmod&7 or &e/modinternal page <num>&7 help.");
        };
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        MinecraftServer server = source.method_9211();
        if (server == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Cannot display help: server not available."));
            return 0;
        }
        List<class_2561> formattedLines = MessageFormatter.formatLines(helpLines, player, server, Broadcaster.getPlayerDataManager());
        for (class_2561 line : formattedLines) {
            source.method_9226(() -> line, false);
        }
        return 1;
    }

    private static int reloadAllConfigs(CommandContext<class_2168> context, ConfigManager configManager, BroadcastManager legacyBroadcastManager, InfoManager infoManager, PredefinedBroadcastManager predefinedBroadcastManager) {
        class_2168 source = (class_2168)context.getSource();
        source.method_9226(() -> class_2561.method_43470((String)"Reloading ChatMod configuration..."), false);
        configManager.loadConfig();
        if (Broadcaster.getMessagesManager() != null) {
            Broadcaster.getMessagesManager().loadMessages();
        }
        if (predefinedBroadcastManager != null) {
            predefinedBroadcastManager.loadConfig();
        }
        if (Broadcaster.getPredefinedItemManager() != null) {
            Broadcaster.getPredefinedItemManager().loadConfig();
        }
        legacyBroadcastManager.reload();
        infoManager.refreshCommands();
        source.method_9226(() -> class_2561.method_43470((String)"ChatMod configurations, info files, predefined items, and commands reloaded."), true);
        return 1;
    }

    private static int listInfoFiles(CommandContext<class_2168> context, InfoManager infoManager) {
        class_2168 source = (class_2168)context.getSource();
        List<String> permittedCommandNames = infoManager.getPermittedInfoCommandNames(source);
        if (permittedCommandNames.isEmpty()) {
            source.method_9226(() -> class_2561.method_43470((String)"No info file commands available or you lack permission to view them.").method_27692(class_124.field_1054), false);
        } else {
            source.method_9226(() -> class_2561.method_43470((String)"Available info file commands (lowercase):").method_27692(class_124.field_1065), false);
            Iterator<String> iterator = permittedCommandNames.iterator();
            while (iterator.hasNext()) {
                String distinctAlias;
                String nameIter;
                String currentName = nameIter = iterator.next();
                InfoFileConfig cfg = infoManager.getInfoFileConfiguration(currentName);
                Object suffixValue = "";
                if (cfg != null && cfg.getAliases() != null && !cfg.getAliases().isEmpty() && (distinctAlias = (String)cfg.getAliases().stream().map(a -> a.startsWith("/") ? a.substring(1) : a).filter(a -> !a.equalsIgnoreCase(currentName)).findFirst().orElse(null)) != null) {
                    suffixValue = " (alias: /" + distinctAlias + ")";
                }
                String finalSuffix = suffixValue;
                source.method_9226(() -> class_2561.method_43470((String)("- /" + currentName + finalSuffix)), false);
            }
        }
        return 1;
    }

    private static int createInfoFile(CommandContext<class_2168> context, InfoManager infoManager) {
        String fileNameInput = StringArgumentType.getString(context, (String)"filename");
        class_2168 source = (class_2168)context.getSource();
        if (infoManager.createInfoFile(fileNameInput)) {
            String normalizedFileName = fileNameInput.toLowerCase();
            source.method_9226(() -> class_2561.method_43470((String)("Info file '" + normalizedFileName + ".json' created with command /" + normalizedFileName + ".")).method_27692(class_124.field_1060), true);
            infoManager.refreshCommands();
        } else {
            source.method_9213((class_2561)class_2561.method_43470((String)("Failed to create info file for '" + fileNameInput + "'. It might already exist or the name is invalid. Check server logs.")));
        }
        return 1;
    }

    private static int testMotd(CommandContext<class_2168> context, ConfigManager configManager, PlayerDataManager playerDataManager) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        source.method_9226(() -> class_2561.method_43470((String)"Testing MOTD..."), false);
        BroadcasterConfig config = configManager.getConfig();
        if (!config.isMotdEnabled()) {
            source.method_9226(() -> class_2561.method_43470((String)"MOTD is disabled.").method_27692(class_124.field_1054), false);
            return 1;
        }
        if (config.getMotdMessages().isEmpty()) {
            source.method_9226(() -> class_2561.method_43470((String)"No MOTD messages configured.").method_27692(class_124.field_1054), false);
            return 1;
        }
        class_3222 player = source.method_44023();
        MinecraftServer server = source.method_9211();
        if (server == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Cannot test MOTD: server not available."));
            return 0;
        }
        if (player != null) {
            new PlayerJoinHandler(configManager, playerDataManager).onPlayReady(player.field_13987, null, server);
            source.method_9226(() -> class_2561.method_43470((String)"MOTD sent to you.").method_27692(class_124.field_1060), true);
        } else {
            source.method_9213((class_2561)class_2561.method_43470((String)"Cannot test MOTD from console as it requires a player context."));
        }
        return 1;
    }

    private static int testLegacyBroadcast(CommandContext<class_2168> context, BroadcastManager legacyBroadcastManager) {
        class_2168 source = (class_2168)context.getSource();
        source.method_9226(() -> class_2561.method_43470((String)"Executing next legacy cycling broadcast message manually..."), false);
        BroadcasterConfig config = Broadcaster.getConfigManager().getConfig();
        if (!config.isBroadcastEnabled()) {
            source.method_9226(() -> class_2561.method_43470((String)"Legacy broadcasting is disabled.").method_27692(class_124.field_1054), false);
            return 1;
        }
        if (config.getBroadcastMessages().isEmpty()) {
            source.method_9226(() -> class_2561.method_43470((String)"No legacy broadcast messages configured.").method_27692(class_124.field_1054), false);
            return 1;
        }
        legacyBroadcastManager.executeBroadcast();
        source.method_9226(() -> class_2561.method_43470((String)"Test legacy broadcast initiated.").method_27692(class_124.field_1060), true);
        return 1;
    }

    private static int listPredefinedBroadcasts(CommandContext<class_2168> context, PredefinedBroadcastManager predefinedManager) {
        class_2168 source = (class_2168)context.getSource();
        List<String> names = predefinedManager.getPermittedBroadcastNames(source);
        if (names.isEmpty()) {
            source.method_9226(() -> class_2561.method_43470((String)"No predefined broadcasts available or you lack permission.").method_27692(class_124.field_1054), false);
        } else {
            source.method_9226(() -> class_2561.method_43470((String)"Available predefined broadcasts:").method_27692(class_124.field_1065), false);
            for (String name : names) {
                class_5250 lineText = class_2561.method_43470((String)"- ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)name).method_27692(class_124.field_1075).method_10862(class_2583.field_24360.method_10958((class_2558)new class_2558.class_10610("/chatmod bc " + name + " ")).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("Suggest: /chatmod bc " + name))))));
                source.method_9226(() -> lineText, false);
            }
        }
        return 1;
    }

    private static int executePredefinedBroadcast(CommandContext<class_2168> context, PredefinedBroadcastManager predefinedManager, ScheduledBroadcastManager scheduledManager, String broadcastName, @Nullable String intervalStr, int count) {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        if (!predefinedManager.hasPermissionForBroadcast(source, broadcastName)) {
            source.method_9213((class_2561)class_2561.method_43470((String)("You do not have permission to use the broadcast: " + broadcastName)));
            return 0;
        }
        PredefinedBroadcast broadcast = predefinedManager.getBroadcast(broadcastName);
        if (broadcast == null || broadcast.getLines().isEmpty()) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Predefined broadcast '" + broadcastName + "' not found or is empty.")));
            return 0;
        }
        scheduledManager.scheduleBroadcast(player, broadcastName, null, null, intervalStr, count);
        source.method_9226(() -> class_2561.method_43470((String)("Broadcast action for '" + broadcastName + "' processed.")).method_27692(class_124.field_1060), true);
        return 1;
    }

    private static int executeAdHocBroadcast(CommandContext<class_2168> context, ScheduledBroadcastManager scheduledManager, String type, String message, @Nullable String intervalStr, int count) {
        String broadcastType;
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        List<String> lines = List.of(message.split("\\s*&=\\s*|\\s*=\\s*|\\R"));
        if (lines.isEmpty() || lines.stream().allMatch(String::isBlank)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Ad-hoc broadcast message cannot be empty."));
            return 0;
        }
        switch (type.toLowerCase()) {
            case "c": 
            case "chat": {
                String string = "CHAT";
                break;
            }
            case "t": 
            case "title": {
                String string = "TITLE";
                break;
            }
            case "b": 
            case "bossbar": {
                String string = "BOSSBAR";
                break;
            }
            case "a": 
            case "actionbar": {
                String string = "ACTION_BAR";
                break;
            }
            default: {
                source.method_9213((class_2561)class_2561.method_43470((String)("Invalid broadcast type: " + type)));
                String string = broadcastType = null;
            }
        }
        if (broadcastType == null) {
            return 0;
        }
        scheduledManager.scheduleBroadcast(player, null, lines, broadcastType, intervalStr, count);
        source.method_9226(() -> class_2561.method_43470((String)"Ad-hoc broadcast action processed.").method_27692(class_124.field_1060), true);
        return 1;
    }

    private static int showPredefinedBroadcastToSender(CommandContext<class_2168> context, PredefinedBroadcastManager predefinedManager, String broadcastName) {
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_44023();
        MinecraftServer server = source.method_9211();
        if (server == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Cannot show broadcast: server not available."));
            return 0;
        }
        if (!predefinedManager.hasPermissionForBroadcast(source, broadcastName)) {
            source.method_9213((class_2561)class_2561.method_43470((String)("You do not have permission to view the broadcast: " + broadcastName)));
            return 0;
        }
        PredefinedBroadcast broadcast = predefinedManager.getBroadcast(broadcastName);
        if (broadcast == null || broadcast.getLines().isEmpty()) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Predefined broadcast '" + broadcastName + "' not found or is empty.")));
            return 0;
        }
        source.method_9226(() -> class_2561.method_43470((String)("--- Preview of broadcast '" + broadcastName + "' ---")).method_27692(class_124.field_1065), false);
        String serverTimezoneId = Broadcaster.getConfigManager().getConfig().getServerTimezone();
        List<String> resolvedLines = PlaceholderResolver.resolvePlaceholders(broadcast.getLines(), player, server, Broadcaster.getPlayerDataManager(), -1L, -1L, serverTimezoneId);
        List<class_2561> formattedLines = MessageFormatter.formatLines(resolvedLines, player, server, Broadcaster.getPlayerDataManager());
        for (class_2561 line : formattedLines) {
            source.method_9226(() -> line, false);
        }
        source.method_9226(() -> class_2561.method_43470((String)"--- End of preview ---").method_27692(class_124.field_1065), false);
        return 1;
    }

    private static int tagPlayerCommand(CommandContext<class_2168> context, class_3222 targetPlayer, String messageContent) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_3222 sender = source.method_9207();
        MinecraftServer server = source.method_9211();
        PlayerDataManager playerDataManager = Broadcaster.getPlayerDataManager();
        if (server == null || playerDataManager == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Server not available for tagging command."));
            return 0;
        }
        String messageToSend = "@" + targetPlayer.method_5477().getString() + " " + messageContent;
        playerDataManager.flagPlayerForChatHandling(sender.method_5667());
        List<class_2561> formattedLines = MessageFormatter.formatLines(List.of(messageToSend), sender, server, playerDataManager);
        class_5250 finalMessageBody = formattedLines.isEmpty() ? class_2561.method_43473() : formattedLines.get(0);
        MessagesConfig messagesConfig = Broadcaster.getMessagesManager().getMessagesConfig();
        String prefixFormat = messagesConfig.getChatNamePrefixFormat();
        String suffixFormat = messagesConfig.getChatNameSuffixFormat();
        class_2561 senderDisplayNamePrefix = (class_2561)MessageFormatter.formatLines(List.of(prefixFormat), sender, server, playerDataManager).stream().findFirst().orElse(class_2561.method_43473());
        class_2561 senderDisplayNameSuffix = (class_2561)MessageFormatter.formatLines(List.of(suffixFormat), sender, server, Broadcaster.getPlayerDataManager()).stream().findFirst().orElse(class_2561.method_43473());
        class_5250 playerDisplayName = class_2561.method_43473().method_10852(senderDisplayNamePrefix).method_10852(sender.method_5476()).method_10852(senderDisplayNameSuffix);
        class_5250 finalChatMessageToBroadcast = class_2561.method_43473().method_10852((class_2561)playerDisplayName).method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852((class_2561)finalMessageBody);
        for (class_3222 recipient : server.method_3760().method_14571()) {
            recipient.method_7353((class_2561)finalChatMessageToBroadcast, false);
        }
        playerDataManager.unflagPlayerForChatHandling(sender.method_5667());
        source.method_9226(() -> class_2561.method_43470((String)"Tagged message sent.").method_27692(class_124.field_1060), true);
        return 1;
    }
}

