/*
 * Decompiled with CFR 0.152.
 */
package me.andy.chatmod.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import me.andy.chatmod.Broadcaster;
import me.andy.chatmod.config.MessagesConfig;
import net.fabricmc.loader.api.FabricLoader;

public class MessagesManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
    private final File messagesFile;
    private MessagesConfig messagesConfig;

    public MessagesManager() {
        Path configDir = FabricLoader.getInstance().getConfigDir();
        Path broadcasterModConfigDir = configDir.resolve("chatmod");
        try {
            Files.createDirectories(broadcasterModConfigDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            Broadcaster.LOGGER.error("Failed to create broadcaster config subdirectory: " + String.valueOf(broadcasterModConfigDir), (Throwable)e);
        }
        this.messagesFile = broadcasterModConfigDir.resolve("messages.json").toFile();
        this.loadMessages();
    }

    public void loadMessages() {
        this.messagesConfig = new MessagesConfig();
        if (this.messagesFile.exists()) {
            try (FileReader reader = new FileReader(this.messagesFile);){
                MessagesConfig loadedFromFile = (MessagesConfig)GSON.fromJson((Reader)reader, MessagesConfig.class);
                if (loadedFromFile == null) {
                    Broadcaster.LOGGER.warn("messages.json content was null or uninterpretable by GSON (but not a syntax error). Using default messages. Saving defaults.");
                    this.saveMessages();
                } else {
                    this.messagesConfig = loadedFromFile;
                    boolean updated = MessagesManager.ensureAllMessagesPresent(this.messagesConfig, new MessagesConfig());
                    if (updated) {
                        Broadcaster.LOGGER.info("Updated messages.json with new default values for missing keys.");
                        this.saveMessages();
                    }
                    Broadcaster.LOGGER.info("Successfully loaded messages.json. showInfoCommandHeader is: {}", (Object)this.messagesConfig.isShowInfoCommandHeader());
                }
            }
            catch (JsonSyntaxException e) {
                Broadcaster.LOGGER.error("Failed to parse messages.json due to syntax error. Using default messages. Backing up corrupted file and saving defaults.", (Throwable)e);
                this.backupCorruptedMessagesFile();
                this.messagesConfig = new MessagesConfig();
                this.saveMessages();
            }
            catch (IOException e) {
                Broadcaster.LOGGER.error("Failed to read messages.json due to IO error. Using default messages.", (Throwable)e);
            }
        } else {
            Broadcaster.LOGGER.info("No messages.json found. Creating default messages.json for chatmod");
            this.saveMessages();
        }
    }

    private void backupCorruptedMessagesFile() {
        if (this.messagesFile.exists()) {
            File backupFile = new File(this.messagesFile.getParentFile(), this.messagesFile.getName() + ".corrupted." + System.currentTimeMillis());
            if (this.messagesFile.renameTo(backupFile)) {
                Broadcaster.LOGGER.info("Backed up corrupted messages.json to: {}", (Object)backupFile.getName());
            } else {
                Broadcaster.LOGGER.error("Could not backup corrupted messages.json: {}", (Object)this.messagesFile.getName());
            }
        }
    }

    public void saveMessages() {
        File parentDir = this.messagesFile.getParentFile();
        if (!parentDir.exists() && !parentDir.mkdirs()) {
            Broadcaster.LOGGER.error("Failed to create parent directory for messages file: {}", (Object)parentDir.getAbsolutePath());
            return;
        }
        try (FileWriter writer = new FileWriter(this.messagesFile);){
            GSON.toJson((Object)this.messagesConfig, (Appendable)writer);
        }
        catch (IOException e) {
            Broadcaster.LOGGER.error("Failed to save messages.json.", (Throwable)e);
        }
    }

    public MessagesConfig getMessagesConfig() {
        if (this.messagesConfig == null) {
            Broadcaster.LOGGER.warn("MessagesConfig was null when requested. Attempting to load.");
            this.loadMessages();
        }
        return this.messagesConfig;
    }

    private static boolean ensureAllMessagesPresent(MessagesConfig loadedConfig, MessagesConfig defaultConfigInstance) {
        Field[] fields;
        boolean changed = false;
        if (loadedConfig == null || defaultConfigInstance == null) {
            return false;
        }
        for (Field field : fields = MessagesConfig.class.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            try {
                Object defaultValue;
                field.setAccessible(true);
                if (field.get(loadedConfig) != null || field.getType().isPrimitive() || (defaultValue = field.get(defaultConfigInstance)) == null) continue;
                field.set(loadedConfig, defaultValue);
                changed = true;
                Broadcaster.LOGGER.info("MessagesConfig: Added missing message key '{}' with default value.", (Object)field.getName());
            }
            catch (IllegalAccessException e) {
                Broadcaster.LOGGER.error("MessagesConfig: Could not access field {} for default value check.", (Object)field.getName(), (Object)e);
            }
        }
        return changed;
    }
}

