/*
 * Decompiled with CFR 0.152.
 */
package me.andy.chatmod.manager;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.andy.chatmod.Broadcaster;
import me.andy.chatmod.config.BroadcasterConfig;
import me.andy.chatmod.config.PredefinedBroadcast;
import me.andy.chatmod.message.MessageFormatter;
import me.andy.chatmod.message.PlaceholderResolver;
import me.andy.chatmod.scheduler.BroadcastTask;
import me.andy.chatmod.scheduler.ScheduledBroadcastTaskData;
import me.andy.chatmod.scheduler.ScheduledBroadcastsStore;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class ScheduledBroadcastManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().disableHtmlEscaping().create();
    private final File storeFile;
    private ScheduledBroadcastsStore scheduledTasksStore;
    private final Map<String, ScheduledFuture<?>> activeScheduledFutures = new HashMap();
    private final ScheduledExecutorService scheduler;
    private MinecraftServer server;
    private static final Pattern DURATION_PATTERN = Pattern.compile("(\\d+)([smhd])");

    public ScheduledBroadcastManager() {
        Path configDir = FabricLoader.getInstance().getConfigDir().resolve("chatmod");
        try {
            Files.createDirectories(configDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            Broadcaster.LOGGER.error("[ChatMod] Failed to create mod config directory: " + String.valueOf(configDir), (Throwable)e);
        }
        this.storeFile = configDir.resolve("scheduled_broadcasts.json").toFile();
        this.scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = new Thread(r, "ChatMod-ScheduledBroadcast-Thread");
            t.setDaemon(true);
            return t;
        });
        this.loadScheduledTasks();
    }

    public void setServer(MinecraftServer server) {
        this.server = server;
        this.rescheduleTasksOnLoad();
    }

    private long parseDurationToMillis(String durationStr) {
        if (durationStr == null || durationStr.isBlank()) {
            return 0L;
        }
        Matcher matcher = DURATION_PATTERN.matcher(durationStr.toLowerCase());
        if (matcher.matches()) {
            String unit;
            long value = Long.parseLong(matcher.group(1));
            switch (unit = matcher.group(2)) {
                case "s": {
                    return Duration.ofSeconds(value).toMillis();
                }
                case "m": {
                    return Duration.ofMinutes(value).toMillis();
                }
                case "h": {
                    return Duration.ofHours(value).toMillis();
                }
                case "d": {
                    return Duration.ofDays(value).toMillis();
                }
            }
        }
        Broadcaster.LOGGER.warn("[ChatMod] Could not parse duration string: '{}'. Defaulting to 0.", (Object)durationStr);
        return 0L;
    }

    public void scheduleBroadcast(@Nullable class_3222 executor, @Nullable String predefinedName, @Nullable List<String> adhocLines, @Nullable String adhocType, @Nullable String intervalStr, int countInput) {
        if (this.server == null) {
            Broadcaster.LOGGER.error("[ChatMod] Cannot schedule broadcast: MinecraftServer instance not available.");
            if (executor != null) {
                executor.method_7353((class_2561)class_2561.method_43470((String)"Error: Broadcast scheduler not ready.").method_27692(class_124.field_1061), false);
            }
            return;
        }
        long commandExecutionTime = System.currentTimeMillis();
        String taskId = UUID.randomUUID().toString();
        String serverTimezoneId = Broadcaster.getConfigManager().getConfig().getServerTimezone();
        UUID executorUUID = executor != null ? executor.method_5667() : null;
        long parsedIntervalMillis = this.parseDurationToMillis(intervalStr);
        if (intervalStr != null && countInput == -1) {
            if (parsedIntervalMillis <= 0L) {
                if (executor != null) {
                    executor.method_64398((class_2561)class_2561.method_43470((String)"Error: Invalid or zero interval specified for delayed broadcast.").method_27692(class_124.field_1061));
                } else {
                    Broadcaster.LOGGER.warn("Invalid or zero interval specified for delayed broadcast.");
                }
                return;
            }
            if (executor != null) {
                PredefinedBroadcast pb;
                ArrayList<String> messageForExecutor = new ArrayList<String>();
                if (adhocLines != null) {
                    messageForExecutor.addAll(adhocLines);
                } else if (predefinedName != null && (pb = Broadcaster.getPredefinedBroadcastManager().getBroadcast(predefinedName)) != null) {
                    messageForExecutor.addAll(pb.getLines());
                }
                if (!messageForExecutor.isEmpty()) {
                    long singleGlobalExecTime = commandExecutionTime + parsedIntervalMillis;
                    List<String> resolvedPreview = PlaceholderResolver.resolvePlaceholders(messageForExecutor, executor, this.server, Broadcaster.getPlayerDataManager(), singleGlobalExecTime, parsedIntervalMillis, serverTimezoneId);
                    List<class_2561> formattedPreview = MessageFormatter.formatLines(resolvedPreview, executor, this.server, Broadcaster.getPlayerDataManager());
                    formattedPreview.forEach(arg_0 -> ((class_3222)executor).method_64398(arg_0));
                    executor.method_64398((class_2561)class_2561.method_43470((String)("This broadcast will be sent globally in " + intervalStr + ".")).method_27692(class_124.field_1054));
                }
            }
            ScheduledBroadcastTaskData taskData = new ScheduledBroadcastTaskData(taskId, adhocLines, predefinedName, adhocType, parsedIntervalMillis, 0L, 1, 1, commandExecutionTime + parsedIntervalMillis, commandExecutionTime + parsedIntervalMillis, serverTimezoneId, executorUUID);
            this.addAndScheduleTask(taskData);
        } else if (intervalStr != null && countInput == 0) {
            if (parsedIntervalMillis <= 0L) {
                if (executor != null) {
                    executor.method_64398((class_2561)class_2561.method_43470((String)"Error: Invalid or zero interval specified for scheduled broadcast.").method_27692(class_124.field_1061));
                } else {
                    Broadcaster.LOGGER.warn("Invalid or zero interval specified for scheduled broadcast with count 0.");
                }
                return;
            }
            long finalTimeForSequence = commandExecutionTime + parsedIntervalMillis;
            this.executeGlobalBroadcast(taskId + "_immediate", adhocLines, predefinedName, adhocType, serverTimezoneId, finalTimeForSequence, parsedIntervalMillis, 1);
            ScheduledBroadcastTaskData taskData = new ScheduledBroadcastTaskData(taskId, adhocLines, predefinedName, adhocType, parsedIntervalMillis, 0L, 1, 1, commandExecutionTime + parsedIntervalMillis, commandExecutionTime + parsedIntervalMillis, serverTimezoneId, executorUUID);
            this.addAndScheduleTask(taskData);
        } else if (intervalStr != null && countInput > 0) {
            if (parsedIntervalMillis <= 0L) {
                if (executor != null) {
                    executor.method_64398((class_2561)class_2561.method_43470((String)"Error: Invalid or zero interval specified for repeating broadcast.").method_27692(class_124.field_1061));
                } else {
                    Broadcaster.LOGGER.warn("Invalid or zero interval specified for repeating broadcast.");
                }
                return;
            }
            long finalBroadcastTimeOfSequence = commandExecutionTime + parsedIntervalMillis;
            this.executeGlobalBroadcast(taskId + "_immediate", adhocLines, predefinedName, adhocType, serverTimezoneId, finalBroadcastTimeOfSequence, parsedIntervalMillis, countInput - 1);
            if (countInput > 1) {
                int repeatsToSchedule = countInput - 1;
                long subIntervalMillis = parsedIntervalMillis / (long)repeatsToSchedule;
                if (subIntervalMillis <= 0L) {
                    if (executor != null) {
                        executor.method_64398((class_2561)class_2561.method_43470((String)"Error: Interval too short for the number of repeats.").method_27692(class_124.field_1061));
                    } else {
                        Broadcaster.LOGGER.warn("Interval too short for {} repeats over {}ms.", (Object)repeatsToSchedule, (Object)parsedIntervalMillis);
                    }
                    return;
                }
                long delayForFirstRepeat = subIntervalMillis;
                ScheduledBroadcastTaskData taskData = new ScheduledBroadcastTaskData(taskId, adhocLines, predefinedName, adhocType, delayForFirstRepeat, subIntervalMillis, countInput, repeatsToSchedule, commandExecutionTime + delayForFirstRepeat, finalBroadcastTimeOfSequence, serverTimezoneId, executorUUID);
                this.addAndScheduleTask(taskData);
            }
        } else if (intervalStr == null && countInput == -1) {
            this.executeGlobalBroadcast(taskId + "_immediate", adhocLines, predefinedName, adhocType, serverTimezoneId, commandExecutionTime, 0L, 0);
        } else if (executor != null) {
            executor.method_64398((class_2561)class_2561.method_43470((String)"Invalid combination of interval and count.").method_27692(class_124.field_1061));
        } else {
            Broadcaster.LOGGER.warn("Invalid schedule parameters: interval='{}', count={}", (Object)intervalStr, (Object)countInput);
        }
        this.saveScheduledTasks();
    }

    private void addAndScheduleTask(ScheduledBroadcastTaskData taskData) {
        if (this.server == null) {
            return;
        }
        this.scheduledTasksStore.getScheduledTasks().removeIf(t -> t.taskId.equals(taskData.taskId));
        this.scheduledTasksStore.getScheduledTasks().add(taskData);
        long delayMillis = taskData.nextExecutionTimeEpochMillis - System.currentTimeMillis();
        if (delayMillis < 0L) {
            delayMillis = 0L;
        }
        ScheduledFuture<?> future = this.scheduler.schedule(() -> this.executeScheduledTaskRunnable(taskData.taskId), delayMillis, TimeUnit.MILLISECONDS);
        this.activeScheduledFutures.put(taskData.taskId, future);
        Broadcaster.LOGGER.info("[ChatMod] Scheduled task ID: {} to run in {} ms. Remaining in sequence: {}. Interval: {}ms", new Object[]{taskData.taskId, delayMillis, taskData.remainingGlobalBroadcastsInSequence, taskData.repeatIntervalMillis});
    }

    private void executeScheduledTaskRunnable(String taskId) {
        if (this.server == null) {
            Broadcaster.LOGGER.warn("[ChatMod] Server not available, cannot execute scheduled task {}", (Object)taskId);
            return;
        }
        this.server.execute(() -> {
            ScheduledBroadcastTaskData taskData = this.scheduledTasksStore.getScheduledTasks().stream().filter(t -> t.taskId.equals(taskId)).findFirst().orElse(null);
            if (taskData == null) {
                Broadcaster.LOGGER.warn("[ChatMod] Scheduled task {} not found for execution.", (Object)taskId);
                this.activeScheduledFutures.remove(taskId);
                return;
            }
            Broadcaster.LOGGER.info("[ChatMod] Executing scheduled broadcast task ID: {}. Remaining: {}", (Object)taskId, (Object)taskData.remainingGlobalBroadcastsInSequence);
            this.executeGlobalBroadcast(taskId, taskData.messageLines, taskData.predefinedBroadcastName, taskData.broadcastType, taskData.serverTimezoneIdUsedForScheduling, taskData.finalExecutionTimeEpochMillis, taskData.repeatIntervalMillis, taskData.remainingGlobalBroadcastsInSequence - 1);
            --taskData.remainingGlobalBroadcastsInSequence;
            if (taskData.remainingGlobalBroadcastsInSequence > 0 && taskData.repeatIntervalMillis > 0L) {
                taskData.nextExecutionTimeEpochMillis = System.currentTimeMillis() + taskData.repeatIntervalMillis;
                ScheduledFuture<?> nextFuture = this.scheduler.schedule(() -> this.executeScheduledTaskRunnable(taskId), taskData.repeatIntervalMillis, TimeUnit.MILLISECONDS);
                this.activeScheduledFutures.put(taskId, nextFuture);
                Broadcaster.LOGGER.info("[ChatMod] Rescheduled task ID: {} to run in {} ms. Remaining: {}", new Object[]{taskId, taskData.repeatIntervalMillis, taskData.remainingGlobalBroadcastsInSequence});
            } else {
                Broadcaster.LOGGER.info("[ChatMod] Scheduled broadcast task ID: {} completed its sequence.", (Object)taskId);
                this.scheduledTasksStore.getScheduledTasks().remove(taskData);
                this.activeScheduledFutures.remove(taskId);
            }
            this.saveScheduledTasks();
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    private void executeGlobalBroadcast(String logContextTaskId, @Nullable List<String> adhocLines, @Nullable String predefinedName, @Nullable String adhocType, String serverTimezoneId, long finalExecTimeMillis, long currentIntervalMillis, int remainingInSequenceAfterThis) {
        List<String> linesToBroadcast;
        BroadcasterConfig.BroadcastMessageDefinition messageDef;
        block7: {
            block6: {
                if (this.server == null) {
                    return;
                }
                messageDef = new BroadcasterConfig.BroadcastMessageDefinition();
                PredefinedBroadcast pb = null;
                if (predefinedName == null) break block6;
                pb = Broadcaster.getPredefinedBroadcastManager().getBroadcast(predefinedName);
                if (pb != null && !pb.getLines().isEmpty()) {
                    linesToBroadcast = pb.getLines();
                    messageDef.type = pb.getType();
                    if (messageDef.type.equalsIgnoreCase("BOSSBAR")) {
                        messageDef.durationSeconds = pb.duration_seconds;
                        messageDef.bossBarColor = pb.bossbar_color;
                        messageDef.bossBarOverlay = pb.bossbar_overlay;
                    }
                    break block7;
                } else {
                    Broadcaster.LOGGER.warn("[ChatMod] Could not find or get lines for predefined broadcast: {} (Task: {})", (Object)predefinedName, (Object)logContextTaskId);
                    return;
                }
            }
            if (adhocLines != null && !adhocLines.isEmpty()) {
                linesToBroadcast = adhocLines;
                messageDef.type = adhocType != null ? adhocType : "CHAT";
            } else {
                Broadcaster.LOGGER.warn("[ChatMod] Attempted to execute global broadcast with no message content (Task: {})", (Object)logContextTaskId);
                return;
            }
        }
        List<String> resolvedLines = PlaceholderResolver.resolvePlaceholders(linesToBroadcast, null, this.server, null, finalExecTimeMillis, currentIntervalMillis, serverTimezoneId);
        messageDef.lines = resolvedLines;
        BroadcastTask task = new BroadcastTask(this.server, messageDef, Broadcaster.getPlayerDataManager(), this.scheduler);
        task.run();
        Broadcaster.LOGGER.debug("[ChatMod] Sent global scheduled broadcast (Task: {}, Type: {})", (Object)logContextTaskId, (Object)messageDef.type);
    }

    public void loadScheduledTasks() {
        if (this.storeFile.exists()) {
            try (FileReader reader = new FileReader(this.storeFile);){
                this.scheduledTasksStore = (ScheduledBroadcastsStore)GSON.fromJson((Reader)reader, ScheduledBroadcastsStore.class);
                if (this.scheduledTasksStore == null || this.scheduledTasksStore.getScheduledTasks() == null) {
                    this.scheduledTasksStore = new ScheduledBroadcastsStore();
                }
            }
            catch (JsonSyntaxException | IOException e) {
                Broadcaster.LOGGER.error("[ChatMod] Failed to load scheduled broadcasts. Initializing empty store.", e);
                this.scheduledTasksStore = new ScheduledBroadcastsStore();
            }
        } else {
            Broadcaster.LOGGER.info("[ChatMod] No scheduled_broadcasts.json found. Initializing empty store.");
            this.scheduledTasksStore = new ScheduledBroadcastsStore();
        }
        Broadcaster.LOGGER.info("[ChatMod] Loaded {} scheduled broadcast tasks from store.", (Object)this.scheduledTasksStore.getScheduledTasks().size());
    }

    private void rescheduleTasksOnLoad() {
        if (this.server == null || this.scheduledTasksStore == null || this.scheduledTasksStore.getScheduledTasks().isEmpty()) {
            if (this.scheduledTasksStore != null && this.scheduledTasksStore.getScheduledTasks().isEmpty()) {
                Broadcaster.LOGGER.info("[ChatMod] No tasks to reschedule on load.");
            }
            return;
        }
        Broadcaster.LOGGER.info("[ChatMod] Rescheduling {} tasks on server load...", (Object)this.scheduledTasksStore.getScheduledTasks().size());
        ArrayList<ScheduledBroadcastTaskData> tasksFromStore = new ArrayList<ScheduledBroadcastTaskData>(this.scheduledTasksStore.getScheduledTasks());
        this.scheduledTasksStore.getScheduledTasks().clear();
        this.activeScheduledFutures.values().forEach(future -> future.cancel(false));
        this.activeScheduledFutures.clear();
        for (ScheduledBroadcastTaskData taskData : tasksFromStore) {
            if (taskData.remainingGlobalBroadcastsInSequence <= 0 || System.currentTimeMillis() > taskData.finalExecutionTimeEpochMillis + TimeUnit.SECONDS.toMillis(10L)) {
                Broadcaster.LOGGER.info("[ChatMod] Task {} already completed or fully past due. Removing.", (Object)taskData.taskId);
                continue;
            }
            long delayMillis = taskData.nextExecutionTimeEpochMillis - System.currentTimeMillis();
            if (delayMillis < 0L) {
                delayMillis = 0L;
            }
            Broadcaster.LOGGER.info("[ChatMod] Rescheduling task {}: remaining={}, nextRun in {}ms, interval={}ms", new Object[]{taskData.taskId, taskData.remainingGlobalBroadcastsInSequence, delayMillis, taskData.repeatIntervalMillis});
            this.addAndScheduleTask(taskData);
        }
        this.saveScheduledTasks();
    }

    public void saveScheduledTasks() {
        if (this.scheduledTasksStore == null) {
            return;
        }
        try (FileWriter writer = new FileWriter(this.storeFile);){
            GSON.toJson((Object)this.scheduledTasksStore, (Appendable)writer);
            Broadcaster.LOGGER.debug("[ChatMod] Saved {} scheduled tasks.", (Object)this.scheduledTasksStore.getScheduledTasks().size());
        }
        catch (IOException e) {
            Broadcaster.LOGGER.error("[ChatMod] Failed to save scheduled broadcasts.", (Throwable)e);
        }
    }

    public void shutdown() {
        Broadcaster.LOGGER.info("[ChatMod] Shutting down ScheduledBroadcastManager...");
        this.saveScheduledTasks();
        this.scheduler.shutdown();
        try {
            if (!this.scheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.scheduler.shutdownNow();
                if (!this.scheduler.awaitTermination(3L, TimeUnit.SECONDS)) {
                    Broadcaster.LOGGER.error("[ChatMod] Scheduler did not terminate cleanly.");
                }
            }
        }
        catch (InterruptedException ie) {
            this.scheduler.shutdownNow();
            Thread.currentThread().interrupt();
        }
        Broadcaster.LOGGER.info("[ChatMod] ScheduledBroadcastManager shut down.");
    }
}

