/*
 * Decompiled with CFR 0.152.
 */
package me.andy.chatmod.message;

import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import me.andy.chatmod.Broadcaster;
import me.andy.chatmod.config.BroadcasterConfig;
import me.andy.chatmod.config.ConfigManager;
import me.andy.chatmod.data.PlayerDataManager;
import me.andy.chatmod.scheduler.BroadcastTask;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.server.MinecraftServer;

public class BroadcastManager {
    private final ConfigManager configManager;
    private final PlayerDataManager playerDataManager;
    private MinecraftServer server;
    private final AtomicInteger currentMessageIndex = new AtomicInteger(0);
    private long tickCounter = 0L;
    private long broadcastIntervalTicks = 0L;
    private ScheduledExecutorService taskScheduler;

    public BroadcastManager(ConfigManager configManager, PlayerDataManager playerDataManager) {
        this.configManager = configManager;
        this.playerDataManager = playerDataManager;
        this.taskScheduler = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = Executors.defaultThreadFactory().newThread(r);
            t.setName("Broadcaster-Task-Scheduler");
            t.setDaemon(true);
            return t;
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(stoppingServer -> {
            if (this.taskScheduler != null && !this.taskScheduler.isShutdown()) {
                Broadcaster.LOGGER.info("Shutting down BroadcastManager's task scheduler.");
                this.taskScheduler.shutdownNow();
                try {
                    if (!this.taskScheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                        Broadcaster.LOGGER.warn("BroadcastManager's task scheduler did not terminate in time.");
                    }
                }
                catch (InterruptedException ie) {
                    this.taskScheduler.shutdownNow();
                    Thread.currentThread().interrupt();
                }
            }
        });
    }

    public void start(MinecraftServer server) {
        this.server = server;
        BroadcasterConfig config = this.configManager.getConfig();
        if (this.taskScheduler == null || this.taskScheduler.isShutdown()) {
            this.taskScheduler = Executors.newSingleThreadScheduledExecutor(r -> {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setName("Broadcaster-Task-Scheduler-Restart");
                t.setDaemon(true);
                return t;
            });
        }
        if (!config.isBroadcastEnabled() || config.getBroadcastMessages().isEmpty()) {
            Broadcaster.LOGGER.info("Broadcasting is disabled or no messages are configured.");
            return;
        }
        this.updateIntervalFromConfig(config);
        this.tickCounter = 0L;
        this.currentMessageIndex.set(0);
        ServerTickEvents.END_SERVER_TICK.register(this::onTick);
        Broadcaster.LOGGER.info("BroadcastManager started. Interval: {} ticks ({} seconds).", (Object)this.broadcastIntervalTicks, (Object)config.getBroadcastIntervalSeconds());
    }

    private void updateIntervalFromConfig(BroadcasterConfig config) {
        this.broadcastIntervalTicks = (long)config.getBroadcastIntervalSeconds() * 20L;
        if (this.broadcastIntervalTicks <= 0L) {
            Broadcaster.LOGGER.warn("Broadcast interval is non-positive, defaulting to 5 minutes.");
            this.broadcastIntervalTicks = 6000L;
        }
    }

    private void onTick(MinecraftServer currentServer) {
        if (this.server == null || !this.server.method_3806()) {
            return;
        }
        BroadcasterConfig config = this.configManager.getConfig();
        if (!config.isBroadcastEnabled() || config.getBroadcastMessages().isEmpty()) {
            return;
        }
        this.updateIntervalFromConfig(config);
        ++this.tickCounter;
        if (this.tickCounter >= this.broadcastIntervalTicks) {
            this.tickCounter = 0L;
            this.executeBroadcast();
        }
    }

    public void executeBroadcast() {
        BroadcasterConfig config = this.configManager.getConfig();
        List<BroadcasterConfig.BroadcastMessageDefinition> messages = config.getBroadcastMessages();
        if (messages.isEmpty() || !config.isBroadcastEnabled() || this.server == null || !this.server.method_3806()) {
            return;
        }
        int index = this.currentMessageIndex.getAndIncrement();
        if (index >= messages.size()) {
            index = 0;
            this.currentMessageIndex.set(1);
        }
        if (index < 0) {
            index = 0;
        }
        BroadcasterConfig.BroadcastMessageDefinition messageDef = messages.get(index);
        BroadcastTask task = new BroadcastTask(this.server, messageDef, this.playerDataManager, this.taskScheduler);
        this.server.execute((Runnable)task);
        Broadcaster.LOGGER.debug("Executing broadcast message index: {}", (Object)index);
    }

    public void stop() {
        Broadcaster.LOGGER.info("BroadcastManager stopping/stopped.");
        if (this.taskScheduler != null && !this.taskScheduler.isShutdown()) {
            Broadcaster.LOGGER.info("Shutting down BroadcastManager's task scheduler on stop().");
            this.taskScheduler.shutdown();
        }
    }

    public void reload() {
        Broadcaster.LOGGER.info("Reloading BroadcastManager...");
        BroadcasterConfig config = this.configManager.getConfig();
        this.updateIntervalFromConfig(config);
        this.tickCounter = 0L;
        this.currentMessageIndex.set(0);
        if (config.isBroadcastEnabled() && !config.getBroadcastMessages().isEmpty()) {
            if (this.server != null && this.server.method_3806()) {
                Broadcaster.LOGGER.info("BroadcastManager reloaded and active.");
            } else {
                Broadcaster.LOGGER.info("BroadcastManager reloaded, but server not running or broadcasting disabled.");
            }
        } else {
            Broadcaster.LOGGER.info("BroadcastManager reloaded. Broadcasting is disabled or no messages configured.");
        }
    }
}

