/*
 * Decompiled with CFR 0.152.
 */
package me.andy.chatmod.message;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.andy.chatmod.Broadcaster;
import me.andy.chatmod.command.BroadcasterCommand;
import me.andy.chatmod.data.PlayerDataManager;
import me.andy.chatmod.manager.PredefinedItemManager;
import me.andy.chatmod.message.PlaceholderResolver;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class MessageFormatter {
    private static final Pattern TOKENIZER_PATTERN = Pattern.compile("(?:&#([0-9a-fA-F]{6}))|(?:&([0-9a-fk-orA-FK-OR]))|(&=)|(\\{(.*?)\\})|(<action:(\\w+),([^>]*?)>)|(\\[item(?::(\\d+))?\\])|(\\[CHATMOD_INFO_DISPLAY:([a-zA-Z0-9_-]+):([a-zA-Z0-9_-]+)\\])|(\\[CHATMOD_TAG_PLAYERNAME:([\\w.-]+):((?:true|false))\\])|(\\[CHATMOD_TAG_EVERYONE:([&\u00a7#0-9a-fA-Fk-orA-FK-OR]{0,8}):((?:true|false))\\])|([^&{<\\[]+)");
    private static final int APPROX_CHAT_LINE_WIDTH_CHARS = 53;

    private static boolean isNullOrWhitespace(String s) {
        return s == null || s.trim().isEmpty();
    }

    private static boolean isLikelyUrlCandidate(String text) {
        if (MessageFormatter.isNullOrWhitespace(text)) {
            return false;
        }
        return text.matches("(?i)^(https?|ftp)://.*") || text.matches("(?i)^www\\..+\\..+") || text.contains(".") && !text.contains(" ") && text.matches("(?i)^[a-z0-9.-]+\\.(com|org|net|gov|edu|io|gl|gg|me|dev|app|xyz|co|uk|de|ca|us|info|biz|ly|tv|eu|asia|mobi|name|pro|tel|ws)(?:\\.[a-z]{2})?([/?#].*)?$");
    }

    private static String ensureUrlScheme(String url) {
        if (url == null) {
            return "";
        }
        String trimmedUrl = url.trim();
        if (trimmedUrl.matches("(?i)^(https?|ftp)://.*")) {
            return trimmedUrl;
        }
        return "http://" + trimmedUrl;
    }

    public static List<class_2561> formatLines(List<String> rawLines, @Nullable class_3222 player, @Nullable MinecraftServer server, PlayerDataManager playerDataManager) {
        ArrayList<class_2561> formattedTexts = new ArrayList<class_2561>();
        if (rawLines == null) {
            return formattedTexts;
        }
        class_5455.class_6890 registryLookup = server != null ? server.method_30611() : null;
        for (String rawLineLoop : rawLines) {
            if (rawLineLoop == null) {
                formattedTexts.add((class_2561)class_2561.method_43470((String)""));
                continue;
            }
            String lineToParse = rawLineLoop;
            lineToParse = PlaceholderResolver.resolve(rawLineLoop, player, server, playerDataManager);
            if (lineToParse.startsWith("&+")) {
                String contentLine = lineToParse.substring(2);
                class_5250 textComponent = MessageFormatter.parseSingleLine(contentLine, player, server, playerDataManager, (class_7225.class_7874)registryLookup, false);
                String textForWidthCalculation = MessageFormatter.stripFormattingForLength(textComponent.getString());
                int textWidth = textForWidthCalculation.length();
                int paddingNeeded = Math.max(0, (53 - textWidth) / 2);
                formattedTexts.add((class_2561)class_2561.method_43470((String)" ".repeat(paddingNeeded)).method_10852((class_2561)textComponent));
                continue;
            }
            formattedTexts.add((class_2561)MessageFormatter.parseSingleLine(lineToParse, player, server, playerDataManager, (class_7225.class_7874)registryLookup, false));
        }
        return formattedTexts;
    }

    private static class_5250 parseSingleLine(String rawLine, @Nullable class_3222 player, @Nullable MinecraftServer server, PlayerDataManager playerDataManager, @Nullable class_7225.class_7874 registryLookup, boolean isParsingForHoverTextContentItself) {
        class_5250 segment;
        String textToFlush;
        class_5250 baseComponent = class_2561.method_43470((String)"");
        if (rawLine == null || rawLine.isEmpty()) {
            return baseComponent;
        }
        Matcher matcher = TOKENIZER_PATTERN.matcher(rawLine);
        class_2583 currentStyle = class_2583.field_24360;
        class_5250 activeInteractiveTarget = null;
        StringBuilder pendingPlainText = new StringBuilder();
        int lastEnd = 0;
        while (matcher.find()) {
            if (matcher.start() > lastEnd) {
                pendingPlainText.append(rawLine, lastEnd, matcher.start());
            }
            if (!pendingPlainText.isEmpty()) {
                textToFlush = pendingPlainText.toString();
                segment = class_2561.method_43470((String)textToFlush).method_10862(currentStyle);
                baseComponent.method_10852((class_2561)segment);
                if (!textToFlush.trim().isEmpty()) {
                    activeInteractiveTarget = segment;
                }
                pendingPlainText.setLength(0);
            }
            String hexValG1 = matcher.group(1);
            String vanillaValG2 = matcher.group(2);
            String newlineOpG3 = matcher.group(3);
            String hoverBlockFullG4 = matcher.group(4);
            String hoverBlockContentG5 = matcher.group(5);
            String actionTagFullG6 = matcher.group(6);
            String actionTypeG7 = matcher.group(7);
            String actionValueG8 = matcher.group(8);
            String itemPlaceholderFullG9 = matcher.group(9);
            String itemSlotNumberStrG10 = matcher.group(10);
            String infoDisplayFullG11 = matcher.group(11);
            String infoDisplayFilenameG12 = matcher.group(12);
            String infoDisplaySectionnameG13 = matcher.group(13);
            String playerTagFullG14 = matcher.group(14);
            String playerTagActualNameG15 = matcher.group(15);
            String playerTagHasPermissionG16 = matcher.group(16);
            String everyoneTagFullG17 = matcher.group(17);
            String everyoneTagColorG18 = matcher.group(18);
            String everyoneTagHasPermissionG19 = matcher.group(19);
            String plainTextTokenContentG20 = matcher.group(20);
            if (hexValG1 != null) {
                try {
                    currentStyle = currentStyle.method_27703((class_5251)class_5251.method_27719((String)("#" + hexValG1)).getOrThrow());
                }
                catch (Exception e) {
                    Broadcaster.LOGGER.warn("[ChatMod] Invalid hex color code: {}", (Object)hexValG1, (Object)e);
                }
                activeInteractiveTarget = null;
            } else if (vanillaValG2 != null) {
                char c = vanillaValG2.toLowerCase().charAt(0);
                currentStyle = c == 'r' ? class_2583.field_24360 : MessageFormatter.applyMinecraftFormatting(currentStyle, class_124.method_544((char)c));
                activeInteractiveTarget = null;
            } else if (newlineOpG3 != null) {
                baseComponent.method_10852((class_2561)class_2561.method_43470((String)"\n").method_10862(class_2583.field_24360));
                activeInteractiveTarget = null;
            } else if (hoverBlockFullG4 != null) {
                if (isParsingForHoverTextContentItself) {
                    baseComponent.method_10852((class_2561)class_2561.method_43470((String)hoverBlockFullG4).method_10862(currentStyle));
                } else if (activeInteractiveTarget != null) {
                    class_5250 parsedHoverContent = MessageFormatter.parseSingleLine(hoverBlockContentG5, player, server, playerDataManager, registryLookup, true);
                    activeInteractiveTarget.method_10862(activeInteractiveTarget.method_10866().method_10949((class_2568)new class_2568.class_10613((class_2561)parsedHoverContent)));
                } else {
                    baseComponent.method_10852((class_2561)class_2561.method_43470((String)hoverBlockFullG4).method_10862(currentStyle));
                }
            } else if (actionTagFullG6 != null) {
                if (isParsingForHoverTextContentItself) {
                    baseComponent.method_10852((class_2561)class_2561.method_43470((String)actionTagFullG6).method_10862(currentStyle));
                } else if (activeInteractiveTarget != null) {
                    String resolvedActionValue = PlaceholderResolver.resolve(actionValueG8, player, server, playerDataManager);
                    class_2558 ce = MessageFormatter.createClickEvent(actionTypeG7, resolvedActionValue);
                    if (ce != null) {
                        activeInteractiveTarget.method_10862(activeInteractiveTarget.method_10866().method_10958(ce));
                    }
                    activeInteractiveTarget = null;
                } else {
                    baseComponent.method_10852((class_2561)class_2561.method_43470((String)actionTagFullG6).method_10862(currentStyle));
                }
            } else if (itemPlaceholderFullG9 != null) {
                if (isParsingForHoverTextContentItself) {
                    baseComponent.method_10852((class_2561)class_2561.method_43470((String)itemPlaceholderFullG9).method_10862(currentStyle));
                } else if (player != null && (itemPlaceholderFullG9.matches(".*\\[item\\s*\\](?!:).*") || itemPlaceholderFullG9.matches(".*\\[item\\s*:\\s*\\d+\\s*\\].*"))) {
                    boolean triedToUseHeld = itemPlaceholderFullG9.matches(".*\\[item\\s*\\](?!:).*");
                    boolean canUseHeldItem = BroadcasterCommand.checkPermission(player.method_64396(), "chatmod.chatitem");
                    boolean canUsePredefinedItem = BroadcasterCommand.checkPermission(player.method_64396(), "chatmod.chatitem.number");
                    if (triedToUseHeld && canUseHeldItem || !triedToUseHeld && canUsePredefinedItem) {
                        if (registryLookup == null) {
                            Broadcaster.LOGGER.warn("[ChatMod] Cannot process item placeholder '{}': RegistryWrapper.WrapperLookup not available.", (Object)itemPlaceholderFullG9);
                            baseComponent.method_10852((class_2561)class_2561.method_43470((String)"item").method_10862(currentStyle));
                        } else {
                            class_5250 itemComponent = MessageFormatter.processItemPlaceholder(itemPlaceholderFullG9, itemSlotNumberStrG10, player, registryLookup);
                            baseComponent.method_10852((class_2561)itemComponent.method_10862(currentStyle.method_10949(itemComponent.method_10866().method_10969())));
                        }
                    } else {
                        baseComponent.method_10852((class_2561)class_2561.method_43470((String)"item").method_10862(currentStyle));
                    }
                    activeInteractiveTarget = null;
                } else {
                    baseComponent.method_10852((class_2561)class_2561.method_43470((String)itemPlaceholderFullG9).method_10862(currentStyle));
                    activeInteractiveTarget = null;
                }
            } else if (infoDisplayFullG11 != null) {
                if (isParsingForHoverTextContentItself) {
                    baseComponent.method_10852((class_2561)class_2561.method_43470((String)infoDisplayFullG11).method_10862(currentStyle));
                } else if (activeInteractiveTarget != null) {
                    String command = "/modinternal display " + infoDisplayFilenameG12 + " " + infoDisplaySectionnameG13;
                    activeInteractiveTarget.method_10862(activeInteractiveTarget.method_10866().method_10958((class_2558)new class_2558.class_10609(command)));
                    activeInteractiveTarget = null;
                } else {
                    baseComponent.method_10852((class_2561)class_2561.method_43470((String)infoDisplayFullG11).method_10862(currentStyle));
                }
            } else if (playerTagFullG14 != null) {
                boolean hasPermission = Boolean.parseBoolean(playerTagHasPermissionG16);
                if (hasPermission) {
                    class_5251 tagColor = currentStyle.method_10973();
                    if (tagColor == null) {
                        tagColor = class_5251.method_27718((class_124)class_124.field_1054);
                    }
                    class_2583 cleanStyle = class_2583.field_24360.method_27703(tagColor).method_10982(Boolean.valueOf(false)).method_10978(Boolean.valueOf(false)).method_36141(Boolean.valueOf(false)).method_36140(Boolean.valueOf(false)).method_30938(Boolean.valueOf(false));
                    class_5250 atSymbol = class_2561.method_43470((String)"@").method_10862(cleanStyle);
                    class_5250 playerNameText = class_2561.method_43470((String)playerTagActualNameG15).method_10862(currentStyle);
                    playerNameText.method_10862(playerNameText.method_10866().method_27703(tagColor));
                    baseComponent.method_10852((class_2561)atSymbol).method_10852((class_2561)playerNameText);
                    activeInteractiveTarget = playerNameText;
                } else {
                    baseComponent.method_10852((class_2561)class_2561.method_43470((String)playerTagActualNameG15).method_10862(currentStyle));
                    activeInteractiveTarget = null;
                }
            } else if (everyoneTagFullG17 != null) {
                boolean hasPermission = Boolean.parseBoolean(everyoneTagHasPermissionG19);
                if (hasPermission) {
                    class_2583 fullTagStyle = currentStyle;
                    class_5251 tagColor = null;
                    String colorAndFormatStr = everyoneTagColorG18;
                    if (colorAndFormatStr != null && !colorAndFormatStr.isEmpty()) {
                        Pattern formatCodePattern = Pattern.compile("(&[0-9a-fk-orA-FK-OR]|&#[0-9a-fA-F]{6})");
                        Matcher formatMatcher = formatCodePattern.matcher(colorAndFormatStr);
                        while (formatMatcher.find()) {
                            String code = formatMatcher.group(1);
                            if (code.length() == 2) {
                                char formatChar = code.charAt(1);
                                class_124 mcFormat = class_124.method_544((char)formatChar);
                                if (mcFormat == null) continue;
                                if (mcFormat.method_543()) {
                                    tagColor = class_5251.method_27718((class_124)mcFormat);
                                    fullTagStyle = fullTagStyle.method_27703(tagColor);
                                    continue;
                                }
                                if (mcFormat.method_542()) {
                                    fullTagStyle = MessageFormatter.applyMinecraftFormatting(fullTagStyle, mcFormat);
                                    continue;
                                }
                                if (mcFormat != class_124.field_1070) continue;
                                fullTagStyle = class_2583.field_24360;
                                tagColor = null;
                                continue;
                            }
                            if (code.length() != 8 || !code.startsWith("&#")) continue;
                            try {
                                tagColor = (class_5251)class_5251.method_27719((String)code.substring(1)).getOrThrow();
                                fullTagStyle = fullTagStyle.method_27703(tagColor);
                            }
                            catch (Exception e) {
                                Broadcaster.LOGGER.warn("[ChatMod] Invalid hex color in @everyone tag: {}", (Object)code);
                            }
                        }
                    }
                    if (tagColor == null) {
                        tagColor = currentStyle.method_10973() != null ? currentStyle.method_10973() : class_5251.method_27718((class_124)class_124.field_1054);
                        fullTagStyle = fullTagStyle.method_27703(tagColor);
                    }
                    class_2583 atSymbolStyle = class_2583.field_24360.method_27703(tagColor);
                    class_5250 atSymbol = class_2561.method_43470((String)"@").method_10862(atSymbolStyle);
                    class_5250 everyoneText = class_2561.method_43470((String)"everyone").method_10862(fullTagStyle);
                    baseComponent.method_10852((class_2561)atSymbol).method_10852((class_2561)everyoneText);
                    activeInteractiveTarget = everyoneText;
                } else {
                    baseComponent.method_10852((class_2561)class_2561.method_43470((String)"everyone").method_10862(currentStyle));
                    activeInteractiveTarget = null;
                }
            } else if (plainTextTokenContentG20 != null) {
                pendingPlainText.append(plainTextTokenContentG20);
            }
            lastEnd = matcher.end();
        }
        if (!pendingPlainText.isEmpty()) {
            textToFlush = pendingPlainText.toString();
            segment = class_2561.method_43470((String)textToFlush).method_10862(currentStyle);
            if (MessageFormatter.isLikelyUrlCandidate(textToFlush.trim()) && !isParsingForHoverTextContentItself && segment.method_10866().method_10970() == null) {
                try {
                    segment.method_10862(segment.method_10866().method_10958((class_2558)new class_2558.class_10608(new URI(MessageFormatter.ensureUrlScheme(textToFlush.trim())))));
                }
                catch (URISyntaxException e) {
                    Broadcaster.LOGGER.debug("[ChatMod] Failed to auto-link URL '{}': {}", (Object)textToFlush.trim(), (Object)e);
                }
            }
            baseComponent.method_10852((class_2561)segment);
        } else if (lastEnd < rawLine.length()) {
            baseComponent.method_10852((class_2561)class_2561.method_43470((String)rawLine.substring(lastEnd)).method_10862(currentStyle));
        }
        return baseComponent;
    }

    private static class_5250 processItemPlaceholder(String fullPlaceholder, @Nullable String slotNumberStr, @Nullable class_3222 player, class_7225.class_7874 registryLookup) {
        if (slotNumberStr != null) {
            try {
                int slot = Integer.parseInt(slotNumberStr);
                if (slot >= 1 && slot <= 54) {
                    PredefinedItemManager itemManager = Broadcaster.getPredefinedItemManager();
                    if (itemManager == null) {
                        return class_2561.method_43470((String)fullPlaceholder);
                    }
                    class_1799 predefinedStack = itemManager.getItemStack(slot, registryLookup);
                    return predefinedStack.method_7960() ? class_2561.method_43470((String)fullPlaceholder) : predefinedStack.method_7954().method_27661();
                }
            }
            catch (NumberFormatException slot) {
                // empty catch block
            }
            return class_2561.method_43470((String)fullPlaceholder);
        }
        if (player != null) {
            class_1799 heldStack = player.method_6047();
            return heldStack.method_7960() ? class_2561.method_43470((String)fullPlaceholder) : heldStack.method_7954().method_27661();
        }
        return class_2561.method_43470((String)fullPlaceholder);
    }

    private static class_2558 createClickEvent(String actionType, String value) {
        String lowerActionType;
        switch (lowerActionType = actionType.toLowerCase()) {
            case "run_command": {
                return new class_2558.class_10609(value);
            }
            case "suggest_command": {
                return new class_2558.class_10610(value);
            }
            case "open_url": {
                try {
                    return new class_2558.class_10608(new URI(MessageFormatter.ensureUrlScheme(value)));
                }
                catch (URISyntaxException e) {
                    Broadcaster.LOGGER.warn("[ChatMod] Invalid URL for click event: {} (from value '{}')", new Object[]{MessageFormatter.ensureUrlScheme(value), value, e});
                    return null;
                }
            }
            case "change_page": {
                try {
                    return new class_2558.class_10605(Integer.parseInt(value));
                }
                catch (NumberFormatException e) {
                    Broadcaster.LOGGER.warn("[ChatMod] Invalid page number for change_page action: {}", (Object)value, (Object)e);
                    return null;
                }
            }
            case "copy_to_clipboard": {
                return new class_2558.class_10606(value);
            }
        }
        Broadcaster.LOGGER.warn("[ChatMod] Unknown click action type: {}", (Object)actionType);
        return null;
    }

    private static class_2583 applyMinecraftFormatting(class_2583 style, class_124 formatting) {
        if (formatting == null) {
            return style;
        }
        if (formatting.method_543()) {
            return style.method_10977(formatting);
        }
        if (formatting.method_542()) {
            return switch (formatting) {
                case class_124.field_1051 -> style.method_36141(Boolean.valueOf(true));
                case class_124.field_1067 -> style.method_10982(Boolean.valueOf(true));
                case class_124.field_1055 -> style.method_36140(Boolean.valueOf(true));
                case class_124.field_1073 -> style.method_30938(Boolean.valueOf(true));
                case class_124.field_1056 -> style.method_10978(Boolean.valueOf(true));
                default -> style;
            };
        }
        return style;
    }

    private static String stripFormattingForLength(String text) {
        if (text == null) {
            return "";
        }
        String temp = text.replaceAll("(?i)\\[CHATMOD_TAG_PLAYERNAME:[^\\]]+\\]", "PlayerName");
        temp = temp.replaceAll("(?i)\\[CHATMOD_TAG_EVERYONE:[^\\]]+\\]", "@everyone");
        temp = temp.replaceAll("(?i)\\[CHATMOD_INFO_DISPLAY:[^\\]]+\\]", "InfoText");
        temp = temp.replaceAll("(?i)&[0-9a-fk-or]|&#[0-9a-fA-F]{6}|&= ?", "");
        temp = temp.replaceAll("\\{.*?\\}", "");
        temp = temp.replaceAll("<action:.*?>", "");
        temp = temp.replaceAll("\\[item(?:\\d+)?\\]", "[item]");
        return temp;
    }
}

