/*
 * Decompiled with CFR 0.152.
 */
package me.andy.chatmod.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.andy.chatmod.Broadcaster;
import me.andy.chatmod.data.PlayerData;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class PlayerDataManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Map<UUID, PlayerData> playerDataMap = new ConcurrentHashMap<UUID, PlayerData>();
    private File playerDataFile;
    private final Set<UUID> playersWithModHandledChat = Collections.newSetFromMap(new ConcurrentHashMap());

    public void loadPlayerData(MinecraftServer server) {
        Path worldDir = server.method_27050(class_5218.field_24188);
        this.playerDataFile = worldDir.resolve("chatmod_playerdata.json").toFile();
        if (this.playerDataFile.exists()) {
            try (FileReader reader = new FileReader(this.playerDataFile);){
                Type type = new TypeToken<HashMap<UUID, PlayerData>>(this){}.getType();
                Map loadedMap = (Map)GSON.fromJson((Reader)reader, type);
                if (loadedMap != null) {
                    this.playerDataMap.putAll(loadedMap);
                    Broadcaster.LOGGER.info("Loaded data for {} players.", (Object)loadedMap.size());
                }
            }
            catch (IOException e) {
                Broadcaster.LOGGER.error("Failed to load player data.", (Throwable)e);
            }
        } else {
            Broadcaster.LOGGER.info("No existing player data file found. A new one will be created on save.");
        }
    }

    public void savePlayerData(MinecraftServer server) {
        if (this.playerDataFile == null && server != null) {
            Path worldDir = server.method_27050(class_5218.field_24188);
            this.playerDataFile = worldDir.resolve("chatmod_playerdata.json").toFile();
        }
        if (this.playerDataFile == null) {
            Broadcaster.LOGGER.error("Player data file path is not set. Cannot save player data.");
            return;
        }
        try (FileWriter writer = new FileWriter(this.playerDataFile);){
            GSON.toJson(this.playerDataMap, (Appendable)writer);
            Broadcaster.LOGGER.info("Saved data for {} players.", (Object)this.playerDataMap.size());
        }
        catch (IOException e) {
            Broadcaster.LOGGER.error("Failed to save player data.", (Throwable)e);
        }
    }

    public PlayerData getPlayerData(class_3222 player) {
        return this.playerDataMap.computeIfAbsent(player.method_5667(), uuid -> new PlayerData(System.currentTimeMillis()));
    }

    public PlayerData getPlayerData(UUID uuid) {
        return this.playerDataMap.get(uuid);
    }

    public void onPlayerJoin(class_3222 player) {
        PlayerData data = this.getPlayerData(player);
        data.onLogin(System.currentTimeMillis());
        Broadcaster.LOGGER.debug("Player {} ({}) logged in. Last login: {}, Playtime: {}ms", new Object[]{player.method_5477().getString(), player.method_5667(), data.getLastLoginTimeMillis(), data.getTotalPlaytimeMillis()});
        this.unflagPlayerForChatHandling(player.method_5667());
    }

    public void onPlayerLeave(class_3222 player) {
        PlayerData data = this.getPlayerData(player.method_5667());
        if (data != null) {
            data.onLogout(System.currentTimeMillis());
            Broadcaster.LOGGER.debug("Player {} ({}) logged out. Playtime updated to: {}ms", new Object[]{player.method_5477().getString(), player.method_5667(), data.getTotalPlaytimeMillis()});
        }
        this.unflagPlayerForChatHandling(player.method_5667());
    }

    public void flagPlayerForChatHandling(UUID playerUuid) {
        this.playersWithModHandledChat.add(playerUuid);
        Broadcaster.LOGGER.debug("Player {} flagged for mod-handled chat.", (Object)playerUuid);
    }

    public void unflagPlayerForChatHandling(UUID playerUuid) {
        this.playersWithModHandledChat.remove(playerUuid);
        Broadcaster.LOGGER.debug("Player {} unflagged for mod-handled chat.", (Object)playerUuid);
    }

    public boolean isPlayerFlaggedForChatHandling(UUID playerUuid) {
        return this.playersWithModHandledChat.contains(playerUuid);
    }
}

