/*
 * Decompiled with CFR 0.152.
 */
package me.andy.chatmod.gui;

import java.util.HashMap;
import me.andy.chatmod.Broadcaster;
import me.andy.chatmod.config.PredefinedItemData;
import me.andy.chatmod.manager.PredefinedItemManager;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_7225;

public class PredefinedItemsInventory
implements class_1263 {
    private final class_2371<class_1799> items = class_2371.method_10213((int)54, (Object)class_1799.field_8037);
    private final PredefinedItemManager itemManager;
    private final class_7225.class_7874 registryLookup;
    private final class_1657 ownerPlayer;
    private final boolean canEdit;

    public PredefinedItemsInventory(PredefinedItemManager itemManager, class_7225.class_7874 registryLookup, class_1657 ownerPlayer, boolean canEdit) {
        this.itemManager = itemManager;
        this.registryLookup = registryLookup;
        this.ownerPlayer = ownerPlayer;
        this.canEdit = canEdit;
        this.loadItemsFromManager();
    }

    private void loadItemsFromManager() {
        this.items.clear();
        for (int i = 0; i < this.items.size(); ++i) {
            class_1799 stack = this.itemManager.getItemStack(i + 1, this.registryLookup);
            if (stack.method_7960()) continue;
            this.items.set(i, (Object)stack);
        }
        Broadcaster.LOGGER.debug("[ChatMod] Loaded {} items into GUI inventory.", (Object)this.itemManager.getAllItems().size());
    }

    private void saveItemsToManager() {
        if (!this.canEdit) {
            Broadcaster.LOGGER.debug("[ChatMod] Attempted to save read-only GUI inventory. Operation skipped.");
            return;
        }
        HashMap<Integer, PredefinedItemData> newItems = new HashMap<Integer, PredefinedItemData>();
        for (int i = 0; i < this.items.size(); ++i) {
            class_1799 stack = (class_1799)this.items.get(i);
            if (stack.method_7960()) continue;
            PredefinedItemData data = PredefinedItemData.fromItemStack(stack, this.registryLookup);
            if (data != null) {
                newItems.put(i + 1, data);
                continue;
            }
            Broadcaster.LOGGER.warn("[ChatMod] Failed to convert ItemStack in slot {} to PredefinedItemData. Item will not be saved.", (Object)(i + 1));
        }
        this.itemManager.setAllItems(newItems);
        this.itemManager.saveConfig();
        Broadcaster.LOGGER.debug("[ChatMod] Saved {} items from GUI inventory to config.", (Object)newItems.size());
    }

    public int method_5439() {
        return this.items.size();
    }

    public boolean method_5442() {
        for (class_1799 itemStack : this.items) {
            if (itemStack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.items.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        if (!this.canEdit) {
            return class_1799.field_8037;
        }
        class_1799 result = ((class_1799)this.items.get(slot)).method_7971(amount);
        if (((class_1799)this.items.get(slot)).method_7960()) {
            this.items.set(slot, (Object)class_1799.field_8037);
        }
        this.method_5431();
        return result;
    }

    public class_1799 method_5441(int slot) {
        if (!this.canEdit) {
            return class_1799.field_8037;
        }
        class_1799 result = (class_1799)this.items.get(slot);
        if (!result.method_7960()) {
            this.items.set(slot, (Object)class_1799.field_8037);
            this.method_5431();
        }
        return result;
    }

    public void method_5447(int slot, class_1799 stack) {
        if (!this.canEdit) {
            return;
        }
        this.items.set(slot, (Object)stack);
        if (!stack.method_7960() && stack.method_7947() > stack.method_7914()) {
            stack.method_7939(stack.method_7914());
        }
        this.method_5431();
    }

    public void method_5431() {
        if (this.canEdit) {
            this.saveItemsToManager();
        } else {
            Broadcaster.LOGGER.debug("[ChatMod] Read-only GUI attempted to markDirty. Operation skipped.");
        }
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    public void method_5448() {
        if (!this.canEdit) {
            return;
        }
        this.items.clear();
        this.method_5431();
    }
}

