/*
 * Decompiled with CFR 0.152.
 */
package me.andy.chatmod.message;

import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.andy.chatmod.Broadcaster;
import me.andy.chatmod.command.BroadcasterCommand;
import me.andy.chatmod.config.PlaceholdersConfig;
import me.andy.chatmod.manager.PlaceholdersManager;
import me.andy.chatmod.message.MessageFormatter;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2767;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7492;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class ChatDecorator
implements class_7492 {
    private static final String PERM_CHAT_COLORS = "chatmod.chat.colors";
    private static final String PERM_PLAYER_TAG = "chatmod.player.tag";
    private static final String PERM_PLAYER_TAG_EVERYONE = "chatmod.player.tag.everyone";
    private static final Pattern PLAYER_NAME_PATTERN = Pattern.compile("@([\\w.-]+)\\b");
    private static final Pattern EVERYONE_TAG_PATTERN = Pattern.compile("((?:[&\u00a7].)*)?(@everyone)\\b", 2);
    private static final Pattern ITEM_PLACEHOLDER_PATTERN = Pattern.compile("(\\[item(?::(\\d+))?\\])");
    private static final Random packetRandom = new Random();

    public class_2561 decorate(@Nullable class_3222 sender, class_2561 message) {
        if (sender == null) {
            return message;
        }
        String content = message.getString();
        MinecraftServer server = sender.method_5682();
        if (server == null) {
            return message;
        }
        String processedContent = this.processContent(content, sender, server);
        return MessageFormatter.formatMessage(processedContent, sender, server, Broadcaster.getPlayerDataManager());
    }

    private String processContent(String messageForFormatter, class_3222 sender, MinecraftServer server) {
        PlaceholdersManager pm = Broadcaster.getPlaceholdersManager();
        if (pm != null) {
            Map<String, PlaceholdersConfig.CustomPlaceholderDefinition> customs = pm.getConfig().custom_placeholders;
            for (Map.Entry<String, PlaceholdersConfig.CustomPlaceholderDefinition> entry : customs.entrySet()) {
                String key = entry.getKey();
                PlaceholdersConfig.CustomPlaceholderDefinition def = entry.getValue();
                if (!messageForFormatter.contains(def.typed) || def.permission != null && !def.permission.isEmpty() && !BroadcasterCommand.checkPermission(sender.method_64396(), def.permission)) continue;
                messageForFormatter = messageForFormatter.replace(def.typed, "[CHATMOD_CUSTOM:" + key + "]");
            }
        }
        if (!BroadcasterCommand.checkPermission(sender.method_64396(), PERM_CHAT_COLORS)) {
            messageForFormatter = messageForFormatter.replaceAll("([&\u00a7][0-9a-fk-orA-FK-OR]|[&\u00a7]#[0-9a-fA-F]{6})", "");
        }
        Matcher itemMatcher = ITEM_PLACEHOLDER_PATTERN.matcher(messageForFormatter);
        StringBuffer itemSb = new StringBuffer();
        while (itemMatcher.find()) {
            String fullPlaceholder = itemMatcher.group(1);
            itemMatcher.appendReplacement(itemSb, Matcher.quoteReplacement(fullPlaceholder));
        }
        itemMatcher.appendTail(itemSb);
        messageForFormatter = itemSb.toString();
        Matcher everyoneMatcher = EVERYONE_TAG_PATTERN.matcher(messageForFormatter);
        StringBuffer everyoneSb = new StringBuffer();
        boolean everyoneTaggingPermitted = BroadcasterCommand.checkPermission(sender.method_64396(), PERM_PLAYER_TAG_EVERYONE);
        boolean everyoneTagSoundTriggered = false;
        while (everyoneMatcher.find()) {
            String token;
            String formatParam;
            String formatCodes = everyoneMatcher.group(1);
            if (everyoneTaggingPermitted) {
                formatParam = "";
                if (formatCodes != null && !formatCodes.isEmpty() && BroadcasterCommand.checkPermission(sender.method_64396(), PERM_CHAT_COLORS)) {
                    formatParam = this.processFormatCodes(formatCodes);
                }
                token = "[CHATMOD_TAG_EVERYONE:" + formatParam + ":true]";
                everyoneMatcher.appendReplacement(everyoneSb, Matcher.quoteReplacement(token));
                everyoneTagSoundTriggered = true;
                continue;
            }
            formatParam = formatCodes != null ? formatCodes.replace('\u00a7', '&') : "";
            token = "[CHATMOD_TAG_EVERYONE:" + formatParam + ":false]";
            everyoneMatcher.appendReplacement(everyoneSb, Matcher.quoteReplacement(token));
        }
        everyoneMatcher.appendTail(everyoneSb);
        messageForFormatter = everyoneSb.toString();
        Matcher playerMatcher = PLAYER_NAME_PATTERN.matcher(messageForFormatter);
        StringBuffer playerSb = new StringBuffer();
        boolean playerTaggingPermitted = BroadcasterCommand.checkPermission(sender.method_64396(), PERM_PLAYER_TAG);
        while (playerMatcher.find()) {
            String targetName = playerMatcher.group(1);
            class_3222 taggedPlayer = server.method_3760().method_14566(targetName);
            if (taggedPlayer != null && playerTaggingPermitted) {
                this.sendPlayerTagSound(taggedPlayer);
                playerMatcher.appendReplacement(playerSb, "[CHATMOD_TAG_PLAYERNAME:" + targetName + ":true]");
                continue;
            }
            playerMatcher.appendReplacement(playerSb, "[CHATMOD_TAG_PLAYERNAME:" + targetName + ":false]");
        }
        playerMatcher.appendTail(playerSb);
        messageForFormatter = playerSb.toString();
        if (everyoneTagSoundTriggered) {
            this.sendEveryoneTagSound(server);
        }
        return messageForFormatter;
    }

    private String processFormatCodes(String rawFormatCodes) {
        if (rawFormatCodes == null || rawFormatCodes.isEmpty()) {
            return "";
        }
        String normalized = rawFormatCodes.replace('\u00a7', '&');
        String lastColorCode = "";
        StringBuilder modifierCodes = new StringBuilder();
        Pattern codePattern = Pattern.compile("(&[0-9a-fk-orA-FK-OR]|&#[0-9a-fA-F]{6})");
        Matcher matcher = codePattern.matcher(normalized);
        while (matcher.find()) {
            String code = matcher.group(1);
            if (code.length() == 2) {
                char formatChar = code.toLowerCase().charAt(1);
                class_124 formatting = class_124.method_544((char)formatChar);
                if (formatting == null) continue;
                if (formatting.method_543() || formatting == class_124.field_1070) {
                    lastColorCode = code;
                    modifierCodes.setLength(0);
                    continue;
                }
                if (!formatting.method_542() || modifierCodes.indexOf(code) != -1) continue;
                modifierCodes.append(code);
                continue;
            }
            if (code.length() != 8 || !code.startsWith("&#")) continue;
            lastColorCode = code;
            modifierCodes.setLength(0);
        }
        return lastColorCode + modifierCodes.toString();
    }

    private void sendPlayerTagSound(class_3222 targetPlayer) {
        if (targetPlayer.method_5682() != null) {
            targetPlayer.method_5682().execute(() -> {
                class_2767 soundPacket = new class_2767((class_6880)class_7923.field_41172.method_10223(((class_5321)class_3417.field_14622.method_40230().orElseThrow()).method_29177()).orElseThrow(), class_3419.field_15248, targetPlayer.method_23317(), targetPlayer.method_23318(), targetPlayer.method_23321(), 0.5f, 1.5f + packetRandom.nextFloat() * 0.1f, packetRandom.nextLong());
                targetPlayer.field_13987.method_14364((class_2596)soundPacket);
            });
        }
    }

    private void sendEveryoneTagSound(MinecraftServer server) {
        server.execute(() -> {
            for (class_3222 onlinePlayer : server.method_3760().method_14571()) {
                class_2767 soundPacket = new class_2767((class_6880)class_7923.field_41172.method_10223(class_3417.field_14627.comp_3319()).orElseThrow(), class_3419.field_15256, onlinePlayer.method_23317(), onlinePlayer.method_23318(), onlinePlayer.method_23321(), 0.8f, 1.0f + packetRandom.nextFloat() * 0.2f, packetRandom.nextLong());
                onlinePlayer.field_13987.method_14364((class_2596)soundPacket);
            }
        });
    }
}

