/*
 * Decompiled with CFR 0.152.
 */
package me.andy.chatmod.event;

import java.util.List;
import me.andy.chatmod.Broadcaster;
import me.andy.chatmod.config.BroadcasterConfig;
import me.andy.chatmod.config.ConfigManager;
import me.andy.chatmod.data.PlayerDataManager;
import me.andy.chatmod.message.MessageFormatter;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

public class PlayerJoinHandler
implements ServerPlayConnectionEvents.Join {
    private final ConfigManager configManager;
    private final PlayerDataManager playerDataManager;

    public PlayerJoinHandler(ConfigManager configManager, PlayerDataManager playerDataManager) {
        this.configManager = configManager;
        this.playerDataManager = playerDataManager;
    }

    public void onPlayReady(class_3244 handler, PacketSender sender, MinecraftServer server) {
        class_3222 player = handler.method_32311();
        this.playerDataManager.onPlayerJoin(player);
        BroadcasterConfig config = this.configManager.getConfig();
        if (config == null) {
            Broadcaster.LOGGER.error("[PlayerJoinHandler] BroadcasterConfig is null! Cannot send MOTD.");
            return;
        }
        if (config.isMotdEnabled()) {
            if (config.getMotdMessages() == null || config.getMotdMessages().isEmpty()) {
                return;
            }
            BroadcasterConfig.MOTDDefinition motd = config.getMotdMessages().get(0);
            if (motd != null && motd.lines != null && !motd.lines.isEmpty()) {
                List<class_2561> formattedLines = MessageFormatter.formatLines(motd.lines, player, server, this.playerDataManager);
                for (class_2561 formattedLine : formattedLines) {
                    player.method_64398(formattedLine);
                }
            } else {
                Broadcaster.LOGGER.warn("[PlayerJoinHandler] MOTD is enabled but the selected MOTD definition or its lines are null/empty.");
            }
        }
    }
}

