/*
 * Decompiled with CFR 0.152.
 */
package me.andy.chatmod.mixin;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.andy.chatmod.Broadcaster;
import me.andy.chatmod.command.BroadcasterCommand;
import me.andy.chatmod.config.MessagesConfig;
import me.andy.chatmod.data.PlayerDataManager;
import me.andy.chatmod.message.MessageFormatter;
import me.andy.chatmod.util.TaggedPlayerInstance;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2767;
import net.minecraft.class_2797;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3244.class})
public abstract class PlayerChatMixin {
    @Shadow
    public class_3222 field_14140;
    private static final String PERM_CHAT_ITEM_HELD = "chatmod.chatitem";
    private static final String PERM_CHAT_ITEM_NUMBER = "chatmod.chatitem.number";
    private static final String PERM_PLAYER_TAG = "chatmod.player.tag";
    private static final String PERM_PLAYER_TAG_EVERYONE = "chatmod.player.tag.everyone";
    private static final String PERM_CHAT_COLORS = "chatmod.chat.colors";
    private static final Pattern PLAYER_NAME_PATTERN = Pattern.compile("@([\\w.-]+)\\b");
    private static final Pattern EVERYONE_TAG_PATTERN = Pattern.compile("((?:[&\u00a7].)*)?(@everyone)\\b", 2);
    private static final Pattern COLOR_CODE_PATTERN = Pattern.compile("([&\u00a7][0-9a-fk-orA-FK-OR]|[&\u00a7]#[0-9a-fA-F]{6})");
    private static final Pattern ITEM_PLACEHOLDER_PATTERN = Pattern.compile("(\\[item(?::(\\d+))?\\])");
    private static final Random packetRandom = new Random();

    private boolean hasChatModPermission(class_3222 player, String permissionNode) {
        boolean hasPermission = BroadcasterCommand.checkPermission(player.method_64396(), permissionNode);
        return hasPermission;
    }

    @Inject(method={"onChatMessage(Lnet/minecraft/network/packet/c2s/play/ChatMessageC2SPacket;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onChatMessageMixin(class_2797 packet, CallbackInfo ci) {
        String originalMessage = packet.comp_945();
        MinecraftServer currentServer = this.field_14140.method_51469().method_8503();
        PlayerDataManager playerDataManager = Broadcaster.getPlayerDataManager();
        if (currentServer == null || playerDataManager == null) {
            return;
        }
        boolean needsModProcessingDueToContent = false;
        if (originalMessage != null) {
            if (ITEM_PLACEHOLDER_PATTERN.matcher(originalMessage).find()) {
                needsModProcessingDueToContent = true;
            }
            if (PLAYER_NAME_PATTERN.matcher(originalMessage).find()) {
                needsModProcessingDueToContent = true;
            }
            if (EVERYONE_TAG_PATTERN.matcher(originalMessage).find()) {
                needsModProcessingDueToContent = true;
            }
            if (COLOR_CODE_PATTERN.matcher(originalMessage).find()) {
                needsModProcessingDueToContent = true;
            }
        }
        if (playerDataManager.isPlayerFlaggedForChatHandling(this.field_14140.method_5667()) || needsModProcessingDueToContent) {
            if (needsModProcessingDueToContent && !playerDataManager.isPlayerFlaggedForChatHandling(this.field_14140.method_5667())) {
                playerDataManager.flagPlayerForChatHandling(this.field_14140.method_5667());
            }
            this.processAndResendMessage(originalMessage, currentServer, playerDataManager, ci);
            ci.cancel();
        }
    }

    private void processAndResendMessage(String messageContentToProcess, MinecraftServer currentServer, PlayerDataManager playerDataManager, CallbackInfo ci) {
        List<class_2561> formattedTextLines;
        class_5455.class_6890 registryLookup = currentServer.method_30611();
        if (registryLookup == null) {
            Broadcaster.LOGGER.warn("[ChatMod] RegistryWrapper.WrapperLookup is null. Cannot process chat message.");
            return;
        }
        String messageForFormatter = messageContentToProcess;
        ArrayList<TaggedPlayerInstance> playersToPlaySoundTo = new ArrayList<TaggedPlayerInstance>();
        if (!this.hasChatModPermission(this.field_14140, PERM_CHAT_COLORS)) {
            messageForFormatter = messageForFormatter.replaceAll("([&\u00a7][0-9a-fk-orA-FK-OR]|[&\u00a7]#[0-9a-fA-F]{6})", "");
        }
        Matcher itemMatcher = ITEM_PLACEHOLDER_PATTERN.matcher(messageForFormatter);
        StringBuffer itemSb = new StringBuffer();
        while (itemMatcher.find()) {
            String fullPlaceholder = itemMatcher.group(1);
            itemMatcher.appendReplacement(itemSb, Matcher.quoteReplacement(fullPlaceholder));
        }
        itemMatcher.appendTail(itemSb);
        messageForFormatter = itemSb.toString();
        Matcher everyoneMatcher = EVERYONE_TAG_PATTERN.matcher(messageForFormatter);
        StringBuffer everyoneSb = new StringBuffer();
        boolean everyoneTaggingPermitted = this.hasChatModPermission(this.field_14140, PERM_PLAYER_TAG_EVERYONE);
        boolean everyoneTagSoundTriggered = false;
        while (everyoneMatcher.find()) {
            String token;
            String formatParam;
            String formatCodes = everyoneMatcher.group(1);
            if (everyoneTaggingPermitted) {
                formatParam = "";
                if (formatCodes != null && !formatCodes.isEmpty() && this.hasChatModPermission(this.field_14140, PERM_CHAT_COLORS)) {
                    formatParam = this.processFormatCodes(formatCodes);
                }
                token = "[CHATMOD_TAG_EVERYONE:" + formatParam + ":true]";
                everyoneMatcher.appendReplacement(everyoneSb, Matcher.quoteReplacement(token));
                everyoneTagSoundTriggered = true;
                continue;
            }
            formatParam = formatCodes != null ? formatCodes.replace('\u00a7', '&') : "";
            token = "[CHATMOD_TAG_EVERYONE:" + formatParam + ":false]";
            everyoneMatcher.appendReplacement(everyoneSb, Matcher.quoteReplacement(token));
        }
        everyoneMatcher.appendTail(everyoneSb);
        messageForFormatter = everyoneSb.toString();
        Matcher playerMatcher = PLAYER_NAME_PATTERN.matcher(messageForFormatter);
        StringBuffer playerSb = new StringBuffer();
        boolean playerTaggingPermitted = this.hasChatModPermission(this.field_14140, PERM_PLAYER_TAG);
        boolean playerTagSoundTriggered = false;
        while (playerMatcher.find()) {
            String targetName = playerMatcher.group(1);
            class_3222 taggedPlayer = currentServer.method_3760().method_14566(targetName);
            if (taggedPlayer != null && playerTaggingPermitted) {
                playersToPlaySoundTo.add(new TaggedPlayerInstance(taggedPlayer, targetName));
                playerMatcher.appendReplacement(playerSb, "[CHATMOD_TAG_PLAYERNAME:" + (String)targetName + ":true]");
                playerTagSoundTriggered = true;
                continue;
            }
            playerMatcher.appendReplacement(playerSb, "[CHATMOD_TAG_PLAYERNAME:" + (String)targetName + ":false]");
        }
        playerMatcher.appendTail(playerSb);
        messageForFormatter = playerSb.toString();
        if (playerTagSoundTriggered) {
            for (TaggedPlayerInstance tagged : playersToPlaySoundTo) {
                this.sendPlayerTagSound(tagged.playerEntity(), this.field_14140);
            }
        }
        if (everyoneTagSoundTriggered) {
            this.sendEveryoneTagSound(currentServer, this.field_14140);
        }
        class_5250 finalMessageBody = (formattedTextLines = MessageFormatter.formatLines(List.of(messageForFormatter), this.field_14140, currentServer, playerDataManager)).isEmpty() ? class_2561.method_43473() : formattedTextLines.get(0);
        MessagesConfig messagesConfig = Broadcaster.getMessagesManager().getMessagesConfig();
        String prefixFormat = messagesConfig.getChatNamePrefixFormat();
        String suffixFormat = messagesConfig.getChatNameSuffixFormat();
        class_2561 parsedPrefix = (class_2561)MessageFormatter.formatLines(List.of(prefixFormat), this.field_14140, currentServer, playerDataManager).stream().findFirst().orElse(class_2561.method_43473());
        class_2561 parsedSuffix = (class_2561)MessageFormatter.formatLines(List.of(suffixFormat), this.field_14140, currentServer, playerDataManager).stream().findFirst().orElse(class_2561.method_43473());
        class_5250 playerDisplayName = class_2561.method_43473().method_10852(parsedPrefix).method_10852(this.field_14140.method_5476()).method_10852(parsedSuffix);
        class_5250 finalChatMessageToBroadcast = class_2561.method_43473().method_10852((class_2561)playerDisplayName).method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852((class_2561)finalMessageBody);
        for (class_3222 recipient : currentServer.method_3760().method_14571()) {
            recipient.method_7353((class_2561)finalChatMessageToBroadcast, false);
        }
        Broadcaster.LOGGER.debug("[ChatMod] Player {} chat message fully processed and resent by ChatMod: \"{}\"", (Object)this.field_14140.method_5477().getString(), (Object)messageContentToProcess);
    }

    private String processFormatCodes(String rawFormatCodes) {
        if (rawFormatCodes == null || rawFormatCodes.isEmpty()) {
            return "";
        }
        String normalized = rawFormatCodes.replace('\u00a7', '&');
        String lastColorCode = "";
        StringBuilder modifierCodes = new StringBuilder();
        Pattern codePattern = Pattern.compile("(&[0-9a-fk-orA-FK-OR]|&#[0-9a-fA-F]{6})");
        Matcher matcher = codePattern.matcher(normalized);
        while (matcher.find()) {
            String code = matcher.group(1);
            if (code.length() == 2) {
                char formatChar = code.toLowerCase().charAt(1);
                class_124 formatting = class_124.method_544((char)formatChar);
                if (formatting == null) continue;
                if (formatting.method_543() || formatting == class_124.field_1070) {
                    lastColorCode = code;
                    modifierCodes.setLength(0);
                    continue;
                }
                if (!formatting.method_542() || modifierCodes.indexOf(code) != -1) continue;
                modifierCodes.append(code);
                continue;
            }
            if (code.length() != 8 || !code.startsWith("&#")) continue;
            lastColorCode = code;
            modifierCodes.setLength(0);
        }
        return lastColorCode + modifierCodes.toString();
    }

    private void sendPlayerTagSound(class_3222 targetPlayer, class_3222 sourcePlayer) {
        if (targetPlayer.method_51469().method_8503() != null) {
            targetPlayer.method_51469().method_8503().execute(() -> {
                class_2767 soundPacket = new class_2767((class_6880)class_7923.field_41172.method_10223(((class_5321)class_3417.field_14622.method_40230().orElseThrow()).method_29177()).orElseThrow(), class_3419.field_15248, targetPlayer.method_23317(), targetPlayer.method_23318(), targetPlayer.method_23321(), 0.5f, 1.5f + packetRandom.nextFloat() * 0.1f, packetRandom.nextLong());
                targetPlayer.field_13987.method_14364((class_2596)soundPacket);
            });
        }
    }

    private void sendEveryoneTagSound(MinecraftServer server, class_3222 sourcePlayer) {
        if (server != null) {
            server.execute(() -> {
                for (class_3222 onlinePlayer : server.method_3760().method_14571()) {
                    class_2767 soundPacket = this.createEveryoneSoundPacket(onlinePlayer);
                    onlinePlayer.field_13987.method_14364((class_2596)soundPacket);
                }
            });
        }
    }

    private class_2767 createEveryoneSoundPacket(class_3222 player) {
        return new class_2767((class_6880)class_7923.field_41172.method_10223(class_3417.field_14627.comp_3319()).orElseThrow(), class_3419.field_15256, player.method_23317(), player.method_23318(), player.method_23321(), 0.8f, 1.0f + packetRandom.nextFloat() * 0.2f, packetRandom.nextLong());
    }
}

