/*
 * Decompiled with CFR 0.152.
 */
package me.andy.chatmod;

import com.mojang.brigadier.CommandDispatcher;
import me.andy.chatmod.command.BroadcasterCommand;
import me.andy.chatmod.config.ConfigManager;
import me.andy.chatmod.config.MessagesManager;
import me.andy.chatmod.data.PlayerDataManager;
import me.andy.chatmod.event.PlayerJoinHandler;
import me.andy.chatmod.event.PlayerLeaveHandler;
import me.andy.chatmod.info.InfoManager;
import me.andy.chatmod.manager.PredefinedBroadcastManager;
import me.andy.chatmod.manager.PredefinedItemManager;
import me.andy.chatmod.manager.ScheduledBroadcastManager;
import me.andy.chatmod.message.BroadcastManager;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_2168;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Broadcaster
implements ModInitializer {
    public static final String MOD_ID = "chatmod";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"chatmod");
    private static ConfigManager configManager;
    private static PlayerDataManager playerDataManager;
    private static BroadcastManager legacyBroadcastManager;
    private static InfoManager infoManager;
    private static MessagesManager messagesManager;
    private static PredefinedBroadcastManager predefinedBroadcastManager;
    private static ScheduledBroadcastManager scheduledBroadcastManager;
    private static PredefinedItemManager predefinedItemManager;
    private static CommandDispatcher<class_2168> lastDispatcher;
    private static MinecraftServer serverInstance;

    public void onInitialize() {
        LOGGER.info("Initializing ChatMod Mod...");
        configManager = new ConfigManager();
        configManager.loadConfig();
        messagesManager = new MessagesManager();
        playerDataManager = new PlayerDataManager();
        legacyBroadcastManager = new BroadcastManager(configManager, playerDataManager);
        infoManager = new InfoManager();
        predefinedBroadcastManager = new PredefinedBroadcastManager();
        scheduledBroadcastManager = new ScheduledBroadcastManager();
        predefinedItemManager = new PredefinedItemManager();
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            serverInstance = server;
            playerDataManager.loadPlayerData(server);
            infoManager.ensureExampleInfoFileExists();
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            serverInstance = server;
            LOGGER.info("[ChatMod] Server started. Performing ChatMod configurations reload and service startups...");
            configManager.loadConfig();
            if (Broadcaster.getMessagesManager() != null) {
                Broadcaster.getMessagesManager().loadMessages();
            }
            if (Broadcaster.getPredefinedBroadcastManager() != null) {
                Broadcaster.getPredefinedBroadcastManager().loadConfig();
            }
            if (Broadcaster.getPredefinedItemManager() != null) {
                Broadcaster.getPredefinedItemManager().loadConfig();
            }
            legacyBroadcastManager.reload();
            if (configManager.getConfig().isBroadcastEnabled() && !configManager.getConfig().getBroadcastMessages().isEmpty() && server.method_3806()) {
                legacyBroadcastManager.start(server);
            }
            if (Broadcaster.getScheduledBroadcastManager() != null) {
                Broadcaster.getScheduledBroadcastManager().setServer(server);
            }
            if (infoManager != null && lastDispatcher != null) {
                infoManager.setLastDispatcherForRefresh(lastDispatcher);
                infoManager.refreshCommands();
            } else if (infoManager != null && lastDispatcher == null) {
                LOGGER.warn("[ChatMod] Dispatcher was not captured by CommandRegistrationCallback by the time SERVER_STARTED ran. Info command refresh might be incomplete until first /cm reload.");
            }
            LOGGER.info("[ChatMod] ChatMod configurations reloaded and services started.");
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            serverInstance = null;
            if (playerDataManager != null) {
                playerDataManager.savePlayerData(server);
            }
            if (legacyBroadcastManager != null) {
                legacyBroadcastManager.stop();
            }
            if (scheduledBroadcastManager != null) {
                scheduledBroadcastManager.shutdown();
            }
            if (predefinedItemManager != null) {
                predefinedItemManager.saveConfig();
            }
            LOGGER.info("[ChatMod] ChatMod services stopped and data saved.");
        });
        PlayerJoinHandler playerJoinHandler = new PlayerJoinHandler(configManager, playerDataManager);
        PlayerLeaveHandler playerLeaveHandler = new PlayerLeaveHandler(playerDataManager);
        ServerPlayConnectionEvents.JOIN.register((Object)playerJoinHandler);
        ServerPlayConnectionEvents.DISCONNECT.register((Object)playerLeaveHandler);
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            LOGGER.info("[ChatMod] Registering commands...");
            lastDispatcher = dispatcher;
            if (infoManager != null) {
                infoManager.setLastDispatcherForRefresh((CommandDispatcher<class_2168>)dispatcher);
                infoManager.loadInfoFiles();
                infoManager.registerInfoCommands((CommandDispatcher<class_2168>)dispatcher);
            }
            BroadcasterCommand.register((CommandDispatcher<class_2168>)dispatcher, configManager, legacyBroadcastManager, playerDataManager, infoManager, predefinedBroadcastManager, scheduledBroadcastManager);
            LOGGER.info("[ChatMod] Command registration complete.");
        });
        LOGGER.info("ChatMod Mod Initialized.");
    }

    public static ConfigManager getConfigManager() {
        return configManager;
    }

    public static PlayerDataManager getPlayerDataManager() {
        return playerDataManager;
    }

    public static BroadcastManager getLegacyBroadcastManager() {
        return legacyBroadcastManager;
    }

    public static InfoManager getInfoManager() {
        return infoManager;
    }

    public static MessagesManager getMessagesManager() {
        return messagesManager;
    }

    public static PredefinedBroadcastManager getPredefinedBroadcastManager() {
        return predefinedBroadcastManager;
    }

    public static ScheduledBroadcastManager getScheduledBroadcastManager() {
        return scheduledBroadcastManager;
    }

    public static PredefinedItemManager getPredefinedItemManager() {
        return predefinedItemManager;
    }

    public static MinecraftServer getServerInstance() {
        return serverInstance;
    }

    static {
        lastDispatcher = null;
        serverInstance = null;
    }
}

