/*
 * Decompiled with CFR 0.152.
 */
package me.andy.chatmod.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import me.andy.chatmod.Broadcaster;
import me.andy.chatmod.config.BroadcasterConfig;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
    private final File configFile;
    private BroadcasterConfig config;

    public ConfigManager() {
        Path configDir = FabricLoader.getInstance().getConfigDir();
        Path broadcasterModConfigDir = configDir.resolve("chatmod");
        try {
            Files.createDirectories(broadcasterModConfigDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            Broadcaster.LOGGER.error("Failed to create broadcaster config subdirectory: " + String.valueOf(broadcasterModConfigDir), (Throwable)e);
        }
        this.configFile = broadcasterModConfigDir.resolve("chatmod.json").toFile();
    }

    public void loadConfig() {
        if (this.configFile.exists()) {
            try (FileReader reader = new FileReader(this.configFile);){
                this.config = (BroadcasterConfig)GSON.fromJson((Reader)reader, BroadcasterConfig.class);
                if (this.config == null) {
                    Broadcaster.LOGGER.warn("Config file ({}) was empty or malformed. Loading defaults.", (Object)this.configFile.getName());
                    this.config = new BroadcasterConfig();
                    this.saveConfig();
                }
                if (this.config.motdMessages == null) {
                    this.config.motdMessages = new ArrayList<BroadcasterConfig.MOTDDefinition>();
                }
                if (this.config.broadcastMessages == null) {
                    this.config.broadcastMessages = new ArrayList<BroadcasterConfig.BroadcastMessageDefinition>();
                }
            }
            catch (JsonSyntaxException | IOException e) {
                Broadcaster.LOGGER.error("Failed to load config file ({}). Using default config and attempting to backup old one.", (Object)this.configFile.getName(), (Object)e);
                this.backupCorruptedConfig();
                this.config = new BroadcasterConfig();
                this.saveConfig();
            }
        } else {
            Broadcaster.LOGGER.info("No config file found ({}). Creating default config for chatmod", (Object)this.configFile.getName());
            this.config = new BroadcasterConfig();
            this.saveConfig();
        }
    }

    private void backupCorruptedConfig() {
        if (this.configFile.exists()) {
            File backupFile = new File(this.configFile.getParentFile(), this.configFile.getName() + ".corrupted." + System.currentTimeMillis());
            if (this.configFile.renameTo(backupFile)) {
                Broadcaster.LOGGER.info("Backed up corrupted config to: {}", (Object)backupFile.getName());
            } else {
                Broadcaster.LOGGER.error("Could not backup corrupted config: {}", (Object)this.configFile.getName());
            }
        }
    }

    public void saveConfig() {
        File parentDir = this.configFile.getParentFile();
        if (!parentDir.exists() && !parentDir.mkdirs()) {
            Broadcaster.LOGGER.error("Failed to create parent directory for config file: {}", (Object)parentDir.getAbsolutePath());
            return;
        }
        try (FileWriter writer = new FileWriter(this.configFile);){
            GSON.toJson((Object)this.config, (Appendable)writer);
        }
        catch (IOException e) {
            Broadcaster.LOGGER.error("Failed to save config file ({}).", (Object)this.configFile.getName(), (Object)e);
        }
    }

    public BroadcasterConfig getConfig() {
        if (this.config == null) {
            Broadcaster.LOGGER.warn("Config was null when requested. Attempting to load.");
            this.loadConfig();
        }
        return this.config;
    }

    public void setConfig(BroadcasterConfig newConfig) {
        this.config = newConfig;
        this.saveConfig();
    }
}

