/*
 * Decompiled with CFR 0.152.
 */
package me.andy.chatmod.info;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import me.andy.chatmod.Broadcaster;
import me.andy.chatmod.command.BroadcasterCommand;
import me.andy.chatmod.config.InfoFileConfig;
import me.andy.chatmod.config.MessagesConfig;
import me.andy.chatmod.message.MessageFormatter;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class InfoManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
    private final Path infoConfigDir;
    private final Map<String, InfoFileConfig> loadedInfoFiles = new HashMap<String, InfoFileConfig>();
    private final Map<String, String> commandLookupMap = new HashMap<String, String>();
    private CommandDispatcher<class_2168> lastDispatcher;
    public static final String HELP_FILE_NAME = "help";

    public InfoManager() {
        this.infoConfigDir = FabricLoader.getInstance().getConfigDir().resolve("chatmod_info");
        try {
            Files.createDirectories(this.infoConfigDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            Broadcaster.LOGGER.error("Failed to create info config directory: " + String.valueOf(this.infoConfigDir), (Throwable)e);
        }
    }

    public void setLastDispatcherForRefresh(CommandDispatcher<class_2168> dispatcher) {
        this.lastDispatcher = dispatcher;
    }

    public InfoFileConfig getInfoFileConfiguration(String lowercaseFileNameKey) {
        return this.loadedInfoFiles.get(lowercaseFileNameKey);
    }

    public void ensureExampleInfoFileExists() {
        File helpFile;
        String exampleFileName = "example";
        File exampleFile = this.infoConfigDir.resolve(exampleFileName + ".json").toFile();
        if (!exampleFile.exists()) {
            Broadcaster.LOGGER.info("Creating default example info file: " + exampleFile.getName());
            try (FileWriter writer = new FileWriter(exampleFile);){
                InfoFileConfig exampleConfig = new InfoFileConfig(true);
                GSON.toJson((Object)exampleConfig, (Appendable)writer);
            }
            catch (IOException e) {
                Broadcaster.LOGGER.error("Failed to create default example info file: " + exampleFile.getName(), (Throwable)e);
            }
        }
        if (!(helpFile = this.infoConfigDir.resolve("help.json").toFile()).exists()) {
            Broadcaster.LOGGER.info("Creating default help.json file.");
            try (FileWriter writer = new FileWriter(helpFile);){
                InfoFileConfig helpConfig = InfoFileConfig.createDefaultHelpConfig();
                GSON.toJson((Object)helpConfig, (Appendable)writer);
            }
            catch (IOException e) {
                Broadcaster.LOGGER.error("Failed to create default help.json file.", (Throwable)e);
            }
        }
    }

    public void loadInfoFiles() {
        this.loadedInfoFiles.clear();
        this.commandLookupMap.clear();
        File dir = this.infoConfigDir.toFile();
        if (!dir.exists() || !dir.isDirectory()) {
            Broadcaster.LOGGER.warn("Info config directory not found: {}", (Object)dir.getAbsolutePath());
            return;
        }
        File[] files = dir.listFiles((d, name) -> name.endsWith(".json"));
        if (files == null) {
            Broadcaster.LOGGER.warn("Could not list files in info config directory: {}", (Object)dir.getAbsolutePath());
            return;
        }
        for (File file : files) {
            String actualFileNameCase = file.getName().substring(0, file.getName().length() - 5);
            String lowercaseFileNameKey = actualFileNameCase.toLowerCase();
            try (FileReader reader = new FileReader(file);){
                InfoFileConfig config = (InfoFileConfig)GSON.fromJson((Reader)reader, InfoFileConfig.class);
                if (config != null) {
                    if (config.getPermissionNode() == null || config.getPermissionNode().isEmpty()) {
                        config.setPermissionNode("chatmod.info." + lowercaseFileNameKey);
                    }
                    this.loadedInfoFiles.put(lowercaseFileNameKey, config);
                    this.commandLookupMap.put(lowercaseFileNameKey, lowercaseFileNameKey);
                    for (String alias : config.getAliases()) {
                        String cleanAlias = alias.startsWith("/") ? alias.substring(1) : alias;
                        this.commandLookupMap.put(cleanAlias.toLowerCase(), lowercaseFileNameKey);
                    }
                    Broadcaster.LOGGER.info("Loaded info file: {} (Command /{}). Aliases: {}. PermNode: {}", new Object[]{file.getName(), lowercaseFileNameKey, config.getAliases(), config.getPermissionNode()});
                    continue;
                }
                Broadcaster.LOGGER.warn("Info file was empty or malformed: " + file.getName());
            }
            catch (JsonSyntaxException | IOException e) {
                Broadcaster.LOGGER.error("Failed to load info file: " + file.getName(), e);
            }
        }
        Broadcaster.LOGGER.info("Finished loading {} info files. {} command/alias mappings.", (Object)this.loadedInfoFiles.size(), (Object)this.commandLookupMap.size());
    }

    public boolean createInfoFile(String fileNameInput) {
        boolean bl;
        String normalizedFileName = fileNameInput.toLowerCase();
        if (normalizedFileName.trim().isEmpty() || normalizedFileName.contains(" ") || normalizedFileName.contains(".")) {
            Broadcaster.LOGGER.error("Invalid file name: '{}' (from input: '{}')", (Object)normalizedFileName, (Object)fileNameInput);
            return false;
        }
        if (this.commandLookupMap.containsKey(normalizedFileName)) {
            Broadcaster.LOGGER.warn("Command or alias '/{}' already exists. Maps to file: '{}'.", (Object)normalizedFileName, (Object)this.commandLookupMap.get(normalizedFileName));
            return false;
        }
        File file = this.infoConfigDir.resolve(normalizedFileName + ".json").toFile();
        FileWriter writer = new FileWriter(file);
        try {
            InfoFileConfig newConfig;
            if (normalizedFileName.equalsIgnoreCase(HELP_FILE_NAME)) {
                newConfig = InfoFileConfig.createDefaultHelpConfig();
            } else if (normalizedFileName.equalsIgnoreCase("example")) {
                newConfig = new InfoFileConfig(true);
            } else {
                newConfig = new InfoFileConfig();
                newConfig.getAliases().clear();
                newConfig.getAliases().add("/" + normalizedFileName);
            }
            if (newConfig.getPermissionNode() == null || newConfig.getPermissionNode().isEmpty()) {
                newConfig.setPermissionNode("chatmod.info." + normalizedFileName);
            }
            GSON.toJson((Object)newConfig, (Appendable)writer);
            Broadcaster.LOGGER.info("Created info file: {}", (Object)file.getName());
            this.loadedInfoFiles.put(normalizedFileName, newConfig);
            this.commandLookupMap.put(normalizedFileName, normalizedFileName);
            for (String alias : newConfig.getAliases()) {
                String cleanAlias = alias.startsWith("/") ? alias.substring(1) : alias;
                this.commandLookupMap.put(cleanAlias.toLowerCase(), normalizedFileName);
            }
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Broadcaster.LOGGER.error("Failed to create info file: " + normalizedFileName + ".json", (Throwable)e);
                return false;
            }
        }
        writer.close();
        return bl;
    }

    public void saveInfoFileConfig(String lowercaseFileNameKey, InfoFileConfig config) {
        File file = this.infoConfigDir.resolve(lowercaseFileNameKey + ".json").toFile();
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson((Object)config, (Appendable)writer);
            Broadcaster.LOGGER.debug("Saved info file: {} (Working: {}, PermRequired: {}, PermNode: {})", new Object[]{file.getName(), config.isWorking(), config.isPermissionRequired(), config.getPermissionNode()});
        }
        catch (IOException e) {
            Broadcaster.LOGGER.error("Failed to save info file config: " + lowercaseFileNameKey + ".json", (Throwable)e);
        }
    }

    public List<String> getPermittedInfoCommandNames(class_2168 source) {
        if (this.loadedInfoFiles.isEmpty()) {
            return Collections.emptyList();
        }
        return this.loadedInfoFiles.entrySet().stream().filter(entry -> {
            InfoFileConfig config = (InfoFileConfig)entry.getValue();
            if (!config.isPermissionRequired()) {
                return true;
            }
            if (config.getPermissionNode() != null && !config.getPermissionNode().isEmpty()) {
                return BroadcasterCommand.checkPermission(source, config.getPermissionNode());
            }
            return !config.isPermissionRequired();
        }).map(Map.Entry::getKey).sorted().collect(Collectors.toList());
    }

    public void registerInfoCommands(CommandDispatcher<class_2168> dispatcher) {
        this.lastDispatcher = dispatcher;
        HashMap<String, InfoFileConfig> uniqueFilesToRegister = new HashMap<String, InfoFileConfig>();
        for (String string : new ArrayList<String>(this.commandLookupMap.values())) {
            if (!this.loadedInfoFiles.containsKey(string) || uniqueFilesToRegister.containsKey(string)) continue;
            uniqueFilesToRegister.put(string, this.loadedInfoFiles.get(string));
        }
        Broadcaster.LOGGER.info("[ChatMod] Registering command structures for {} unique info files.", (Object)uniqueFilesToRegister.size());
        for (Map.Entry entry : uniqueFilesToRegister.entrySet()) {
            String lowercaseFileNameKey = (String)entry.getKey();
            InfoFileConfig config = (InfoFileConfig)entry.getValue();
            if (lowercaseFileNameKey.equalsIgnoreCase(HELP_FILE_NAME) && (config == null || !config.isWorking())) {
                Broadcaster.LOGGER.info("[ChatMod] Mod's /help (from {}.json) is disabled. Skipping its registration.", (Object)HELP_FILE_NAME);
                continue;
            }
            LiteralArgumentBuilder commandBuilder = class_2170.method_9247((String)lowercaseFileNameKey);
            commandBuilder.requires(source -> {
                if (!config.isWorking()) {
                    return false;
                }
                if (config.isPermissionRequired()) {
                    return BroadcasterCommand.checkPermission(source, config.getPermissionNode());
                }
                return true;
            });
            commandBuilder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"work").requires(source -> BroadcasterCommand.checkPermission(source, "chatmod.name.modify"))).executes(context -> this.toggleInfoFileExecute(lowercaseFileNameKey, (class_2168)context.getSource())));
            commandBuilder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"permission").requires(source -> BroadcasterCommand.checkPermission(source, "chatmod.name.modify"))).executes(context -> this.togglePermissionRequired((CommandContext<class_2168>)context, lowercaseFileNameKey))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"node", (ArgumentType)StringArgumentType.greedyString()).executes(context -> this.setPermissionNode((CommandContext<class_2168>)context, lowercaseFileNameKey, StringArgumentType.getString((CommandContext)context, (String)"node"))))));
            commandBuilder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"alias").requires(source -> BroadcasterCommand.checkPermission(source, "chatmod.name.modify"))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"alias_to_add", (ArgumentType)StringArgumentType.string()).executes(context -> this.addInfoAlias((CommandContext<class_2168>)context, lowercaseFileNameKey, StringArgumentType.getString((CommandContext)context, (String)"alias_to_add")))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"alias_to_remove", (ArgumentType)StringArgumentType.string()).suggests((ctx, sb) -> this.suggestAliasesForFile(lowercaseFileNameKey, sb)).executes(context -> this.removeInfoAlias((CommandContext<class_2168>)context, lowercaseFileNameKey, StringArgumentType.getString((CommandContext)context, (String)"alias_to_remove"))))));
            if (lowercaseFileNameKey.equalsIgnoreCase(HELP_FILE_NAME)) {
                commandBuilder.executes(context -> this.executeInfoCommandInternal((CommandContext<class_2168>)context, lowercaseFileNameKey, "main", 1, false, true));
            } else {
                ((LiteralArgumentBuilder)commandBuilder.executes(context -> this.executeInfoCommandInternal((CommandContext<class_2168>)context, lowercaseFileNameKey, "page1", 1, false, false))).then(class_2170.method_9244((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> this.executeInfoCommandInternal((CommandContext<class_2168>)context, lowercaseFileNameKey, "page" + IntegerArgumentType.getInteger((CommandContext)context, (String)"page"), IntegerArgumentType.getInteger((CommandContext)context, (String)"page"), false, false)));
            }
            LiteralCommandNode primaryRegisteredNode = dispatcher.register(commandBuilder);
            Broadcaster.LOGGER.info("[ChatMod] Registered primary info command: /{}", (Object)lowercaseFileNameKey);
            if (lowercaseFileNameKey.length() > 0) {
                String allCapsCommand;
                String startCaseCommand = lowercaseFileNameKey.substring(0, 1).toUpperCase() + lowercaseFileNameKey.substring(1);
                if (!startCaseCommand.equals(lowercaseFileNameKey) && dispatcher.getRoot().getChild(startCaseCommand) == null) {
                    dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)startCaseCommand).requires(primaryRegisteredNode.getRequirement())).redirect((CommandNode)primaryRegisteredNode));
                    Broadcaster.LOGGER.info("[ChatMod] Registered case variant '/{}' -> '/{}'", (Object)startCaseCommand, (Object)lowercaseFileNameKey);
                }
                if (!(allCapsCommand = lowercaseFileNameKey.toUpperCase()).equals(lowercaseFileNameKey) && !allCapsCommand.equals(startCaseCommand) && dispatcher.getRoot().getChild(allCapsCommand) == null) {
                    dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)allCapsCommand).requires(primaryRegisteredNode.getRequirement())).redirect((CommandNode)primaryRegisteredNode));
                    Broadcaster.LOGGER.info("[ChatMod] Registered case variant '/{}' -> '/{}'", (Object)allCapsCommand, (Object)lowercaseFileNameKey);
                }
            }
            for (String aliasWithSlash : config.getAliases()) {
                String lowercaseAlias = aliasWithSlash.startsWith("/") ? aliasWithSlash.substring(1) : aliasWithSlash;
                if (lowercaseAlias.isEmpty() || lowercaseAlias.equals(lowercaseFileNameKey) || dispatcher.getRoot().getChild(lowercaseAlias) != null) continue;
                LiteralArgumentBuilder aliasBuilder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)lowercaseAlias).requires(primaryRegisteredNode.getRequirement())).redirect((CommandNode)primaryRegisteredNode);
                dispatcher.register(aliasBuilder);
                Broadcaster.LOGGER.info("[ChatMod] Registered user-defined alias '/{}' -> '/{}'", (Object)lowercaseAlias, (Object)lowercaseFileNameKey);
            }
        }
        Broadcaster.LOGGER.info("[ChatMod] Finished registering all info commands and their case variants/aliases.");
    }

    public int toggleInfoFileExecute(String lowercaseFileNameKey, class_2168 sourceForFeedback) {
        InfoFileConfig config = this.loadedInfoFiles.get(lowercaseFileNameKey);
        if (config == null) {
            sourceForFeedback.method_9213((class_2561)class_2561.method_43470((String)("Config for '/" + lowercaseFileNameKey + "' not found. Try `/chatmod reload`.")));
            return 0;
        }
        boolean newState = !config.isWorking();
        config.setWorking(newState);
        this.saveInfoFileConfig(lowercaseFileNameKey, config);
        String finalStatusText = newState ? "enabled" : "disabled";
        sourceForFeedback.method_9226(() -> class_2561.method_43470((String)("Info file '/" + lowercaseFileNameKey + "' is now " + finalStatusText + ".")).method_27692(newState ? class_124.field_1060 : class_124.field_1054), true);
        this.refreshCommands();
        return 1;
    }

    public int togglePermissionRequired(CommandContext<class_2168> context, String lowercaseFileNameKey) {
        InfoFileConfig config = this.loadedInfoFiles.get(lowercaseFileNameKey);
        if (config == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Info file for '/" + lowercaseFileNameKey + "' not found.")));
            return 0;
        }
        boolean newState = !config.isPermissionRequired();
        config.setPermissionRequired(newState);
        Object currentPermissionNode = config.getPermissionNode();
        if (newState && (currentPermissionNode == null || ((String)currentPermissionNode).isEmpty())) {
            currentPermissionNode = "chatmod.info." + lowercaseFileNameKey;
            config.setPermissionNode((String)currentPermissionNode);
        }
        this.saveInfoFileConfig(lowercaseFileNameKey, config);
        this.refreshCommands();
        Object finalNode = currentPermissionNode;
        String statusText = newState ? "ENABLED" : "DISABLED";
        ((class_2168)context.getSource()).method_9226(() -> InfoManager.lambda$togglePermissionRequired$16(lowercaseFileNameKey, statusText, newState, (String)finalNode), true);
        return 1;
    }

    public int setPermissionNode(CommandContext<class_2168> context, String lowercaseFileNameKey, String node) {
        InfoFileConfig config = this.loadedInfoFiles.get(lowercaseFileNameKey);
        if (config == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Info file for '/" + lowercaseFileNameKey + "' not found.")));
            return 0;
        }
        String newNodeFinal = node.trim();
        if (newNodeFinal.isEmpty()) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Permission node cannot be empty."));
            return 0;
        }
        config.setPermissionNode(newNodeFinal);
        config.setPermissionRequired(true);
        this.saveInfoFileConfig(lowercaseFileNameKey, config);
        this.refreshCommands();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Permission node for '/" + lowercaseFileNameKey + "' set to '" + newNodeFinal + "'. Permission requirement is now ENABLED.")), true);
        return 1;
    }

    public int addInfoAlias(CommandContext<class_2168> context, String lowercaseFileNameKey, String aliasInput) {
        InfoFileConfig config = this.loadedInfoFiles.get(lowercaseFileNameKey);
        if (config == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Info file for '/" + lowercaseFileNameKey + "' not found.")));
            return 0;
        }
        String aliasToAddClean = aliasInput.trim();
        if (aliasToAddClean.startsWith("/")) {
            aliasToAddClean = aliasToAddClean.substring(1);
        }
        if (aliasToAddClean.isEmpty() || aliasToAddClean.contains(" ")) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Invalid alias format (e.g., 'myalias'). No spaces or empty."));
            return 0;
        }
        String finalLowercaseAlias = aliasToAddClean.toLowerCase();
        String aliasWithSlashForStorage = "/" + finalLowercaseAlias;
        if (config.getAliases().contains(aliasWithSlashForStorage)) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Alias '/" + finalLowercaseAlias + "' already exists for '/" + lowercaseFileNameKey + "'.")));
            return 0;
        }
        if (this.commandLookupMap.containsKey(finalLowercaseAlias) && !this.commandLookupMap.get(finalLowercaseAlias).equals(lowercaseFileNameKey)) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Alias or command '/" + finalLowercaseAlias + "' is already in use globally (maps to '/" + this.commandLookupMap.get(finalLowercaseAlias) + "').")));
            return 0;
        }
        if (finalLowercaseAlias.equals(lowercaseFileNameKey)) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Cannot add an alias that is the same as the primary command '/" + lowercaseFileNameKey + "'.")));
            return 0;
        }
        config.getAliases().add(aliasWithSlashForStorage);
        this.saveInfoFileConfig(lowercaseFileNameKey, config);
        this.refreshCommands();
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Alias '/" + finalLowercaseAlias + "' added for '/" + lowercaseFileNameKey + "'.")), true);
        return 1;
    }

    public CompletableFuture<Suggestions> suggestAliasesForFile(String lowercaseFileNameKey, SuggestionsBuilder builder) {
        InfoFileConfig config = this.loadedInfoFiles.get(lowercaseFileNameKey);
        if (config != null && config.getAliases() != null) {
            return class_2172.method_9264(config.getAliases().stream().map(s -> s.startsWith("/") ? s.substring(1) : s), (SuggestionsBuilder)builder);
        }
        return Suggestions.empty();
    }

    public CompletableFuture<Suggestions> suggestLoadedInfoFiles(CommandContext<class_2168> context, SuggestionsBuilder builder) {
        return class_2172.method_9265(this.commandLookupMap.keySet(), (SuggestionsBuilder)builder);
    }

    public int removeInfoAlias(CommandContext<class_2168> context, String lowercaseFileNameKey, String aliasToRemoveInput) {
        String finalLowercaseAliasToRemove;
        String aliasWithSlashForStorage;
        InfoFileConfig config = this.loadedInfoFiles.get(lowercaseFileNameKey);
        if (config == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Info file for '/" + lowercaseFileNameKey + "' not found.")));
            return 0;
        }
        String aliasToRemoveClean = aliasToRemoveInput.trim();
        if (aliasToRemoveClean.startsWith("/")) {
            aliasToRemoveClean = aliasToRemoveClean.substring(1);
        }
        if ((aliasWithSlashForStorage = "/" + (finalLowercaseAliasToRemove = aliasToRemoveClean.toLowerCase())).equals("/" + lowercaseFileNameKey)) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Cannot remove the primary command name using alias remove. To remove the command, delete the file and reload."));
            return 0;
        }
        if (config.getAliases().remove(aliasWithSlashForStorage)) {
            this.saveInfoFileConfig(lowercaseFileNameKey, config);
            this.refreshCommands();
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Alias '/" + finalLowercaseAliasToRemove + "' removed from '/" + lowercaseFileNameKey + "'.")), true);
        } else {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Alias '/" + finalLowercaseAliasToRemove + "' not found for '/" + lowercaseFileNameKey + "'.")));
        }
        return 1;
    }

    private int executeInfoCommandInternal(CommandContext<class_2168> context, String lowercaseFileNameKey, String sectionOrPageKey, int displayPageNumber, boolean isAlias, boolean isSpecialHelpFile) throws CommandSyntaxException {
        int totalPagesOrSections;
        MessagesConfig msgs = Broadcaster.getMessagesManager().getMessagesConfig();
        class_2168 source = (class_2168)context.getSource();
        class_3222 player = source.method_9207();
        InfoFileConfig config = this.loadedInfoFiles.get(lowercaseFileNameKey);
        String commandForMessages = context.getInput().split(" ")[0].substring(1).toLowerCase();
        if (config == null) {
            MessageFormatter.formatLines(List.of(msgs.getErrorInfoFileNotFound().replace("%fileNameKey%", lowercaseFileNameKey + ".json")), player, source.method_9211(), Broadcaster.getPlayerDataManager()).forEach(line -> player.method_7353(line, false));
            return 0;
        }
        if (config.isPermissionRequired()) {
            boolean hasPermission = false;
            if (config.getPermissionNode() != null && !config.getPermissionNode().isEmpty()) {
                hasPermission = BroadcasterCommand.checkPermission(source, config.getPermissionNode());
            }
            if (!hasPermission && !source.method_9259(4)) {
                player.method_64398((class_2561)class_2561.method_43470((String)("You do not have permission to use '/" + commandForMessages + "'.")).method_27692(class_124.field_1061));
                return 0;
            }
        }
        if (!config.isWorking()) {
            String disabledMsg = msgs.getErrorInfoCommandDisabled().replace("%command%", commandForMessages);
            MessageFormatter.formatLines(List.of(disabledMsg), player, source.method_9211(), Broadcaster.getPlayerDataManager()).forEach(line -> player.method_7353(line, false));
            if (!isAlias && !lowercaseFileNameKey.equalsIgnoreCase(HELP_FILE_NAME)) {
                String workHelpMsg = msgs.getErrorInfoCommandDisabledWorkHelp().replace("%command%", commandForMessages);
                MessageFormatter.formatLines(List.of(workHelpMsg), player, source.method_9211(), Broadcaster.getPlayerDataManager()).forEach(line -> player.method_7353(line, false));
            } else if (!isAlias && lowercaseFileNameKey.equalsIgnoreCase(HELP_FILE_NAME)) {
                MessageFormatter.formatLines(List.of("&cMod's /help is disabled. To re-enable: edit help.json to set \"working\": true, then /chatmod reload."), player, source.method_9211(), Broadcaster.getPlayerDataManager()).forEach(line -> player.method_7353(line, false));
            }
            return 0;
        }
        List<String> rawLines = config.getPages().get(sectionOrPageKey);
        if (rawLines == null && isSpecialHelpFile) {
            rawLines = config.getPages().get(sectionOrPageKey.toLowerCase());
        }
        if (isSpecialHelpFile) {
            totalPagesOrSections = config.getPages().size();
        } else {
            totalPagesOrSections = (int)config.getPages().keySet().stream().filter(k -> k.startsWith("page")).count();
            if (totalPagesOrSections == 0 && !config.getPages().isEmpty()) {
                totalPagesOrSections = config.getPages().size();
            }
            if (totalPagesOrSections == 0) {
                totalPagesOrSections = 1;
            }
        }
        if (rawLines == null || rawLines.isEmpty()) {
            Object keyNameForMsg = isSpecialHelpFile ? "'" + sectionOrPageKey + "'" : String.valueOf(displayPageNumber);
            String pageNotFoundMsg = msgs.getErrorPageNotFound().replace("%current_page%", (CharSequence)keyNameForMsg).replace("%command%", commandForMessages).replace("%max_pages%", String.valueOf(totalPagesOrSections > 0 ? Integer.valueOf(totalPagesOrSections) : "N/A"));
            MessageFormatter.formatLines(List.of(pageNotFoundMsg), player, source.method_9211(), Broadcaster.getPlayerDataManager()).forEach(line -> player.method_7353(line, false));
            return 0;
        }
        if (msgs.isShowInfoCommandHeader()) {
            String currentPageDisplay = isSpecialHelpFile ? sectionOrPageKey : String.valueOf(displayPageNumber);
            String maxPagesDisplay = String.valueOf(totalPagesOrSections) + (isSpecialHelpFile ? " sections" : "");
            String header = msgs.getInfoCommandHeaderFormat().replace("%command%", commandForMessages).replace("%config.json%", lowercaseFileNameKey + ".json").replace("%current_page%", currentPageDisplay).replace("%max_pages%", maxPagesDisplay);
            MessageFormatter.formatLines(List.of(header), player, source.method_9211(), Broadcaster.getPlayerDataManager()).forEach(line -> player.method_7353(line, false));
        }
        List<class_2561> formattedContent = MessageFormatter.formatLines(rawLines, player, source.method_9211(), Broadcaster.getPlayerDataManager());
        for (class_2561 line2 : formattedContent) {
            player.method_64398(line2);
        }
        if (msgs.isShowInfoCommandFooter()) {
            String currentPageDisplay = isSpecialHelpFile ? sectionOrPageKey : String.valueOf(displayPageNumber);
            String maxPagesDisplay = String.valueOf(totalPagesOrSections) + (isSpecialHelpFile ? " sections" : "");
            String footer = msgs.getInfoCommandFooterFormat().replace("%command%", commandForMessages).replace("%config.json%", lowercaseFileNameKey + ".json").replace("%current_page%", currentPageDisplay).replace("%max_pages%", maxPagesDisplay);
            MessageFormatter.formatLines(List.of(footer), player, source.method_9211(), Broadcaster.getPlayerDataManager()).forEach(line -> player.method_7353(line, false));
        }
        return 1;
    }

    public int displayInfoFileSection(class_2168 source, String fileNameAsTyped, String sectionKeyAsTyped) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        MessagesConfig msgs = Broadcaster.getMessagesManager().getMessagesConfig();
        String lowercaseFileNameKey = this.commandLookupMap.get(fileNameAsTyped.toLowerCase());
        if (lowercaseFileNameKey == null) {
            MessageFormatter.formatLines(List.of(msgs.getErrorInfoFileNotFound().replace("%fileNameKey%", fileNameAsTyped)), player, source.method_9211(), Broadcaster.getPlayerDataManager()).forEach(line -> player.method_7353(line, false));
            return 0;
        }
        InfoFileConfig config = this.loadedInfoFiles.get(lowercaseFileNameKey);
        if (config == null) {
            MessageFormatter.formatLines(List.of(msgs.getErrorInfoFileNotFound().replace("%fileNameKey%", lowercaseFileNameKey + ".json (internal error)")), player, source.method_9211(), Broadcaster.getPlayerDataManager()).forEach(line -> player.method_7353(line, false));
            return 0;
        }
        if (config.isPermissionRequired()) {
            boolean hasPermission = false;
            if (config.getPermissionNode() != null && !config.getPermissionNode().isEmpty()) {
                hasPermission = BroadcasterCommand.checkPermission(source, config.getPermissionNode());
            }
            if (!hasPermission && !source.method_9259(4)) {
                player.method_64398((class_2561)class_2561.method_43470((String)("You do not have permission to display info from '/" + lowercaseFileNameKey + "'.")).method_27692(class_124.field_1061));
                return 0;
            }
        }
        String commandForDisplay = lowercaseFileNameKey;
        if (!config.isWorking()) {
            String disabledMsg = msgs.getErrorInfoCommandDisabled().replace("%command%", commandForDisplay);
            MessageFormatter.formatLines(List.of(disabledMsg), player, source.method_9211(), Broadcaster.getPlayerDataManager()).forEach(line -> player.method_7353(line, false));
            return 0;
        }
        List<String> rawLines = config.getPages().get(sectionKeyAsTyped);
        if (rawLines == null) {
            rawLines = config.getPages().get(sectionKeyAsTyped.toLowerCase());
        }
        if (rawLines == null || rawLines.isEmpty()) {
            MessageFormatter.formatLines(List.of("&cSection '" + sectionKeyAsTyped + "' not found in " + commandForDisplay + " (" + lowercaseFileNameKey + ".json)."), player, source.method_9211(), Broadcaster.getPlayerDataManager()).forEach(line -> player.method_7353(line, false));
            return 0;
        }
        if (msgs.isShowInfoCommandHeader()) {
            String sectionHeader = msgs.getInfoCommandHeaderFormat().replace("%command%", commandForDisplay).replace("%config.json%", lowercaseFileNameKey + ".json").replace("%current_page%", sectionKeyAsTyped).replace("%max_pages%", String.valueOf(config.getPages().size()));
            MessageFormatter.formatLines(List.of(sectionHeader), player, source.method_9211(), Broadcaster.getPlayerDataManager()).forEach(line -> player.method_7353(line, false));
        }
        List<class_2561> formattedContent = MessageFormatter.formatLines(rawLines, player, source.method_9211(), Broadcaster.getPlayerDataManager());
        for (class_2561 line2 : formattedContent) {
            player.method_64398(line2);
        }
        return 1;
    }

    public List<String> getLoadedInfoFileNames() {
        return new ArrayList<String>(this.loadedInfoFiles.keySet());
    }

    public void refreshCommands() {
        if (this.lastDispatcher != null) {
            if (Broadcaster.getMessagesManager() != null) {
                Broadcaster.getMessagesManager().loadMessages();
            }
            Broadcaster.LOGGER.info("[ChatMod] Refreshing info commands: Loading files from disk...");
            this.loadInfoFiles();
            Broadcaster.LOGGER.info("[ChatMod] Re-registering info commands with dispatcher...");
            this.registerInfoCommands(this.lastDispatcher);
            Broadcaster.LOGGER.info("[ChatMod] Info commands refreshed and re-registered.");
        } else {
            Broadcaster.LOGGER.warn("[ChatMod] Cannot refresh info commands: dispatcher not available.");
        }
    }

    private static /* synthetic */ class_2561 lambda$togglePermissionRequired$16(String lowercaseFileNameKey, String statusText, boolean newState, String finalNode) {
        return class_2561.method_43470((String)("Permission requirement for '/" + lowercaseFileNameKey + "' is now " + statusText + ".")).method_10852((class_2561)(newState && finalNode != null ? class_2561.method_43470((String)(" Node: " + finalNode)).method_27692(class_124.field_1080) : class_2561.method_43470((String)"")));
    }
}

