/*
 * Decompiled with CFR 0.152.
 */
package me.andy.chatmod.manager;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.andy.chatmod.Broadcaster;
import me.andy.chatmod.command.BroadcasterCommand;
import me.andy.chatmod.config.PredefinedBroadcast;
import me.andy.chatmod.config.PredefinedBroadcastsConfig;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;

public class PredefinedBroadcastManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().disableHtmlEscaping().create();
    private final File configFile;
    private PredefinedBroadcastsConfig config;

    public PredefinedBroadcastManager() {
        Path configDir = FabricLoader.getInstance().getConfigDir().resolve("chatmod");
        try {
            Files.createDirectories(configDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            Broadcaster.LOGGER.error("[ChatMod] Failed to create mod config directory: " + String.valueOf(configDir), (Throwable)e);
        }
        this.configFile = configDir.resolve("predefined_broadcasts.json").toFile();
        this.loadConfig();
    }

    public void loadConfig() {
        if (this.configFile.exists()) {
            try (FileReader reader = new FileReader(this.configFile);){
                this.config = (PredefinedBroadcastsConfig)GSON.fromJson((Reader)reader, PredefinedBroadcastsConfig.class);
                if (this.config == null || this.config.getBroadcasts() == null) {
                    Broadcaster.LOGGER.warn("[ChatMod] Predefined broadcasts config file was empty or malformed. Initializing with empty config.");
                    this.config = new PredefinedBroadcastsConfig();
                }
            }
            catch (JsonSyntaxException | IOException e) {
                Broadcaster.LOGGER.error("[ChatMod] Failed to load predefined broadcasts config. Using empty default and attempting to save a new one.", e);
                this.config = new PredefinedBroadcastsConfig();
                this.createDefaultConfigFile();
            }
        } else {
            Broadcaster.LOGGER.info("[ChatMod] No predefined_broadcasts.json found. Creating a default one with examples.");
            this.createDefaultConfigFile();
        }
        if (this.config != null && this.config.getBroadcasts() != null) {
            Broadcaster.LOGGER.info("[ChatMod] Loaded {} predefined broadcasts.", (Object)this.config.getBroadcasts().size());
        }
    }

    private void createDefaultConfigFile() {
        this.config = new PredefinedBroadcastsConfig();
        this.config.predefined_broadcasts = new LinkedHashMap<String, PredefinedBroadcast>();
        this.config.predefined_broadcasts.put("welcome_new", new PredefinedBroadcast(List.of("&eWelcome all new adventurers to Our Server!", "&eType &a/help&e for a list of useful commands."), false, ""));
        this.config.predefined_broadcasts.put("vote_reminder", new PredefinedBroadcast(List.of("&bEnjoying your time? Support us by voting!", "&bUse &a/vote&b to find our voting links!"), false, ""));
        this.config.predefined_broadcasts.put("event_starting_soon", new PredefinedBroadcast(List.of("&6[EVENT] &eA server event will be starting soon!", "&eMake your way to &a/warp events&e!", "&7(This event sequence concludes at %scheduled_end_time%, with %countdown% remaining.)"), true, "chatmod.broadcast.event_starting_soon"));
        this.config.predefined_broadcasts.put("discord_promo", new PredefinedBroadcast(List.of("&9Join our vibrant community on Discord!", "&bdiscord.gg/YourServerInvLink{&7Click to copy link!}<action:copy_to_clipboard,discord.gg/YourServerInvLink>", "&7(Link is an example, replace in predefined_broadcasts.json)"), false, ""));
        this.config.predefined_broadcasts.put("maintenance_alert", new PredefinedBroadcast(List.of("&c[ATTENTION] &eServer maintenance is scheduled in &630 minutes&e.", "&eThe server will restart briefly. Please save your progress."), true, "chatmod.broadcast.maintenance_alert"));
        this.config.predefined_broadcasts.put("actionbar_example", new PredefinedBroadcast("ACTION_BAR", List.of("&b[TIP] &aYou can use action bars for short, non-intrusive messages!"), false, ""));
        this.config.predefined_broadcasts.put("title_example", new PredefinedBroadcast("TITLE", List.of("&6A Wild Event Appears!", "&ePrepare for battle!"), false, ""));
        PredefinedBroadcast bossbarExample = new PredefinedBroadcast("BOSSBAR", List.of("&5[SALE] &dDon't miss our store-wide sale!"), false, "");
        bossbarExample.duration_seconds = 15;
        bossbarExample.bossbar_color = "PINK";
        bossbarExample.bossbar_overlay = "NOTCHED_10";
        this.config.predefined_broadcasts.put("bossbar_example", bossbarExample);
        this.saveConfig();
    }

    public void saveConfig() {
        try (FileWriter writer = new FileWriter(this.configFile);){
            GSON.toJson((Object)this.config, (Appendable)writer);
        }
        catch (IOException e) {
            Broadcaster.LOGGER.error("[ChatMod] Failed to save predefined broadcasts config.", (Throwable)e);
        }
    }

    public PredefinedBroadcast getBroadcast(String name) {
        if (this.config == null || this.config.getBroadcasts() == null) {
            return null;
        }
        return this.config.getBroadcasts().get(name.toLowerCase());
    }

    public List<String> getAllBroadcastNames() {
        if (this.config == null || this.config.getBroadcasts() == null) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(this.config.getBroadcasts().keySet());
    }

    public List<String> getPermittedBroadcastNames(class_2168 source) {
        if (this.config == null || this.config.getBroadcasts() == null) {
            return Collections.emptyList();
        }
        return this.config.getBroadcasts().entrySet().stream().filter(entry -> this.hasPermissionForBroadcast(source, (String)entry.getKey())).map(Map.Entry::getKey).sorted().collect(Collectors.toList());
    }

    public boolean hasPermissionForBroadcast(class_2168 source, String broadcastName) {
        PredefinedBroadcast bc = this.getBroadcast(broadcastName);
        if (bc == null) {
            return false;
        }
        if (!bc.isPermissionRequired()) {
            return true;
        }
        if (bc.getPermissionNode() != null && !bc.getPermissionNode().isEmpty()) {
            return BroadcasterCommand.checkPermission(source, bc.getPermissionNode());
        }
        Broadcaster.LOGGER.warn("[ChatMod] Predefined broadcast '{}' requires permission but has no permission node defined. Access denied by default.", (Object)broadcastName);
        return false;
    }
}

