/*
 * Decompiled with CFR 0.152.
 */
package me.andy.chatmod.config;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import me.andy.chatmod.Broadcaster;

public class BroadcasterConfig {
    public String serverTimezone = ZoneId.systemDefault().getId();
    public boolean motdEnabled = true;
    public List<MOTDDefinition> motdMessages = new ArrayList<MOTDDefinition>();
    public boolean broadcastEnabled = true;
    public int broadcastIntervalSeconds = 300;
    public List<BroadcastMessageDefinition> broadcastMessages = new ArrayList<BroadcastMessageDefinition>();

    public BroadcasterConfig() {
        ArrayList<String> defaultMotdLines = new ArrayList<String>();
        defaultMotdLines.add("-----------------------------------------------------");
        defaultMotdLines.add("&+&bWelcome, %player%&b to Our Amazing Server!");
        defaultMotdLines.add("&7Your total playtime: &e%playtime%");
        defaultMotdLines.add("&7Last joined: &e%last_play_time% {We're glad to see you again!}");
        defaultMotdLines.add("&7Type &a/rules&7 to see the server rules (if example info file is enabled).");
        defaultMotdLines.add("&m                                                                                 ");
        this.motdMessages.add(new MOTDDefinition(defaultMotdLines));
        this.broadcastMessages.add(new BroadcastMessageDefinition("CHAT", List.of("&a[Server Info] &eThis is a &lCHAT&r&e type broadcast.", "&eYou can use multiple lines and &c&lformatting codes&e.", "&7Currently &e%online_players%/%max_players%&7 players online.", "&7Server time: &e%time% &7(&e%date%&7)")));
        this.broadcastMessages.add(new BroadcastMessageDefinition("ACTION_BAR", List.of("&b[ACTION BAR] &aThis message appears above your XP bar!")));
        this.broadcastMessages.add(new BroadcastMessageDefinition("TITLE", List.of("&6&lWelcome to the Event!", "&eStarting in %countdown%!")));
        this.broadcastMessages.add(new BroadcastMessageDefinition("BOSSBAR", List.of("&d[BOSSBAR] &5Server Announcement!"), 15, "BLUE", "PROGRESS"));
        this.broadcastMessages.add(new BroadcastMessageDefinition("CHAT", List.of("&a[Click Me]{Click to run a command!}<action:run_command,/say Hello from %player%>")));
        this.broadcastMessages.add(new BroadcastMessageDefinition("CHAT", List.of("&b[Suggest Help]{Click to suggest /help}<action:suggest_command,/help>")));
        this.broadcastMessages.add(new BroadcastMessageDefinition("CHAT", List.of("&9[Visit Website]{Click to open our website!}<action:open_url,https://example.com>")));
        this.broadcastMessages.add(new BroadcastMessageDefinition("CHAT", List.of("&a[Click Me]{Click to run a command!}<action:run_command,/say Hello from %player%>         &b[Suggest Help]{Click to suggest /help}<action:suggest_command,/help>         &9[Visit Website]{Click to open our website!}<action:open_url,https://example.com>")));
    }

    public String getServerTimezone() {
        try {
            ZoneId.of(this.serverTimezone);
            return this.serverTimezone;
        }
        catch (Exception e) {
            Broadcaster.LOGGER.warn("Invalid serverTimezone '{}' in config, defaulting to system default '{}'", (Object)this.serverTimezone, (Object)ZoneId.systemDefault().getId());
            return ZoneId.systemDefault().getId();
        }
    }

    public boolean isMotdEnabled() {
        return this.motdEnabled;
    }

    public List<MOTDDefinition> getMotdMessages() {
        return this.motdMessages == null ? new ArrayList() : this.motdMessages;
    }

    public boolean isBroadcastEnabled() {
        return this.broadcastEnabled;
    }

    public int getBroadcastIntervalSeconds() {
        return this.broadcastIntervalSeconds <= 0 ? 300 : this.broadcastIntervalSeconds;
    }

    public List<BroadcastMessageDefinition> getBroadcastMessages() {
        return this.broadcastMessages == null ? new ArrayList() : this.broadcastMessages;
    }

    public static class MOTDDefinition {
        public List<String> lines = new ArrayList<String>();

        public MOTDDefinition() {
        }

        public MOTDDefinition(List<String> lines) {
            this.lines = lines;
        }
    }

    public static class BroadcastMessageDefinition {
        public String type = "CHAT";
        public List<String> lines = new ArrayList<String>();
        public int durationSeconds = 10;
        public String bossBarColor = "PURPLE";
        public String bossBarOverlay = "PROGRESS";

        public BroadcastMessageDefinition() {
        }

        public BroadcastMessageDefinition(String type, List<String> lines) {
            this.type = type;
            this.lines = lines;
        }

        public BroadcastMessageDefinition(String type, List<String> lines, int durationSeconds, String bossBarColor, String bossBarOverlay) {
            this.type = type;
            this.lines = lines;
            this.durationSeconds = durationSeconds;
            this.bossBarColor = bossBarColor;
            this.bossBarOverlay = bossBarOverlay;
        }
    }
}

