/*
 * Decompiled with CFR 0.152.
 */
package me.andy.chatmod.config;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import me.andy.chatmod.Broadcaster;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_7225;

public class PredefinedItemData {
    public String nbtString;

    public PredefinedItemData() {
    }

    public PredefinedItemData(String nbtString) {
        this.nbtString = nbtString;
    }

    public static PredefinedItemData fromItemStack(class_1799 stack, class_7225.class_7874 registryLookup) {
        if (stack == null || stack.method_7960()) {
            return null;
        }
        DataResult result = class_1799.field_24671.encodeStart((DynamicOps)registryLookup.method_57093((DynamicOps)class_2509.field_11560), (Object)stack);
        class_2520 nbtElement = (class_2520)result.getOrThrow(error -> new IllegalStateException("Failed to encode item stack: " + error + " " + String.valueOf(stack)));
        if (!(nbtElement instanceof class_2487)) {
            Broadcaster.LOGGER.warn("[ChatMod] ItemStack.CODEC.encodeStart did not return an NbtCompound for item: {}. Item will not be stored.", (Object)stack);
            return null;
        }
        class_2487 nbt = (class_2487)nbtElement;
        if (nbt.method_33133()) {
            Broadcaster.LOGGER.warn("[ChatMod] ItemStack.CODEC.encodeStart resulted in empty NBT for item: {}. Item will not be stored.", (Object)stack);
            return null;
        }
        return new PredefinedItemData(nbt.toString());
    }

    public class_1799 toItemStack(class_7225.class_7874 registryLookup) {
        if (this.nbtString == null || this.nbtString.trim().isEmpty()) {
            return class_1799.field_8037;
        }
        try {
            class_2487 nbt = class_2512.method_32260((String)this.nbtString);
            return (class_1799)class_1799.field_24671.parse((DynamicOps)registryLookup.method_57093((DynamicOps)class_2509.field_11560), (Object)nbt).getOrThrow(error -> new IllegalStateException("Failed to decode item stack: " + error + " " + String.valueOf(nbt)));
        }
        catch (CommandSyntaxException | IllegalStateException e) {
            Broadcaster.LOGGER.error("[ChatMod] Failed to parse SNBT or decode item for predefined item: {}. Error: {}", (Object)this.nbtString, (Object)e.getMessage());
            return class_1799.field_8037;
        }
    }

    public String getNbtString() {
        return this.nbtString;
    }

    public void setNbtString(String nbtString) {
        this.nbtString = nbtString;
    }
}

