/*
 * Decompiled with CFR 0.152.
 */
package me.andy.chatmod.data;

public class PlayerData {
    private long totalPlaytimeMillis;
    private long firstLoginTimeMillis;
    private long lastLoginTimeMillis;
    private transient long currentSessionStartTimeMillis;

    public PlayerData(long currentTimeMillis) {
        this.firstLoginTimeMillis = currentTimeMillis;
        this.lastLoginTimeMillis = currentTimeMillis;
        this.totalPlaytimeMillis = 0L;
        this.currentSessionStartTimeMillis = currentTimeMillis;
    }

    private PlayerData() {
    }

    public long getTotalPlaytimeMillis() {
        return this.totalPlaytimeMillis;
    }

    public void setTotalPlaytimeMillis(long totalPlaytimeMillis) {
        this.totalPlaytimeMillis = totalPlaytimeMillis;
    }

    public long getFirstLoginTimeMillis() {
        return this.firstLoginTimeMillis;
    }

    public void setFirstLoginTimeMillis(long firstLoginTimeMillis) {
        this.firstLoginTimeMillis = firstLoginTimeMillis;
    }

    public long getLastLoginTimeMillis() {
        return this.lastLoginTimeMillis;
    }

    public void setLastLoginTimeMillis(long lastLoginTimeMillis) {
        this.lastLoginTimeMillis = lastLoginTimeMillis;
    }

    public long getCurrentSessionStartTimeMillis() {
        return this.currentSessionStartTimeMillis;
    }

    public void setCurrentSessionStartTimeMillis(long currentSessionStartTimeMillis) {
        this.currentSessionStartTimeMillis = currentSessionStartTimeMillis;
    }

    public void onLogin(long loginTimeMillis) {
        this.lastLoginTimeMillis = loginTimeMillis;
        this.currentSessionStartTimeMillis = loginTimeMillis;
        if (this.firstLoginTimeMillis == 0L) {
            this.firstLoginTimeMillis = loginTimeMillis;
        }
    }

    public void onLogout(long logoutTimeMillis) {
        if (this.currentSessionStartTimeMillis > 0L) {
            long sessionDuration = logoutTimeMillis - this.currentSessionStartTimeMillis;
            if (sessionDuration > 0L) {
                this.totalPlaytimeMillis += sessionDuration;
            }
            this.currentSessionStartTimeMillis = 0L;
        }
    }
}

