/*
 * Decompiled with CFR 0.152.
 */
package me.andy.chatmod.manager;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import me.andy.chatmod.Broadcaster;
import me.andy.chatmod.config.PlaceholdersConfig;
import net.fabricmc.loader.api.FabricLoader;

public class PlaceholdersManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().disableHtmlEscaping().create();
    private final File configFile;
    private PlaceholdersConfig config;

    public PlaceholdersManager() {
        Path configDir = FabricLoader.getInstance().getConfigDir().resolve("chatmod");
        try {
            Files.createDirectories(configDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            Broadcaster.LOGGER.error("[ChatMod] Failed to create mod config directory: " + String.valueOf(configDir), (Throwable)e);
        }
        this.configFile = configDir.resolve("placeholders.json").toFile();
        this.loadConfig();
    }

    public void loadConfig() {
        if (this.configFile.exists()) {
            try (FileReader reader = new FileReader(this.configFile);){
                this.config = (PlaceholdersConfig)GSON.fromJson((Reader)reader, PlaceholdersConfig.class);
                if (this.config == null) {
                    Broadcaster.LOGGER.warn("[ChatMod] placeholders.json was empty. Loading defaults.");
                    this.config = new PlaceholdersConfig();
                    this.saveConfig();
                }
            }
            catch (JsonSyntaxException | IOException e) {
                Broadcaster.LOGGER.error("[ChatMod] Failed to load placeholders.json. Using defaults.", e);
                this.config = new PlaceholdersConfig();
            }
        } else {
            Broadcaster.LOGGER.info("[ChatMod] No placeholders.json found. Creating default.");
            this.config = new PlaceholdersConfig();
            this.saveConfig();
        }
    }

    public void saveConfig() {
        try (FileWriter writer = new FileWriter(this.configFile);){
            GSON.toJson((Object)this.config, (Appendable)writer);
        }
        catch (IOException e) {
            Broadcaster.LOGGER.error("[ChatMod] Failed to save placeholders.json.", (Throwable)e);
        }
    }

    public PlaceholdersConfig getConfig() {
        if (this.config == null) {
            this.loadConfig();
        }
        return this.config;
    }
}

