/*
 * Decompiled with CFR 0.152.
 */
package me.andy.chatmod.manager;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import me.andy.chatmod.Broadcaster;
import me.andy.chatmod.config.PredefinedItemData;
import me.andy.chatmod.config.PredefinedItemsConfig;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1799;
import net.minecraft.class_7225;

public class PredefinedItemManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
    private final File configFile;
    private PredefinedItemsConfig itemsConfig;

    public PredefinedItemManager() {
        Path configDir = FabricLoader.getInstance().getConfigDir().resolve("chatmod");
        try {
            Files.createDirectories(configDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            Broadcaster.LOGGER.error("[ChatMod] Failed to create mod config directory: " + String.valueOf(configDir), (Throwable)e);
        }
        this.configFile = configDir.resolve("predefined_items.json").toFile();
        this.loadConfig();
    }

    public synchronized void loadConfig() {
        if (this.configFile.exists()) {
            try (FileReader reader = new FileReader(this.configFile);){
                this.itemsConfig = (PredefinedItemsConfig)GSON.fromJson((Reader)reader, PredefinedItemsConfig.class);
                if (this.itemsConfig == null) {
                    Broadcaster.LOGGER.warn("[ChatMod] Predefined items config file ({}) was empty or malformed (null after GSON parse). Initializing with new default config.", (Object)this.configFile.getName());
                    this.itemsConfig = new PredefinedItemsConfig();
                } else if (this.itemsConfig.getItems() == null) {
                    Broadcaster.LOGGER.warn("[ChatMod] Predefined items map was null in ({}). Ensuring it is initialized.", (Object)this.configFile.getName());
                    this.itemsConfig.getItems();
                }
            }
            catch (JsonSyntaxException e) {
                Broadcaster.LOGGER.error("[ChatMod] Failed to parse predefined items config file ({}) due to JSON syntax error. Backing up corrupted file and using new default config.", (Object)this.configFile.getName(), (Object)e);
                this.backupCorruptedConfig();
                this.itemsConfig = new PredefinedItemsConfig();
                this.saveConfigInternal();
            }
            catch (IOException e) {
                Broadcaster.LOGGER.error("[ChatMod] Failed to read predefined items config file ({}). Using new default config.", (Object)this.configFile.getName(), (Object)e);
                this.itemsConfig = new PredefinedItemsConfig();
            }
        } else {
            Broadcaster.LOGGER.info("[ChatMod] No predefined_items.json found. Creating a new default (empty) configuration file for {}.", (Object)"chatmod");
            this.itemsConfig = new PredefinedItemsConfig();
            this.saveConfigInternal();
        }
        if (this.itemsConfig == null) {
            Broadcaster.LOGGER.error("[ChatMod] PredefinedItemsConfig is still null after load process. This is unexpected. Initializing a new one.");
            this.itemsConfig = new PredefinedItemsConfig();
        }
        Broadcaster.LOGGER.info("[ChatMod] Loaded {} predefined item slots from {}.", (Object)this.itemsConfig.getItems().size(), (Object)this.configFile.getName());
    }

    private void backupCorruptedConfig() {
        if (this.configFile.exists()) {
            File backupFile = new File(this.configFile.getParentFile(), this.configFile.getName() + ".corrupted." + System.currentTimeMillis());
            if (this.configFile.renameTo(backupFile)) {
                Broadcaster.LOGGER.info("[ChatMod] Backed up corrupted predefined items config to: {}", (Object)backupFile.getName());
            } else {
                Broadcaster.LOGGER.error("[ChatMod] Could not backup corrupted predefined items config: {}", (Object)this.configFile.getName());
            }
        }
    }

    private void saveConfigInternal() {
        if (this.itemsConfig == null) {
            Broadcaster.LOGGER.error("[ChatMod] Attempted to save null PredefinedItemsConfig. Aborting save.");
            return;
        }
        File parentDir = this.configFile.getParentFile();
        if (!parentDir.exists() && !parentDir.mkdirs()) {
            Broadcaster.LOGGER.error("[ChatMod] Failed to create parent directory for predefined items config: {}. Cannot save.", (Object)parentDir.getAbsolutePath());
            return;
        }
        try (FileWriter writer = new FileWriter(this.configFile);){
            GSON.toJson((Object)this.itemsConfig, (Appendable)writer);
            Broadcaster.LOGGER.debug("[ChatMod] Predefined items configuration saved to {}.", (Object)this.configFile.getName());
        }
        catch (IOException e) {
            Broadcaster.LOGGER.error("[ChatMod] Failed to save predefined items config file ({}).", (Object)this.configFile.getName(), (Object)e);
        }
    }

    public synchronized void saveConfig() {
        this.saveConfigInternal();
    }

    public synchronized class_1799 getItemStack(int slot, class_7225.class_7874 registryLookup) {
        PredefinedItemData itemData;
        if (this.itemsConfig == null) {
            Broadcaster.LOGGER.warn("[ChatMod] PredefinedItemsConfig is null. Cannot get ItemStack for slot {}. Attempting to load.", (Object)slot);
            this.loadConfig();
            if (this.itemsConfig == null) {
                return class_1799.field_8037;
            }
        }
        if ((itemData = this.itemsConfig.getItems().get(slot)) != null) {
            return itemData.toItemStack(registryLookup);
        }
        return class_1799.field_8037;
    }

    public synchronized void setItemStack(int slot, class_1799 stack, class_7225.class_7874 registryLookup) {
        if (this.itemsConfig == null) {
            Broadcaster.LOGGER.error("[ChatMod] PredefinedItemsConfig is null. Cannot set ItemStack for slot {}. Attempting to load config.", (Object)slot);
            this.loadConfig();
            if (this.itemsConfig == null) {
                Broadcaster.LOGGER.error("[ChatMod] PredefinedItemsConfig remains null after reload attempt. Cannot set item in slot {}.", (Object)slot);
                return;
            }
        }
        Map<Integer, PredefinedItemData> itemsMap = this.itemsConfig.getItems();
        if (stack == null || stack.method_7960()) {
            if (itemsMap.remove(slot) != null) {
                Broadcaster.LOGGER.debug("[ChatMod] Cleared item from slot {}.", (Object)slot);
            }
        } else {
            PredefinedItemData itemData = PredefinedItemData.fromItemStack(stack, registryLookup);
            if (itemData != null && itemData.getNbtString() != null && !itemData.getNbtString().isEmpty()) {
                itemsMap.put(slot, itemData);
                Broadcaster.LOGGER.debug("[ChatMod] Set item in slot {}: {}", (Object)slot, (Object)stack.toString());
            } else {
                itemsMap.remove(slot);
                Broadcaster.LOGGER.warn("[ChatMod] Failed to create valid PredefinedItemData for slot {} (or item was effectively empty). Slot cleared.", (Object)slot);
            }
        }
        this.saveConfigInternal();
    }

    public synchronized void removeItemStack(int slot) {
        if (this.itemsConfig == null) {
            Broadcaster.LOGGER.warn("[ChatMod] PredefinedItemsConfig is null. Cannot remove item from slot {}. Attempting to load config.", (Object)slot);
            this.loadConfig();
            if (this.itemsConfig == null) {
                Broadcaster.LOGGER.error("[ChatMod] PredefinedItemsConfig remains null after reload. Cannot remove item from slot {}.", (Object)slot);
                return;
            }
        }
        if (this.itemsConfig.getItems().remove(slot) != null) {
            Broadcaster.LOGGER.debug("[ChatMod] Removed item from slot {}.", (Object)slot);
        }
        this.saveConfigInternal();
    }

    public PredefinedItemsConfig getConfig() {
        if (this.itemsConfig == null) {
            Broadcaster.LOGGER.warn("[ChatMod] PredefinedItemsConfig was null when getConfig() was called. Attempting to load.");
            this.loadConfig();
            if (this.itemsConfig == null) {
                Broadcaster.LOGGER.error("[ChatMod] CRITICAL: PredefinedItemsConfig is null even after attempting reload in getConfig(). Returning new empty config.");
                this.itemsConfig = new PredefinedItemsConfig();
            }
        }
        return this.itemsConfig;
    }

    public synchronized Map<Integer, PredefinedItemData> getAllItems() {
        if (this.itemsConfig == null) {
            Broadcaster.LOGGER.warn("[ChatMod] PredefinedItemsConfig is null when getAllItems() was called. Attempting to load.");
            this.loadConfig();
            if (this.itemsConfig == null) {
                Broadcaster.LOGGER.error("[ChatMod] CRITICAL: PredefinedItemsConfig is null even after attempting reload in getAllItems(). Returning empty map.");
                return Collections.emptyMap();
            }
        }
        return new HashMap<Integer, PredefinedItemData>(this.itemsConfig.getItems());
    }

    public synchronized void setAllItems(Map<Integer, PredefinedItemData> newItems) {
        if (this.itemsConfig == null) {
            Broadcaster.LOGGER.warn("[ChatMod] PredefinedItemsConfig is null when setAllItems() was called. Attempting to load.");
            this.loadConfig();
            if (this.itemsConfig == null) {
                Broadcaster.LOGGER.error("[ChatMod] CRITICAL: PredefinedItemsConfig is null even after attempting reload in setAllItems(). Cannot update items.");
                return;
            }
        }
        this.itemsConfig.setItems(newItems);
    }
}

