/*
 * Decompiled with CFR 0.152.
 */
package me.andy.chatmod.message;

import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.Placeholders;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.TextStyle;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import me.andy.chatmod.Broadcaster;
import me.andy.chatmod.data.PlayerData;
import me.andy.chatmod.data.PlayerDataManager;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class PlaceholderResolver {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss z");

    public static String resolve(String text, @Nullable class_3222 player, @Nullable MinecraftServer server, @Nullable PlayerDataManager playerDataManager) {
        String serverTimezoneId = Broadcaster.getConfigManager() != null ? Broadcaster.getConfigManager().getConfig().getServerTimezone() : ZoneId.systemDefault().getId();
        ZoneId serverZone = ZoneId.systemDefault();
        try {
            serverZone = ZoneId.of(serverTimezoneId);
        }
        catch (Exception e) {
            Broadcaster.LOGGER.warn("Invalid server timezone in config for general placeholder resolving: '{}'. Using system default.", (Object)serverTimezoneId);
        }
        return PlaceholderResolver.resolveInternal(text, player, server, playerDataManager, -1L, serverZone, -1L);
    }

    public static List<String> resolvePlaceholders(List<String> linesToResolve, @Nullable class_3222 player, MinecraftServer server, @Nullable PlayerDataManager playerDataManager, long finalExecutionTimeEpochMillis, long currentScheduledBroadcastIntervalMillis, String schedulingTimezoneId) {
        ZoneId scheduleZone = ZoneId.systemDefault();
        try {
            scheduleZone = ZoneId.of(schedulingTimezoneId);
        }
        catch (Exception e) {
            Broadcaster.LOGGER.warn("Invalid scheduling timezoneId for placeholder resolving: '{}'. Using system default.", (Object)schedulingTimezoneId);
        }
        ZoneId finalScheduleZone = scheduleZone;
        return linesToResolve.stream().map(line -> PlaceholderResolver.resolveInternal(line, player, server, playerDataManager, finalExecutionTimeEpochMillis, finalScheduleZone, currentScheduledBroadcastIntervalMillis)).collect(Collectors.toList());
    }

    private static String resolveInternal(String text, @Nullable class_3222 player, @Nullable MinecraftServer server, @Nullable PlayerDataManager playerDataManager, long finalExecutionTimeEpochMillis, ZoneId displayZoneId, long currentScheduledBroadcastIntervalMillis) {
        if (text == null) {
            return "";
        }
        String resolvedText = text;
        if (player != null) {
            resolvedText = resolvedText.replace("%player%", player.method_5477().getString());
            resolvedText = resolvedText.replace("%player_uuid%", player.method_5667().toString());
            resolvedText = resolvedText.replace("%player_ping%", String.valueOf(player.field_13987.method_52405()));
            resolvedText = resolvedText.replace("%player_world%", player.method_51469().method_27983().method_29177().toString());
            resolvedText = resolvedText.replace("%player_x%", String.format("%.1f", player.method_23317()));
            resolvedText = resolvedText.replace("%player_y%", String.format("%.1f", player.method_23318()));
            resolvedText = resolvedText.replace("%player_z%", String.format("%.1f", player.method_23321()));
            if (playerDataManager != null) {
                PlayerData data = playerDataManager.getPlayerData(player);
                if (data != null) {
                    resolvedText = resolvedText.replace("%playtime%", PlaceholderResolver.formatDuration(data.getTotalPlaytimeMillis()));
                    resolvedText = resolvedText.replace("%last_play_time%", PlaceholderResolver.formatTimestamp(data.getLastLoginTimeMillis(), displayZoneId));
                    resolvedText = resolvedText.replace("%player_first_joined%", PlaceholderResolver.formatTimestamp(data.getFirstLoginTimeMillis(), displayZoneId));
                } else {
                    resolvedText = PlaceholderResolver.replaceWithNA(resolvedText, "%playtime%", "%last_play_time%", "%player_first_joined%");
                }
            }
        } else {
            resolvedText = resolvedText.replace("%player%", "Server");
            resolvedText = PlaceholderResolver.replaceWithNA(resolvedText, "%player_uuid%", "%playtime%", "%last_play_time%", "%player_first_joined%", "%player_ping%", "%player_world%", "%player_x%", "%player_y%", "%player_z%");
        }
        if (server != null) {
            resolvedText = resolvedText.replace("%server_name%", server.method_3818());
            resolvedText = resolvedText.replace("%online_players%", String.valueOf(server.method_3788()));
            resolvedText = resolvedText.replace("%max_players%", String.valueOf(server.method_3802()));
            resolvedText = resolvedText.replace("%server_tps%", "N/A");
        }
        ZonedDateTime now = ZonedDateTime.now(displayZoneId);
        resolvedText = resolvedText.replace("%date%", now.format(DATE_FORMATTER));
        resolvedText = resolvedText.replace("%time%", now.format(TIME_FORMATTER));
        resolvedText = resolvedText.replace("%datetime%", now.format(DATE_TIME_FORMATTER));
        resolvedText = resolvedText.replace("%timezone%", displayZoneId.getDisplayName(TextStyle.SHORT, Locale.getDefault()));
        if (finalExecutionTimeEpochMillis > 0L) {
            long millisRemaining = finalExecutionTimeEpochMillis - System.currentTimeMillis();
            resolvedText = millisRemaining > 0L ? resolvedText.replace("%countdown%", PlaceholderResolver.formatDuration(millisRemaining) + " left") : resolvedText.replace("%countdown%", "Ending now");
            ZonedDateTime finalZonedTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(finalExecutionTimeEpochMillis), displayZoneId);
            resolvedText = resolvedText.replace("%scheduled_end_time%", finalZonedTime.format(TIME_FORMATTER));
            resolvedText = resolvedText.replace("%scheduled_end_datetime%", finalZonedTime.format(DATE_TIME_FORMATTER));
        } else {
            resolvedText = resolvedText.replace("%countdown%", "");
            resolvedText = resolvedText.replace("%scheduled_end_time%", "");
            resolvedText = resolvedText.replace("%scheduled_end_datetime%", "");
        }
        try {
            PlaceholderContext ctx = null;
            if (player != null) {
                ctx = PlaceholderContext.of((class_3222)player);
            } else if (server != null) {
                ctx = PlaceholderContext.of((MinecraftServer)server);
            } else {
                MinecraftServer globalServer = Broadcaster.getServerInstance();
                if (globalServer != null) {
                    ctx = PlaceholderContext.of((MinecraftServer)globalServer);
                }
            }
            if (ctx != null) {
                class_2561 parsedText = Placeholders.parseText((class_2561)class_2561.method_43470((String)resolvedText), (PlaceholderContext)ctx);
                resolvedText = parsedText.getString();
            }
        }
        catch (Exception | NoClassDefFoundError throwable) {
            // empty catch block
        }
        return resolvedText;
    }

    private static String replaceWithNA(String text, String ... placeholders) {
        String result = text;
        for (String placeholder : placeholders) {
            result = result.replace(placeholder, "N/A");
        }
        return result;
    }

    public static String formatDuration(long millis) {
        if (millis < 0L) {
            return "N/A";
        }
        if (millis == 0L) {
            return "0s";
        }
        long days = TimeUnit.MILLISECONDS.toDays(millis);
        long hours = TimeUnit.MILLISECONDS.toHours(millis -= TimeUnit.DAYS.toMillis(days));
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis -= TimeUnit.HOURS.toMillis(hours));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(millis -= TimeUnit.MINUTES.toMillis(minutes));
        StringBuilder sb = new StringBuilder();
        if (days > 0L) {
            sb.append(days).append("d ");
        }
        if (hours > 0L) {
            sb.append(hours).append("h ");
        }
        if (minutes > 0L) {
            sb.append(minutes).append("m ");
        }
        if (seconds > 0L || sb.length() == 0) {
            sb.append(seconds).append("s");
        }
        return sb.toString().trim();
    }

    public static String formatTimestamp(long epochMillis, ZoneId zoneId) {
        if (epochMillis <= 0L) {
            return "Never";
        }
        try {
            return DATE_TIME_FORMATTER.format(ZonedDateTime.ofInstant(Instant.ofEpochMilli(epochMillis), zoneId));
        }
        catch (Exception e) {
            Broadcaster.LOGGER.warn("Failed to format timestamp for zone {}: {}", (Object)zoneId, (Object)e.getMessage());
            return DATE_TIME_FORMATTER.format(ZonedDateTime.ofInstant(Instant.ofEpochMilli(epochMillis), ZoneId.systemDefault()));
        }
    }
}

