/*
 * Decompiled with CFR 0.152.
 */
package me.andy.chatmod.scheduler;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import me.andy.chatmod.Broadcaster;
import me.andy.chatmod.config.BroadcasterConfig;
import me.andy.chatmod.data.PlayerDataManager;
import me.andy.chatmod.message.MessageFormatter;
import net.minecraft.class_1259;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_3002;
import net.minecraft.class_3213;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5894;
import net.minecraft.class_5903;
import net.minecraft.class_5904;
import net.minecraft.class_5905;
import net.minecraft.server.MinecraftServer;

public class BroadcastTask
implements Runnable {
    private final MinecraftServer server;
    private final BroadcasterConfig.BroadcastMessageDefinition messageDefinition;
    private final PlayerDataManager playerDataManager;
    private final ScheduledExecutorService scheduler;

    public BroadcastTask(MinecraftServer server, BroadcasterConfig.BroadcastMessageDefinition messageDefinition, PlayerDataManager playerDataManager, ScheduledExecutorService scheduler) {
        this.server = server;
        this.messageDefinition = messageDefinition;
        this.playerDataManager = playerDataManager;
        this.scheduler = scheduler;
    }

    @Override
    public void run() {
        String type;
        if (this.messageDefinition == null || this.messageDefinition.lines == null || this.messageDefinition.lines.isEmpty()) {
            return;
        }
        List<class_2561> formattedLines = MessageFormatter.formatLines(this.messageDefinition.lines, null, this.server, this.playerDataManager);
        if (formattedLines.isEmpty() && !this.messageDefinition.type.equalsIgnoreCase("BOSSBAR")) {
            return;
        }
        switch (type = this.messageDefinition.type.toUpperCase()) {
            case "CHAT": {
                if (formattedLines.isEmpty()) break;
                for (class_2561 line : formattedLines) {
                    for (class_3222 player : this.server.method_3760().method_14571()) {
                        player.method_7353(line, false);
                    }
                }
                break;
            }
            case "ACTION_BAR": {
                if (formattedLines.isEmpty()) break;
                class_5894 packet = new class_5894(formattedLines.get(0));
                for (class_3222 player : this.server.method_3760().method_14571()) {
                    player.field_13987.method_14364((class_2596)packet);
                }
                break;
            }
            case "TITLE": {
                if (formattedLines.isEmpty()) break;
                class_2561 title = formattedLines.get(0);
                class_5250 subtitle = formattedLines.size() > 1 ? formattedLines.get(1) : class_2561.method_43473();
                class_5905 timesPacket = new class_5905(10, 70, 20);
                class_5904 titlePacket = new class_5904(title);
                class_5903 subtitlePacket = new class_5903((class_2561)subtitle);
                for (class_3222 player : this.server.method_3760().method_14571()) {
                    player.field_13987.method_14364((class_2596)timesPacket);
                    player.field_13987.method_14364((class_2596)titlePacket);
                    if (formattedLines.size() <= 1 || subtitle.getString().isEmpty()) continue;
                    player.field_13987.method_14364((class_2596)subtitlePacket);
                }
                break;
            }
            case "BOSSBAR": {
                this.handleBossBarBroadcast(formattedLines);
                break;
            }
            default: {
                Broadcaster.LOGGER.warn("Unknown broadcast message type: " + type + ". Defaulting to CHAT.");
                if (formattedLines.isEmpty()) break;
                for (class_2561 line : formattedLines) {
                    for (class_3222 player : this.server.method_3760().method_14571()) {
                        player.method_7353(line, false);
                    }
                }
            }
        }
    }

    private void handleBossBarBroadcast(List<class_2561> formattedLines) {
        class_1259.class_1261 style;
        class_1259.class_1260 color;
        if (formattedLines.isEmpty()) {
            Broadcaster.LOGGER.warn("[BroadcastTask] No text available for BossBar title from formatted lines.");
            return;
        }
        class_2561 bossBarText = formattedLines.get(0);
        int duration = this.messageDefinition.durationSeconds > 0 ? this.messageDefinition.durationSeconds : 10;
        try {
            color = class_1259.class_1260.valueOf((String)this.messageDefinition.bossBarColor.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            color = class_1259.class_1260.field_5783;
            Broadcaster.LOGGER.warn("Invalid boss bar color: '{}'. Defaulting to PURPLE.", (Object)this.messageDefinition.bossBarColor);
        }
        try {
            style = class_1259.class_1261.valueOf((String)this.messageDefinition.bossBarOverlay.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            style = class_1259.class_1261.field_5795;
            Broadcaster.LOGGER.warn("Invalid boss bar overlay: '{}'. Defaulting to PROGRESS.", (Object)this.messageDefinition.bossBarOverlay);
        }
        class_2960 bossBarId = class_2960.method_60655((String)"chatmod", (String)("broadcast_" + UUID.randomUUID().toString().substring(0, 8)));
        class_3002 serverBossBar = this.server.method_3837().method_12970(bossBarId, bossBarText);
        if (serverBossBar == null) {
            Broadcaster.LOGGER.error("Failed to create or get boss bar with ID: {}", (Object)bossBarId);
            return;
        }
        serverBossBar.method_5416(color);
        serverBossBar.method_5409(style);
        serverBossBar.method_5408(1.0f);
        serverBossBar.method_14091(true);
        for (class_3222 player : this.server.method_3760().method_14571()) {
            serverBossBar.method_14088(player);
        }
        class_3002 finalServerBossBar = serverBossBar;
        if (this.scheduler != null && !this.scheduler.isShutdown()) {
            this.scheduler.schedule(() -> this.lambda$handleBossBarBroadcast$1((class_3213)finalServerBossBar), (long)duration, TimeUnit.SECONDS);
        } else {
            Broadcaster.LOGGER.warn("Boss bar scheduler not available. Boss bar players might not be cleared automatically after duration.");
        }
    }

    private /* synthetic */ void lambda$handleBossBarBroadcast$1(class_3213 finalServerBossBar) {
        this.server.execute(() -> {
            if (finalServerBossBar != null) {
                finalServerBossBar.method_14094();
            }
        });
    }
}

