/*
 * Decompiled with CFR 0.152.
 */
package me.andy.chatmod.config;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class InfoFileConfig {
    public boolean working = true;
    public List<String> aliases = new ArrayList<String>();
    public Map<String, List<String>> pages = new LinkedHashMap<String, List<String>>();
    public boolean permissionRequired = false;
    public String permissionNode = "";
    private static final String INTERNAL_COMMAND_BASE = "modinternal";

    public InfoFileConfig() {
        ArrayList<String> defaultPage1 = new ArrayList<String>();
        defaultPage1.add("&+&bNew Info File: %command%");
        defaultPage1.add("&7This is a newly created info file.");
        defaultPage1.add("&7Edit this file in '&econfig/chatmod_info/%config.json%&7'.");
        defaultPage1.add("&7You can use pages, formatting, and interactive elements:");
        defaultPage1.add("&eExample: &aClick Me{Hover over me!}<action:suggest_command,/say Hi %player%>");
        this.pages.put("page1", defaultPage1);
        ArrayList<String> defaultPage2 = new ArrayList<String>();
        defaultPage2.add("&+&bNew Info File: %command% - Page 2");
        defaultPage2.add("&7This is the second page.");
        defaultPage2.add("&7Use &e&= &7for newlines within a single string entry. Line1&=Line2");
        this.pages.put("page2", defaultPage2);
    }

    public InfoFileConfig(boolean isExampleFile) {
        if (isExampleFile) {
            this.working = true;
            this.permissionRequired = false;
            this.permissionNode = "chatmod.example";
            this.aliases.clear();
            this.aliases.add("/example");
            this.aliases.add("/ex");
            this.pages.clear();
            ArrayList<String> p1 = new ArrayList<String>();
            p1.add("&+&bExample - Page 1");
            p1.add("&+&bChatMod Info Example");
            p1.add("&7This is an example info file to demonstrate features.");
            p1.add("&7It is enabled by default. Disable with: &e/example work");
            p1.add("&7Click this message or do /example 2{}<action:run_command,/modinternal display example page2>");
            this.pages.put("page1", p1);
            ArrayList<String> p2 = new ArrayList<String>();
            p2.add("&+&bExample - Page 2 Chat formatting");
            p2.add("&aFeatures Demonstrated:");
            p2.add("&+&7- Centering with &e&+&7 prefix.");
            p2.add("&7- Newline: &eLine1&=Line2");
            p2.add("&7- Simple Hover: &eText{This is simple hover text! No click action.}");
            p2.add("&7Click this message or do /example 3{}<action:run_command,/modinternal display example page3>");
            this.pages.put("page2", p2);
            ArrayList<String> p3 = new ArrayList<String>();
            p3.add("&+&bExample - Page 3 Chat clickable actions");
            p3.add("&aNew Interactive Syntax the last &# before text defines the hoverable text &1ClickableText{HoverText} &7<ActionTag>:");
            p3.add("&aHere are 3 examples of actions:");
            p3.add("&7- &bOpen Link: &9FabricMC.org{Visit the FabricMC website!}<action:open_url,https://fabricmc.net>");
            p3.add("&7- &bRun Command: &aSay Hi{Click to say hi to yourself!}<action:run_command,/tellraw Hi %player% You clicked an example>");
            p3.add("&7- &bSuggest Command: &cSuggest /help{Click to suggest typing /help in chat.}<action:suggest_command,/help>");
            p3.add("          &a[Vote]{}<action:open_url,https://vote.com>           &5[Website Link]{Click to open website}<action:open_url,https://website.com>           &c[Rules] {}<action:run_command,/modinternal display help rules_section>");
            p3.add("&7Placeholders available:");
            p3.add("&e%player%&7, &e%player_uuid%&7, &e%player_ping%");
            p3.add("&7Click this message or do /example 4{}<action:run_command,/modinternal display example page4>");
            this.pages.put("page3", p3);
            ArrayList<String> p4 = new ArrayList<String>();
            p4.add("&+&bExample - Page 4 Colors");
            p4.add("&7- Formatting: &cColors&7, &lBold&7, &nUnderline&7, &oItalic&7, &kObf&7, &rReset");
            p4.add("&7- Hex Colors: &#00FF00Green &#FF0000Red");
            p4.add("&7Click this message or do /example{}<action:run_command,/modinternal display example page1>");
            this.pages.put("page4", p4);
        } else {
            this.working = true;
            ArrayList<String> defaultPage1 = new ArrayList<String>();
            defaultPage1.add("&+&bNew Info File: %command%");
            defaultPage1.add("&7This is a newly created info file.");
            defaultPage1.add("&7Edit this file in '&econfig/chatmod_info/%config.json%&7'.");
            this.pages.put("page1", defaultPage1);
        }
    }

    public static InfoFileConfig createDefaultHelpConfig() {
        InfoFileConfig helpConfig = new InfoFileConfig();
        helpConfig.working = true;
        helpConfig.permissionRequired = false;
        helpConfig.permissionNode = "chatmod.help";
        helpConfig.aliases.clear();
        helpConfig.aliases.add("/help");
        helpConfig.aliases.add("/h");
        helpConfig.pages.clear();
        ArrayList<String> mainSection = new ArrayList<String>();
        mainSection.add("&+&bServer Help Gateway");
        mainSection.add("&7Click a topic below for more information:");
        mainSection.add("&aRules{View the server rules}<action:run_command,/modinternal display help rules_section>");
        mainSection.add("&bCommands{Common player commands}<action:run_command,/modinternal display help commands_section>");
        mainSection.add("&cWebsite{Visit our community website}<action:open_url,https://example.com>");
        helpConfig.pages.put("main", mainSection);
        ArrayList<String> rulesSection = new ArrayList<String>();
        rulesSection.add("&+&6Server Rules");
        rulesSection.add("&e1. Be respectful to all players and staff.");
        rulesSection.add("&e2. No griefing or stealing.");
        rulesSection.add("&e3. No cheating, hacking, or exploiting bugs.");
        rulesSection.add("&e4. Follow directions from staff members.");
        rulesSection.add("&7For detailed rules, please see &a/rulesinfo&7 (if configured).");
        helpConfig.pages.put("rules_section", rulesSection);
        ArrayList<String> commandsSection = new ArrayList<String>();
        commandsSection.add("&+&6Common Commands");
        commandsSection.add("&a/spawn &7- Return to the server spawn.");
        commandsSection.add("&a/sethome &7- Set your personal home location.");
        commandsSection.add("&a/home &7- Teleport to your home.");
        commandsSection.add("&7More commands might be available!");
        helpConfig.pages.put("commands_section", commandsSection);
        return helpConfig;
    }

    public boolean isWorking() {
        return this.working;
    }

    public void setWorking(boolean working) {
        this.working = working;
    }

    public List<String> getAliases() {
        return this.aliases == null ? new ArrayList() : this.aliases;
    }

    public void setAliases(List<String> aliases) {
        this.aliases = aliases;
    }

    public Map<String, List<String>> getPages() {
        return this.pages == null ? new LinkedHashMap() : this.pages;
    }

    public boolean isPermissionRequired() {
        return this.permissionRequired;
    }

    public void setPermissionRequired(boolean permissionRequired) {
        this.permissionRequired = permissionRequired;
    }

    public String getPermissionNode() {
        return this.permissionNode == null ? "" : this.permissionNode;
    }

    public void setPermissionNode(String permissionNode) {
        this.permissionNode = permissionNode;
    }
}

