/*
 * Decompiled with CFR 0.152.
 */
package me.andy.chatmod.message;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.andy.chatmod.Broadcaster;
import me.andy.chatmod.command.BroadcasterCommand;
import me.andy.chatmod.config.PlaceholdersConfig;
import me.andy.chatmod.data.PlayerDataManager;
import me.andy.chatmod.manager.PlaceholdersManager;
import me.andy.chatmod.manager.PredefinedItemManager;
import me.andy.chatmod.message.PlaceholderResolver;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class MessageFormatter {
    private static final Pattern TOKENIZER_PATTERN = Pattern.compile("(?:&#([0-9a-fA-F]{6}))|(?:&([0-9a-fk-orA-FK-OR]))|(&=)|(\\{(.*?)\\})|(<action:(\\w+),([^>]*?)>)|(\\[item(?::(\\d+))?\\])|(\\[CHATMOD_INFO_DISPLAY:([a-zA-Z0-9_-]+):([a-zA-Z0-9_-]+)\\])|(\\[CHATMOD_TAG_PLAYERNAME:([\\w.-]+):((?:true|false))\\])|(\\[CHATMOD_TAG_EVERYONE:([&\u00a7#0-9a-fA-Fk-orA-FK-OR]{0,8}):((?:true|false))\\])|(\\[CHATMOD_CUSTOM:([a-zA-Z0-9_-]+)\\])|([^&{<\\[]+)");
    private static final int APPROX_CHAT_LINE_WIDTH_CHARS = 53;

    private static boolean isNullOrWhitespace(String s) {
        return s == null || s.trim().isEmpty();
    }

    private static boolean isLikelyUrlCandidate(String text) {
        if (MessageFormatter.isNullOrWhitespace(text)) {
            return false;
        }
        return text.matches("(?i)^(https?|ftp)://.*") || text.matches("(?i)^www\\..+\\..+") || text.contains(".") && !text.contains(" ") && text.matches("(?i)^[a-z0-9.-]+\\.(com|org|net|gov|edu|io|gl|gg|me|dev|app|xyz|co|uk|de|ca|us|info|biz|ly|tv|eu|asia|mobi|name|pro|tel|ws)(?:\\.[a-z]{2})?([/?#].*)?$");
    }

    private static String ensureUrlScheme(String url) {
        if (url == null) {
            return "";
        }
        String trimmedUrl = url.trim();
        if (trimmedUrl.matches("(?i)^(https?|ftp)://.*")) {
            return trimmedUrl;
        }
        return "http://" + trimmedUrl;
    }

    public static class_2561 formatMessage(String rawMessage, @Nullable class_3222 player, @Nullable MinecraftServer server, PlayerDataManager playerDataManager) {
        if (rawMessage == null) {
            return class_2561.method_43473();
        }
        class_5455.class_6890 registryLookup = server != null ? server.method_30611() : null;
        String lineToParse = PlaceholderResolver.resolve(rawMessage, player, server, playerDataManager);
        return MessageFormatter.parseSingleLine(lineToParse, player, server, playerDataManager, (class_7225.class_7874)registryLookup, false);
    }

    public static List<class_2561> formatLines(List<String> rawLines, @Nullable class_3222 player, @Nullable MinecraftServer server, PlayerDataManager playerDataManager) {
        ArrayList<class_2561> formattedTexts = new ArrayList<class_2561>();
        if (rawLines == null) {
            return formattedTexts;
        }
        class_5455.class_6890 registryLookup = server != null ? server.method_30611() : null;
        for (String rawLineLoop : rawLines) {
            if (rawLineLoop == null) {
                formattedTexts.add((class_2561)class_2561.method_43470((String)""));
                continue;
            }
            String lineToParse = PlaceholderResolver.resolve(rawLineLoop, player, server, playerDataManager);
            if (lineToParse.startsWith("&+")) {
                String contentLine = lineToParse.substring(2);
                class_5250 textComponent = MessageFormatter.parseSingleLine(contentLine, player, server, playerDataManager, (class_7225.class_7874)registryLookup, false);
                String textForWidthCalculation = MessageFormatter.stripFormattingForLength(textComponent.getString());
                int textWidth = textForWidthCalculation.length();
                int paddingNeeded = Math.max(0, (53 - textWidth) / 2);
                formattedTexts.add((class_2561)class_2561.method_43470((String)" ".repeat(paddingNeeded)).method_10852((class_2561)textComponent));
                continue;
            }
            formattedTexts.add((class_2561)MessageFormatter.parseSingleLine(lineToParse, player, server, playerDataManager, (class_7225.class_7874)registryLookup, false));
        }
        return formattedTexts;
    }

    private static class_5250 parseSingleLine(String rawLine, @Nullable class_3222 player, @Nullable MinecraftServer server, PlayerDataManager playerDataManager, @Nullable class_7225.class_7874 registryLookup, boolean isParsingForHoverTextContentItself) {
        class_5250 baseComponent = class_2561.method_43470((String)"");
        if (rawLine == null || rawLine.isEmpty()) {
            return baseComponent;
        }
        Matcher matcher = TOKENIZER_PATTERN.matcher(rawLine);
        class_2583 currentStyle = class_2583.field_24360;
        int lastEnd = 0;
        while (matcher.find()) {
            if (matcher.start() > lastEnd) {
                String plainText = rawLine.substring(lastEnd, matcher.start());
                baseComponent.method_10852((class_2561)class_2561.method_43470((String)plainText).method_10862(currentStyle));
            }
            String hexValG1 = matcher.group(1);
            String vanillaValG2 = matcher.group(2);
            String newlineOpG3 = matcher.group(3);
            String hoverBlockFullG4 = matcher.group(4);
            String hoverBlockContentG5 = matcher.group(5);
            String actionTagFullG6 = matcher.group(6);
            String actionTypeG7 = matcher.group(7);
            String actionValueG8 = matcher.group(8);
            String itemPlaceholderFullG9 = matcher.group(9);
            String itemSlotNumberStrG10 = matcher.group(10);
            String infoDisplayFullG11 = matcher.group(11);
            String infoDisplayFilenameG12 = matcher.group(12);
            String infoDisplaySectionnameG13 = matcher.group(13);
            String playerTagFullG14 = matcher.group(14);
            String playerTagActualNameG15 = matcher.group(15);
            String playerTagHasPermissionG16 = matcher.group(16);
            String everyoneTagFullG17 = matcher.group(17);
            String everyoneTagColorG18 = matcher.group(18);
            String everyoneTagHasPermissionG19 = matcher.group(19);
            String customPlaceholderG20 = matcher.group(20);
            String customKeyG21 = matcher.group(21);
            String plainTextTokenContentG22 = matcher.group(22);
            if (hexValG1 != null) {
                try {
                    currentStyle = currentStyle.method_27703((class_5251)class_5251.method_27719((String)("#" + hexValG1)).getOrThrow());
                }
                catch (Exception e) {
                    Broadcaster.LOGGER.warn("[ChatMod] Invalid hex color code: {}", (Object)hexValG1, (Object)e);
                }
            } else if (vanillaValG2 != null) {
                char c = vanillaValG2.toLowerCase().charAt(0);
                currentStyle = c == 'r' ? class_2583.field_24360 : MessageFormatter.applyMinecraftFormatting(currentStyle, class_124.method_544((char)c));
            } else if (newlineOpG3 != null) {
                baseComponent.method_10852((class_2561)class_2561.method_43470((String)"\n").method_10862(class_2583.field_24360));
            } else if (hoverBlockFullG4 != null) {
                if (isParsingForHoverTextContentItself) {
                    baseComponent.method_10852((class_2561)class_2561.method_43470((String)hoverBlockFullG4).method_10862(currentStyle));
                } else {
                    class_5250 parsedHoverContent = MessageFormatter.parseSingleLine(hoverBlockContentG5, player, server, playerDataManager, registryLookup, true);
                    if (!baseComponent.method_10855().isEmpty()) {
                        class_5250 lastSibling = (class_5250)baseComponent.method_10855().get(baseComponent.method_10855().size() - 1);
                        lastSibling.method_10862(lastSibling.method_10866().method_10949((class_2568)new class_2568.class_10613((class_2561)parsedHoverContent)));
                    } else {
                        baseComponent.method_10852((class_2561)class_2561.method_43470((String)hoverBlockFullG4).method_10862(currentStyle));
                    }
                }
            } else if (actionTagFullG6 != null) {
                if (isParsingForHoverTextContentItself) {
                    baseComponent.method_10852((class_2561)class_2561.method_43470((String)actionTagFullG6).method_10862(currentStyle));
                } else {
                    String resolvedActionValue = PlaceholderResolver.resolve(actionValueG8, player, server, playerDataManager);
                    class_2558 ce = MessageFormatter.createClickEvent(actionTypeG7, resolvedActionValue);
                    if (ce != null && !baseComponent.method_10855().isEmpty()) {
                        class_5250 lastSibling = (class_5250)baseComponent.method_10855().get(baseComponent.method_10855().size() - 1);
                        lastSibling.method_10862(lastSibling.method_10866().method_10958(ce));
                    } else {
                        baseComponent.method_10852((class_2561)class_2561.method_43470((String)actionTagFullG6).method_10862(currentStyle));
                    }
                }
            } else if (itemPlaceholderFullG9 != null) {
                if (isParsingForHoverTextContentItself) {
                    baseComponent.method_10852((class_2561)class_2561.method_43470((String)itemPlaceholderFullG9).method_10862(currentStyle));
                } else if (player != null && (itemPlaceholderFullG9.matches(".*\\[item\\s*\\](?!:).*") || itemPlaceholderFullG9.matches(".*\\[item\\s*:\\s*\\d+\\s*\\].*"))) {
                    boolean triedToUseHeld = itemPlaceholderFullG9.matches(".*\\[item\\s*\\](?!:).*");
                    boolean canUseHeldItem = BroadcasterCommand.checkPermission(player.method_64396(), "chatmod.chatitem");
                    boolean canUsePredefinedItem = BroadcasterCommand.checkPermission(player.method_64396(), "chatmod.chatitem.number");
                    if (triedToUseHeld && canUseHeldItem || !triedToUseHeld && canUsePredefinedItem) {
                        if (registryLookup == null) {
                            Broadcaster.LOGGER.warn("[ChatMod] Item placeholder error: RegistryLookup is null.");
                            baseComponent.method_10852((class_2561)class_2561.method_43470((String)itemPlaceholderFullG9).method_10862(currentStyle));
                        } else {
                            class_5250 itemComponent = MessageFormatter.processItemPlaceholder(itemPlaceholderFullG9, itemSlotNumberStrG10, player, registryLookup, server, playerDataManager);
                            baseComponent.method_10852((class_2561)itemComponent);
                        }
                    } else {
                        baseComponent.method_10852((class_2561)class_2561.method_43470((String)itemPlaceholderFullG9).method_10862(currentStyle));
                    }
                } else {
                    baseComponent.method_10852((class_2561)class_2561.method_43470((String)itemPlaceholderFullG9).method_10862(currentStyle));
                }
            } else if (infoDisplayFullG11 != null) {
                if (isParsingForHoverTextContentItself) {
                    baseComponent.method_10852((class_2561)class_2561.method_43470((String)infoDisplayFullG11).method_10862(currentStyle));
                } else {
                    String command = "/modinternal display " + infoDisplayFilenameG12 + " " + infoDisplaySectionnameG13;
                    class_5250 displayBtn = class_2561.method_43470((String)infoDisplayFullG11).method_10862(currentStyle.method_10958((class_2558)new class_2558.class_10609(command)));
                    baseComponent.method_10852((class_2561)displayBtn);
                }
            } else if (playerTagFullG14 != null) {
                boolean hasPermission = Boolean.parseBoolean(playerTagHasPermissionG16);
                if (hasPermission) {
                    class_5251 tagColor = currentStyle.method_10973();
                    if (tagColor == null) {
                        tagColor = class_5251.method_27718((class_124)class_124.field_1054);
                    }
                    class_2583 cleanStyle = class_2583.field_24360.method_27703(tagColor);
                    class_5250 atSymbol = class_2561.method_43470((String)"@").method_10862(cleanStyle);
                    class_5250 playerNameText = class_2561.method_43470((String)playerTagActualNameG15).method_10862(currentStyle);
                    playerNameText.method_10862(playerNameText.method_10866().method_27703(tagColor));
                    baseComponent.method_10852((class_2561)atSymbol).method_10852((class_2561)playerNameText);
                } else {
                    baseComponent.method_10852((class_2561)class_2561.method_43470((String)playerTagActualNameG15).method_10862(currentStyle));
                }
            } else if (everyoneTagFullG17 != null) {
                boolean hasPermission = Boolean.parseBoolean(everyoneTagHasPermissionG19);
                if (hasPermission) {
                    class_2583 fullTagStyle = currentStyle;
                    class_5251 tagColor = null;
                    String colorAndFormatStr = everyoneTagColorG18;
                    if (colorAndFormatStr != null && !colorAndFormatStr.isEmpty()) {
                        Pattern formatCodePattern = Pattern.compile("(&[0-9a-fk-orA-FK-OR]|&#[0-9a-fA-F]{6})");
                        Matcher formatMatcher = formatCodePattern.matcher(colorAndFormatStr);
                        while (formatMatcher.find()) {
                            String code = formatMatcher.group(1);
                            if (code.length() == 2) {
                                char formatChar = code.charAt(1);
                                class_124 mcFormat = class_124.method_544((char)formatChar);
                                if (mcFormat == null) continue;
                                if (mcFormat.method_543()) {
                                    tagColor = class_5251.method_27718((class_124)mcFormat);
                                    fullTagStyle = fullTagStyle.method_27703(tagColor);
                                    continue;
                                }
                                if (mcFormat.method_542()) {
                                    fullTagStyle = MessageFormatter.applyMinecraftFormatting(fullTagStyle, mcFormat);
                                    continue;
                                }
                                if (mcFormat != class_124.field_1070) continue;
                                fullTagStyle = class_2583.field_24360;
                                tagColor = null;
                                continue;
                            }
                            if (code.length() != 8 || !code.startsWith("&#")) continue;
                            try {
                                tagColor = (class_5251)class_5251.method_27719((String)code.substring(1)).getOrThrow();
                                fullTagStyle = fullTagStyle.method_27703(tagColor);
                            }
                            catch (Exception exception) {}
                        }
                    }
                    if (tagColor == null) {
                        tagColor = currentStyle.method_10973() != null ? currentStyle.method_10973() : class_5251.method_27718((class_124)class_124.field_1054);
                        fullTagStyle = fullTagStyle.method_27703(tagColor);
                    }
                    class_5250 atSymbol = class_2561.method_43470((String)"@").method_10862(class_2583.field_24360.method_27703(tagColor));
                    class_5250 everyoneText = class_2561.method_43470((String)"everyone").method_10862(fullTagStyle);
                    baseComponent.method_10852((class_2561)atSymbol).method_10852((class_2561)everyoneText);
                } else {
                    baseComponent.method_10852((class_2561)class_2561.method_43470((String)"everyone").method_10862(currentStyle));
                }
            } else if (customPlaceholderG20 != null) {
                if (isParsingForHoverTextContentItself) {
                    baseComponent.method_10852((class_2561)class_2561.method_43470((String)customPlaceholderG20).method_10862(currentStyle));
                } else {
                    class_5250 customComponent = MessageFormatter.processCustomPlaceholder(customKeyG21, player, server, playerDataManager, registryLookup);
                    baseComponent.method_10852((class_2561)customComponent);
                }
            } else if (plainTextTokenContentG22 != null) {
                baseComponent.method_10852((class_2561)class_2561.method_43470((String)plainTextTokenContentG22).method_10862(currentStyle));
            }
            lastEnd = matcher.end();
        }
        if (lastEnd < rawLine.length()) {
            String remaining = rawLine.substring(lastEnd);
            class_5250 segment = class_2561.method_43470((String)remaining).method_10862(currentStyle);
            if (MessageFormatter.isLikelyUrlCandidate(remaining.trim()) && !isParsingForHoverTextContentItself && segment.method_10866().method_10970() == null) {
                try {
                    segment.method_10862(segment.method_10866().method_10958((class_2558)new class_2558.class_10608(new URI(MessageFormatter.ensureUrlScheme(remaining.trim())))));
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            baseComponent.method_10852((class_2561)segment);
        }
        return baseComponent;
    }

    private static class_5250 processCustomPlaceholder(String key, @Nullable class_3222 player, @Nullable MinecraftServer server, PlayerDataManager playerDataManager, class_7225.class_7874 registryLookup) {
        class_2583 style;
        class_5250 component;
        PlaceholdersConfig.CustomPlaceholderDefinition def;
        block16: {
            PlaceholdersManager pm = Broadcaster.getPlaceholdersManager();
            if (pm == null) {
                return class_2561.method_43470((String)"");
            }
            def = pm.getConfig().custom_placeholders.get(key);
            if (def == null) {
                return class_2561.method_43470((String)"");
            }
            String resolvedChatText = PlaceholderResolver.resolve(def.chatmod, player, server, playerDataManager);
            component = MessageFormatter.parseSingleLine(resolvedChatText, player, server, playerDataManager, registryLookup, false);
            style = component.method_10866();
            if (def.item != null && !def.item.isEmpty() && def.item.startsWith("item:")) {
                try {
                    class_1799 stack;
                    int slot = Integer.parseInt(def.item.substring(5));
                    PredefinedItemManager itemManager = Broadcaster.getPredefinedItemManager();
                    if (itemManager == null || (stack = itemManager.getItemStack(slot, registryLookup)).method_7960()) break block16;
                    if (def.hover != null && !def.hover.isEmpty()) {
                        class_1799 copy = stack.method_7972();
                        class_5250 hoverName = MessageFormatter.parseSingleLine(def.hover, player, server, playerDataManager, registryLookup, true);
                        copy.method_57379(class_9334.field_49631, (Object)hoverName);
                        style = style.method_10949((class_2568)new class_2568.class_10612(copy));
                        break block16;
                    }
                    style = style.method_10949(stack.method_7954().method_10866().method_10969());
                }
                catch (Exception slot) {}
            } else if (def.hover != null && !def.hover.isEmpty()) {
                class_5250 hoverText = MessageFormatter.parseSingleLine(def.hover, player, server, playerDataManager, registryLookup, true);
                style = style.method_10949((class_2568)new class_2568.class_10613((class_2561)hoverText));
            }
        }
        if (def.runcommand != null && !def.runcommand.isEmpty()) {
            style = style.method_10958((class_2558)new class_2558.class_10609(def.runcommand));
        } else if (def.sugcommand != null && !def.sugcommand.isEmpty()) {
            style = style.method_10958((class_2558)new class_2558.class_10610(def.sugcommand));
        } else if (def.openurl != null && !def.openurl.isEmpty()) {
            try {
                style = style.method_10958((class_2558)new class_2558.class_10608(new URI(MessageFormatter.ensureUrlScheme(def.openurl))));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        component.method_10862(style);
        for (class_2561 sibling : component.method_10855()) {
            if (sibling.method_10866().method_10970() != null || sibling.method_10866().method_10969() != null) continue;
            ((class_5250)sibling).method_10862(sibling.method_10866().method_10958(style.method_10970()).method_10949(style.method_10969()));
        }
        return component;
    }

    private static class_5250 processItemPlaceholder(String fullPlaceholder, @Nullable String slotNumberStr, @Nullable class_3222 player, class_7225.class_7874 registryLookup, MinecraftServer server, PlayerDataManager playerDataManager) {
        String formatString;
        class_1799 stack = class_1799.field_8037;
        boolean isPredefined = false;
        if (slotNumberStr != null) {
            try {
                PredefinedItemManager itemManager;
                int slot = Integer.parseInt(slotNumberStr);
                if (slot >= 1 && slot <= 54 && (itemManager = Broadcaster.getPredefinedItemManager()) != null) {
                    stack = itemManager.getItemStack(slot, registryLookup);
                    isPredefined = true;
                }
            }
            catch (NumberFormatException slot) {}
        } else if (player != null) {
            stack = player.method_6047();
        }
        if (stack.method_7960()) {
            return class_2561.method_43470((String)fullPlaceholder);
        }
        class_5250 itemName = stack.method_7964().method_27661();
        if (!stack.method_57826(class_9334.field_49631)) {
            itemName.method_27692(stack.method_7932().method_58413());
        }
        itemName.method_10862(itemName.method_10866().method_10949(stack.method_7954().method_10866().method_10969()));
        PlaceholdersManager pm = Broadcaster.getPlaceholdersManager();
        String string = pm != null ? (isPredefined ? pm.getConfig().item_predefined_format : pm.getConfig().item_held_format) : (formatString = "&8[%item%&8]");
        if (formatString == null || !formatString.contains("%item%")) {
            return itemName;
        }
        String[] parts = formatString.split("%item%", -1);
        class_5250 result = class_2561.method_43473();
        if (parts.length > 0) {
            result.method_10852((class_2561)MessageFormatter.parseSingleLine(parts[0], player, server, playerDataManager, registryLookup, false));
        }
        result.method_10852((class_2561)itemName);
        if (parts.length > 1) {
            result.method_10852((class_2561)MessageFormatter.parseSingleLine(parts[1], player, server, playerDataManager, registryLookup, false));
        }
        return result;
    }

    private static class_2558 createClickEvent(String actionType, String value) {
        String lowerActionType;
        switch (lowerActionType = actionType.toLowerCase()) {
            case "run_command": {
                return new class_2558.class_10609(value);
            }
            case "suggest_command": {
                return new class_2558.class_10610(value);
            }
            case "open_url": {
                try {
                    return new class_2558.class_10608(new URI(MessageFormatter.ensureUrlScheme(value)));
                }
                catch (URISyntaxException e) {
                    return null;
                }
            }
            case "change_page": {
                try {
                    return new class_2558.class_10605(Integer.parseInt(value));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            case "copy_to_clipboard": {
                return new class_2558.class_10606(value);
            }
        }
        return null;
    }

    private static class_2583 applyMinecraftFormatting(class_2583 style, class_124 formatting) {
        if (formatting == null) {
            return style;
        }
        if (formatting.method_543()) {
            return style.method_10977(formatting);
        }
        if (formatting.method_542()) {
            return switch (formatting) {
                case class_124.field_1051 -> style.method_36141(Boolean.valueOf(true));
                case class_124.field_1067 -> style.method_10982(Boolean.valueOf(true));
                case class_124.field_1055 -> style.method_36140(Boolean.valueOf(true));
                case class_124.field_1073 -> style.method_30938(Boolean.valueOf(true));
                case class_124.field_1056 -> style.method_10978(Boolean.valueOf(true));
                default -> style;
            };
        }
        return style;
    }

    private static String stripFormattingForLength(String text) {
        if (text == null) {
            return "";
        }
        String temp = text.replaceAll("(?i)\\[CHATMOD_TAG_PLAYERNAME:[^\\]]+\\]", "PlayerName");
        temp = temp.replaceAll("(?i)\\[CHATMOD_TAG_EVERYONE:[^\\]]+\\]", "@everyone");
        temp = temp.replaceAll("(?i)\\[CHATMOD_INFO_DISPLAY:[^\\]]+\\]", "InfoText");
        temp = temp.replaceAll("(?i)\\[CHATMOD_CUSTOM:[^\\]]+\\]", "Custom");
        temp = temp.replaceAll("(?i)&[0-9a-fk-or]|&#[0-9a-fA-F]{6}|&= ?", "");
        temp = temp.replaceAll("\\{.*?\\}", "");
        temp = temp.replaceAll("<action:.*?>", "");
        temp = temp.replaceAll("\\[item(?:\\d+)?\\]", "[item]");
        return temp;
    }
}

