/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.pgen.pgen;

import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2388;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class ParticleInfo {
    private static final class_2396<?>[] BLOCK_PARTICLES = new class_2396[]{class_2398.field_11217, class_2398.field_35434, class_2398.field_11206, class_2398.field_50248, class_2398.field_54870};
    private static final class_2396<?>[] ITEM_PARTICLES = new class_2396[]{class_2398.field_11218};
    @Nullable
    private final class_2394 particle;
    private final class_243 motion;
    private final class_243 motionRand;
    private final class_243 posOffset;
    private final class_243 posRand;
    private final int interval;
    private final double probability;
    private final int particleCount;
    private final int particleMaxCount;
    private final boolean useRand;
    private final int signalMin;
    private final int signalMax;
    @Nullable
    private String additionalId = null;
    private int intervalCounter = 0;

    public ParticleInfo(class_11368 nbt) {
        this.particle = this.loadParticleType(nbt);
        this.motion = nbt.method_71426("Motion", class_243.field_38277).orElse(class_243.field_1353);
        this.motionRand = nbt.method_71426("MotionRand", class_243.field_38277).orElse(class_243.field_1353);
        this.posOffset = nbt.method_71426("PositionOffset", class_243.field_38277).orElse(class_243.field_1353);
        this.posRand = nbt.method_71426("PositionRand", class_243.field_38277).orElse(class_243.field_1353);
        this.interval = nbt.method_71424("Interval", 1);
        this.probability = nbt.method_71422("Probability", 1.0);
        this.particleCount = nbt.method_71424("ParticleCount", 1);
        this.particleMaxCount = nbt.method_71424("ParticleMaxCount", 1);
        this.signalMin = nbt.method_71424("SignalMin", Integer.MIN_VALUE);
        this.signalMax = nbt.method_71424("SignalMax", Integer.MAX_VALUE);
        this.useRand = !this.motionRand.equals((Object)class_243.field_1353) || !this.posRand.equals((Object)class_243.field_1353);
    }

    @Nullable
    public class_2394 loadParticleType(class_11368 nbt) {
        class_2396 particleType;
        String particleId = nbt.method_71441("id").orElse(null);
        if (particleId == null) {
            return null;
        }
        class_2960 id = class_2960.method_12829((String)particleId);
        if (id == null) {
            return null;
        }
        class_6880.class_6883 ref = class_7923.field_41180.method_10223(id).orElse(null);
        class_2396 class_23962 = particleType = ref != null ? (class_2396)ref.comp_349() : null;
        if (particleType == null) {
            return null;
        }
        if (particleType instanceof class_2394) {
            return (class_2394)particleType;
        }
        Pair<class_2394, String> pair = ParticleInfo.loadComplexParticle(particleType, nbt);
        if (pair == null) {
            return null;
        }
        this.additionalId = (String)pair.getSecond();
        return (class_2394)pair.getFirst();
    }

    @Nullable
    private static Pair<class_2394, String> loadComplexParticle(class_2396 particleType, class_11368 nbt) {
        class_2960 id;
        class_11368 additionalTags = nbt.method_71420("AdditionalTags").orElse(null);
        String idStr = additionalTags != null ? (String)additionalTags.method_71441("id").orElse(null) : null;
        class_2960 class_29602 = id = idStr != null ? class_2960.method_12829((String)idStr) : null;
        if (Arrays.asList(BLOCK_PARTICLES).contains(particleType)) {
            class_2248 block = null;
            if (id != null) {
                class_6880.class_6883 ref = class_7923.field_41175.method_10223(id).orElse(null);
                block = ref != null ? (class_2248)ref.comp_349() : null;
            }
            return block != null ? Pair.of((Object)new class_2388(particleType, block.method_9564()), (Object)idStr) : null;
        }
        if (Arrays.asList(ITEM_PARTICLES).contains(particleType)) {
            class_1792 item = null;
            if (id != null) {
                class_6880.class_6883 ref = class_7923.field_41178.method_10223(id).orElse(null);
                item = ref != null ? (class_1792)ref.comp_349() : null;
            }
            return item != null ? Pair.of((Object)new class_2392(particleType, new class_1799(item)), (Object)idStr) : null;
        }
        return null;
    }

    public class_11372 save(class_11372 nbt) {
        class_2960 particleId;
        if (this.particle != null && (particleId = class_7923.field_41180.method_10221((Object)this.particle.method_10295())) != null) {
            nbt.method_71469("id", particleId.toString());
        }
        nbt.method_71468("Motion", class_243.field_38277, (Object)this.motion);
        nbt.method_71468("MotionRand", class_243.field_38277, (Object)this.motionRand);
        nbt.method_71468("PositionOffset", class_243.field_38277, (Object)this.posOffset);
        nbt.method_71468("PositionRand", class_243.field_38277, (Object)this.posRand);
        nbt.method_71465("Interval", this.interval);
        nbt.method_71463("Probability", this.probability);
        nbt.method_71465("ParticleCount", this.particleCount);
        nbt.method_71465("ParticleMaxCount", this.particleMaxCount);
        nbt.method_71465("SignalMin", this.signalMin);
        nbt.method_71465("SignalMax", this.signalMax);
        if (this.additionalId != null) {
            nbt.method_71461("AdditionalTags").method_71469("id", this.additionalId);
        }
        return nbt;
    }

    public void renderParticle(class_1937 level, class_5819 random, double x, double y, double z, int redstoneSignal) {
        if (this.particle == null) {
            return;
        }
        if (redstoneSignal < this.signalMin || redstoneSignal > this.signalMax) {
            this.intervalCounter = 0;
            return;
        }
        if (this.intervalCounter == this.interval) {
            if (random.method_43058() <= this.probability) {
                int multiplier = this.particleCount >= this.particleMaxCount ? this.particleCount : this.particleCount + random.method_43048(this.particleMaxCount - this.particleCount + 1);
                for (int i = 0; i < multiplier; ++i) {
                    double posZ;
                    double posY;
                    double posX;
                    if (this.useRand) {
                        posX = x + this.posOffset.field_1352 + (random.method_43058() - 0.5) * this.posRand.field_1352;
                        posY = y + this.posOffset.field_1351 + (random.method_43058() - 0.5) * this.posRand.field_1351;
                        posZ = z + this.posOffset.field_1350 + (random.method_43058() - 0.5) * this.posRand.field_1350;
                        double motionX = this.motion.field_1352 + (random.method_43058() - 0.5) * this.motionRand.field_1352;
                        double motionY = this.motion.field_1351 + (random.method_43058() - 0.5) * this.motionRand.field_1351;
                        double motionZ = this.motion.field_1350 + (random.method_43058() - 0.5) * this.motionRand.field_1350;
                        level.method_8406(this.particle, posX, posY, posZ, motionX, motionY, motionZ);
                        continue;
                    }
                    posX = x + this.posOffset.field_1352;
                    posY = y + this.posOffset.field_1351;
                    posZ = z + this.posOffset.field_1350;
                    level.method_8406(this.particle, posX, posY, posZ, this.motion.field_1352, this.motion.field_1351, this.motion.field_1350);
                }
            }
            this.intervalCounter = 0;
        }
        ++this.intervalCounter;
    }
}

