package net.cookedseafood.pentamana.command;

import java.util.List;
import java.util.stream.IntStream;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import net.cookedseafood.pentamana.Pentamana;
import net.cookedseafood.pentamana.data.PentamanaConfig;
import net.cookedseafood.pentamana.render.ManaBar;
import net.cookedseafood.pentamana.render.ManaCharset;
import net.cookedseafood.pentamana.render.ManaPattern;
import net.cookedseafood.pentamana.render.ManaRender;
import net.minecraft.class_1259;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2178;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import org.apache.commons.lang3.mutable.MutableInt;

public class ManaBarCommand {
    private static final DynamicCommandExceptionType OPTION_VISIBILITY_UNCHANGED_EXCEPTION =
        new DynamicCommandExceptionType(isVisible -> class_2561.method_43470("Nothing changed. That player already has " + (boolean)isVisible + " for manabar visibility."));
    private static final DynamicCommandExceptionType OPTION_SUPPRESSION_UNCHANGED_EXCEPTION =
        new DynamicCommandExceptionType(isSuppressed -> class_2561.method_43470("Nothing changed. That player already has " + (boolean)isSuppressed + " for manabar suppression."));
    private static final DynamicCommandExceptionType OPTION_COMPRESSION_UNCHANGED_EXCEPTION =
        new DynamicCommandExceptionType(isCompressed -> class_2561.method_43470("Nothing changed. That player already has " + (boolean)isCompressed + " for manabar compression."));
    private static final DynamicCommandExceptionType OPTION_COMPRESSION_SIZE_UNCHANGED_EXCEPTION =
        new DynamicCommandExceptionType(compressionSize -> class_2561.method_43470("Nothing changed. That player already has " + (boolean)compressionSize + " for manabar compression size."));
    private static final DynamicCommandExceptionType OPTION_PATTERN_UNCHANGED_EXCEPTION =
        new DynamicCommandExceptionType(pattern -> class_2561.method_43470("Nothing changed. That player already has " + (String)pattern + " for manabar pattern."));
    private static final DynamicCommandExceptionType OPTION_TYPE_UNCHANGED_EXCEPTION =
        new DynamicCommandExceptionType(type -> class_2561.method_43470("Nothing changed. That player already has " + (String)type + " for manabar type."));
    private static final DynamicCommandExceptionType OPTION_POSITION_UNCHANGED_EXCEPTION =
        new DynamicCommandExceptionType(position -> class_2561.method_43470("Nothing changed. That player already has " + (String)position + " for manabar position."));
    private static final DynamicCommandExceptionType OPTION_COLOR_UNCHANGED_EXCEPTION =
        new DynamicCommandExceptionType(color -> class_2561.method_43470("Nothing changed. That player already has " + (String)color + " for manabar color."));
    private static final DynamicCommandExceptionType OPTION_STYLE_UNCHANGED_EXCEPTION =
        new DynamicCommandExceptionType(style -> class_2561.method_43470("Nothing changed. That player already has " + (String)style + " for manabar style."));
    private static final DynamicCommandExceptionType OPTION_POINTS_PER_CHARACTER_UNCHANGED_EXCEPTION =
        new DynamicCommandExceptionType(pointsPerCharacter -> class_2561.method_43470("Nothing changed. That player already has " + (int)pointsPerCharacter + " for mana points per character."));
    private static final Dynamic3CommandExceptionType OPTION_MANA_CHARACTER_UNCHANGED_EXCEPTION =
        new Dynamic3CommandExceptionType((manaCharacter, charTypeIndex, charIndex) -> class_2561.method_43470("Nothing changed. That player already has " + (String)manaCharacter + " for" + ((int)charIndex == -1 ? "" : (" #" + (int)charIndex)) + ((int)charTypeIndex == -1 ? "" : (" " + (int)charTypeIndex + " point")) + " mana character."));

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess) {
        dispatcher.register(
            class_2170.method_9247("manabar")
            .then(
                class_2170.method_9247("set")
                .then(
                    class_2170.method_9247("visibility")
                    .then(
                        class_2170.method_9247("false")
                        .executes(context -> executeSetVisibility(context.getSource(), false))
                    )
                    .then(
                        class_2170.method_9247("true")
                        .executes(context -> executeSetVisibility(context.getSource(), true))
                    )
                )
                .then(
                    class_2170.method_9247("suppression")
                    .then(
                        class_2170.method_9247("false")
                        .executes(context -> executeSetSuppression(context.getSource(), false))
                    )
                    .then(
                        class_2170.method_9247("true")
                        .executes(context -> executeSetSuppression(context.getSource(), true))
                    )
                )
                .then(
                    class_2170.method_9247("position")
                    .then(
                        class_2170.method_9247("actionbar")
                        .executes(context -> executeSetPosition(context.getSource(), ManaBar.Position.ACTIONBAR))
                    )
                    .then(
                        class_2170.method_9247("bossbar")
                        .executes(context -> executeSetPosition(context.getSource(), ManaBar.Position.BOSSBAR))
                    )
                    .then(
                        class_2170.method_9247("siderbar")
                        .executes(context -> executeSetPosition(context.getSource(), ManaBar.Position.SIDERBAR))
                    )
                )
                .then(
                    class_2170.method_9247("type")
                    .then(
                        class_2170.method_9247("character")
                        .executes(context -> executeSetType(context.getSource(), ManaRender.Type.CHARACTER))
                    )
                    .then(
                        class_2170.method_9247("numeric")
                        .executes(context -> executeSetType(context.getSource(), ManaRender.Type.NUMERIC))
                    )
                    .then(
                        class_2170.method_9247("percentage")
                        .executes(context -> executeSetType(context.getSource(), ManaRender.Type.PERCENTAGE))
                    )
                    .then(
                        class_2170.method_9247("none")
                        .executes(context -> executeSetType(context.getSource(), ManaRender.Type.NONE))
                    )
                )
                .then(
                    class_2170.method_9247("pattern")
                    .then(
                        class_2170.method_9244("text", class_2178.method_9281(registryAccess))
                        .executes(context -> executeSetPattern(context.getSource(), class_2178.method_67414(context, "text")))
                    )
                )
                .then(
                    class_2170.method_9247("points_per_character")
                    .then(
                        class_2170.method_9244("value", IntegerArgumentType.integer(1))
                        .executes(context -> executeSetPointsPerCharacter(context.getSource(), IntegerArgumentType.getInteger(context, "value")))
                    )
                )
                .then(
                    class_2170.method_9247("compression")
                    .then(
                        class_2170.method_9247("false")
                        .executes(context -> executeSetCompression(context.getSource(), false))
                    )
                    .then(
                        class_2170.method_9247("true")
                        .executes(context -> executeSetCompression(context.getSource(), true))
                    )
                )
                .then(
                    class_2170.method_9247("compression_size")
                    .then(
                        class_2170.method_9244("size", IntegerArgumentType.integer(1, Pentamana.MANA_CHARACTER_INDEX_LIMIT + 1))
                        .executes(context -> executeSetCompressionSize(context.getSource(), (byte)IntegerArgumentType.getInteger(context, "size")))
                    )
                )
                .then(
                    class_2170.method_9247("character")
                    .then(
                        class_2170.method_9244("text", class_2178.method_9281(registryAccess))
                        .executes(context -> executeSetCharacter(context.getSource(), class_2178.method_67414(context, "text")))
                        .then(
                            class_2170.method_9244("character_type_index", IntegerArgumentType.integer(0, Pentamana.MANA_CHARACTER_TYPE_INDEX_LIMIT))
                            .executes(context -> executeSetCharacter(context.getSource(), class_2178.method_67414(context, "text"), IntegerArgumentType.getInteger(context, "type_index")))
                            .then(
                                class_2170.method_9244("character_index", IntegerArgumentType.integer(0, Pentamana.MANA_CHARACTER_INDEX_LIMIT))
                                .executes(context -> executeSetCharacter(context.getSource(), class_2178.method_67414(context, "text"), IntegerArgumentType.getInteger(context, "type_index"), IntegerArgumentType.getInteger(context, "character_index")))
                            )
                        )
                    )
                )
                .then(
                    class_2170.method_9247("color")
                    .then(
                        class_2170.method_9247("pink")
                        .executes(context -> executeSetColor(context.getSource(), class_1259.class_1260.field_5788))
                    )
                    .then(
                        class_2170.method_9247("blue")
                        .executes(context -> executeSetColor(context.getSource(), class_1259.class_1260.field_5780))
                    )
                    .then(
                        class_2170.method_9247("red")
                        .executes(context -> executeSetColor(context.getSource(), class_1259.class_1260.field_5784))
                    )
                    .then(
                        class_2170.method_9247("green")
                        .executes(context -> executeSetColor(context.getSource(), class_1259.class_1260.field_5785))
                    )
                    .then(
                        class_2170.method_9247("yellow")
                        .executes(context -> executeSetColor(context.getSource(), class_1259.class_1260.field_5782))
                    )
                    .then(
                        class_2170.method_9247("purple")
                        .executes(context -> executeSetColor(context.getSource(), class_1259.class_1260.field_5783))
                    )
                    .then(
                        class_2170.method_9247("white")
                        .executes(context -> executeSetColor(context.getSource(), class_1259.class_1260.field_5786))
                    )
                )
                .then(
                    class_2170.method_9247("style")
                    .then(
                        class_2170.method_9247("progress")
                        .executes(context -> executeSetStyle(context.getSource(), class_1259.class_1261.field_5795))
                    )
                    .then(
                        class_2170.method_9247("notched_6")
                        .executes(context -> executeSetStyle(context.getSource(), class_1259.class_1261.field_5796))
                    )
                    .then(
                        class_2170.method_9247("notched_10")
                        .executes(context -> executeSetStyle(context.getSource(), class_1259.class_1261.field_5791))
                    )
                    .then(
                        class_2170.method_9247("notched_12")
                        .executes(context -> executeSetStyle(context.getSource(), class_1259.class_1261.field_5793))
                    )
                    .then(
                        class_2170.method_9247("notched_20")
                        .executes(context -> executeSetStyle(context.getSource(), class_1259.class_1261.field_5790))
                    )
                )
            )
            .then(
                class_2170.method_9247("reset")
                .executes(context -> executeReset(context.getSource()))
                .then(
                    class_2170.method_9247("visibility")
                    .executes(context -> executeResetVisibility(context.getSource()))
                )
                .then(
                    class_2170.method_9247("suppression")
                    .executes(context -> executeResetSuppression(context.getSource()))
                )
                .then(
                    class_2170.method_9247("position")
                    .executes(context -> executeResetPosition(context.getSource()))
                )
                .then(
                    class_2170.method_9247("type")
                    .executes(context -> executeResetType(context.getSource()))
                )
                .then(
                    class_2170.method_9247("pattern")
                    .executes(context -> executeResetPattern(context.getSource()))
                )
                .then(
                    class_2170.method_9247("points_per_character")
                    .executes(context -> executeResetPointsPerCharacter(context.getSource()))
                )
                .then(
                    class_2170.method_9247("compression")
                    .executes(context -> executeResetCompression(context.getSource()))
                )
                .then(
                    class_2170.method_9247("compression_size")
                    .executes(context -> executeResetCompressionSize(context.getSource()))
                )
                .then(
                    class_2170.method_9247("character")
                    .executes(context -> executeResetCharacter(context.getSource()))
                )
                .then(
                    class_2170.method_9247("color")
                    .executes(context -> executeResetColor(context.getSource()))
                )
                .then(
                    class_2170.method_9247("style")
                    .executes(context -> executeResetStyle(context.getSource()))
                )
            )
        );
    }

    public static int executeSetVisibility(class_2168 source, boolean isVisible) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        if (player.isManaBarVisible() == isVisible) {
            throw OPTION_VISIBILITY_UNCHANGED_EXCEPTION.create(isVisible);
        }

        player.setManaBarVisibility(isVisible);

        if (!player.isManaBarSuppressed()) {
            if (isVisible) {
                player.putManaBarDisplay();
            } else {
                player.removeManaBarDisplay();
            }
        }

        source.method_9226(() -> class_2561.method_43470("Updated manabar visibility for player ").method_10852(player.method_5476()).method_27693(" to " + isVisible + "."), false);
        return 1;
    }

    public static int executeSetSuppression(class_2168 source, boolean isSuppressed) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        if (player.isManaBarSuppressed() == isSuppressed) {
            throw OPTION_SUPPRESSION_UNCHANGED_EXCEPTION.create(isSuppressed);
        }

        player.setManaBarSuppression(isSuppressed);

        if (player.isManaBarVisible()) {
            if (isSuppressed) {
                player.removeManaBarDisplay();
            } else {
                player.putManaBarDisplay();
            }
        }

        source.method_9226(() -> class_2561.method_43470("Updated manabar suppression for player ").method_10852(player.method_5476()).method_27693(" to " + isSuppressed + "."), false);
        return 1;
    }

    public static int executeSetPosition(class_2168 source, ManaBar.Position position) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        if (player.getManaBarPosition() == position) {
            throw OPTION_POSITION_UNCHANGED_EXCEPTION.create(position.getName());
        }

        if (player.isManaBarVisible() && !player.isManaBarSuppressed()) {
            player.removeManaBarDisplay();
            player.putManaBarDisplay(position);
        }

        player.setManaBarPosition(position);

        source.method_9226(() -> class_2561.method_43470("Updated manabar position for player ").method_10852(player.method_5476()).method_27693(" to " + position.getName() + "."), false);
        return 1;
    }

    public static int executeSetType(class_2168 source, ManaRender.Type type) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        if (player.getManaRenderType() == type) {
            throw OPTION_TYPE_UNCHANGED_EXCEPTION.create(type.getName());
        }

        player.setManaRenderType(type);

        if (player.isManaBarVisible() && !player.isManaBarSuppressed()) {
            player.putManaBarDisplay();
        }

        source.method_9226(() -> class_2561.method_43470("Updated manabar type for player ").method_10852(player.method_5476()).method_27693(" to " + type.getName() + "."), false);
        return 1;
    }

    public static int executeSetPattern(class_2168 source, class_2561 wrappedPattern) throws CommandSyntaxException {
        return executeSetPattern(source, wrappedPattern.method_10855());
    }

    public static int executeSetPattern(class_2168 source, List<class_2561> pattern) throws CommandSyntaxException {
        return executeSetPattern(source, new ManaPattern(pattern));
    }

    public static int executeSetPattern(class_2168 source, ManaPattern pattern) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        if (player.getManaPattern().equals(pattern)) {
            throw OPTION_PATTERN_UNCHANGED_EXCEPTION.create(pattern.toText().getString());
        }

        player.setManaPattern(pattern);

        if (player.isManaBarVisible() && !player.isManaBarSuppressed()) {
            player.putManaBarDisplay();
        }

        source.method_9226(() -> class_2561.method_43470("Updated manabar pattern for player").method_10852(player.method_5476()).method_27693(" to " + pattern.toText().getString() + "."), false);
        return 1;
    }

    public static int executeSetPointsPerCharacter(class_2168 source, int pointsPerCharacter) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        if (player.getManaPointsPerCharacter() == pointsPerCharacter) {
            throw OPTION_POINTS_PER_CHARACTER_UNCHANGED_EXCEPTION.create(pointsPerCharacter);
        }

        player.setManaPointsPerCharacter(pointsPerCharacter);

        if (player.isManaBarVisible() && !player.isManaBarSuppressed()) {
            player.putManaBarDisplay();
        }

        source.method_9226(() -> class_2561.method_43470("Updated mana points per character for player ").method_10852(player.method_5476()).method_27693(" to " + pointsPerCharacter + "."), false);
        return 1;
    }

    public static int executeSetCompression(class_2168 source, boolean isCompressed) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        if (player.isManaRenderCompressed() == isCompressed) {
            throw OPTION_COMPRESSION_UNCHANGED_EXCEPTION.create(isCompressed);
        }

        player.setManaRenderCompression(isCompressed);

        if (player.isManaBarVisible() && !player.isManaBarSuppressed()) {
            player.putManaBarDisplay();
        }

        source.method_9226(() -> class_2561.method_43470("Updated manabar compression for player ").method_10852(player.method_5476()).method_27693(" to " + isCompressed + "."), false);
        return 1;
    }

    public static int executeSetCompressionSize(class_2168 source, byte compressionSize) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        if (player.getManaRenderCompressionSize() == compressionSize) {
            throw OPTION_COMPRESSION_SIZE_UNCHANGED_EXCEPTION.create(compressionSize);
        }

        player.setManaRenderCompressionSize(compressionSize);

        if (player.isManaBarVisible() && !player.isManaBarSuppressed()) {
            player.putManaBarDisplay();
        }

        source.method_9226(() -> class_2561.method_43470("Updated manabar compression size for player ").method_10852(player.method_5476()).method_27693(" to " + compressionSize + "."), false);
        return 1;
    }

    public static int executeSetCharacter(class_2168 source, class_2561 targetChar) throws CommandSyntaxException {
        return executeSetCharacter(source, targetChar, -1);
    }

    public static int executeSetCharacter(class_2168 source, class_2561 targetChar, int charTypeIndex) throws CommandSyntaxException {
        return executeSetCharacter(source, targetChar, charTypeIndex, -1);
    }

    public static int executeSetCharacter(class_2168 source, class_2561 targetChar, int charTypeIndex, int charIndex) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        ManaCharset manaCharset = player.getManaCharset();

        int startCharTypeIndex = charTypeIndex == -1 ? 0 : charTypeIndex;
        int endCharTypeIndex = charTypeIndex == -1 ? Pentamana.MANA_CHARACTER_TYPE_INDEX_LIMIT : charTypeIndex;
        int startCharIndex = charIndex == -1 ? 0 : charIndex;
        int endCharIndex = charIndex == -1 ? Pentamana.MANA_CHARACTER_INDEX_LIMIT : charIndex;

        MutableInt miss = new MutableInt(0);
        IntStream.rangeClosed(startCharTypeIndex, endCharTypeIndex)
            .forEach(cti -> IntStream.rangeClosed(startCharIndex, endCharIndex)
                .forEach(ci -> {
                    if (!manaCharset.get(cti).get(ci).equals(targetChar)) {
                        miss.increment();
                        manaCharset.get(cti).set(ci, targetChar);
                    }
                })
            );

        if (miss.intValue() == 0) {
            throw OPTION_MANA_CHARACTER_UNCHANGED_EXCEPTION.create(targetChar, charTypeIndex, charIndex);
        }

        player.setManaCharset(manaCharset);

        if (player.isManaBarVisible() && !player.isManaBarSuppressed()) {
            player.putManaBarDisplay();
        }

        source.method_9226(() -> class_2561.method_43470("Updated " + (charIndex == -1 ? "" : (" #" + charIndex)) + (charTypeIndex == -1 ? "" : (" " + charTypeIndex + " point")) + " mana character for player ").method_10852(player.method_5476()).method_27693(" to " + targetChar.getString() + "."), false);
        return 1;
    }

    public static int executeSetColor(class_2168 source, class_1259.class_1260 color) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        if (player.getManaBarColor() == color) {
            throw OPTION_COLOR_UNCHANGED_EXCEPTION.create(color.method_5421());
        }

        player.setManaBarColor(color);

        if (player.isManaBarVisible() && !player.isManaBarSuppressed()) {
            player.putManaBarDisplay();
        }

        source.method_9226(() -> class_2561.method_43470("Updated manabar color for player ").method_10852(player.method_5476()).method_27693(" to " + color.method_5421() + "."), false);
        return 1;
    }

    public static int executeSetStyle(class_2168 source, class_1259.class_1261 style) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        if (player.getManaBarStyle() == style) {
            throw OPTION_STYLE_UNCHANGED_EXCEPTION.create(style.method_5425());
        }

        player.setManaBarStyle(style);

        if (player.isManaBarVisible() && !player.isManaBarSuppressed()) {
            player.putManaBarDisplay();
        }

        source.method_9226(() -> class_2561.method_43470("Updated manabar style for player ").method_10852(player.method_5476()).method_27693(" to " + style.method_5425() + "."), false);
        return 1;
    }

    public static int executeReset(class_2168 source) throws CommandSyntaxException {
        class_3222 player = source.method_9207();

        if (player.isManaBarVisible() != PentamanaConfig.DefaultPreference.isVisible) {
            player.setManaBarVisibility(PentamanaConfig.DefaultPreference.isVisible);

            if (!player.isManaBarSuppressed()) {
                if (PentamanaConfig.DefaultPreference.isVisible) {
                    player.putManaBarDisplay();
                } else {
                    player.removeManaBarDisplay();
                }
            }
        }

        if (player.isManaBarSuppressed() != PentamanaConfig.DefaultPreference.isSuppressed) {
            player.setManaBarSuppression(PentamanaConfig.DefaultPreference.isSuppressed);

            if (player.isManaBarVisible()) {
                if (PentamanaConfig.DefaultPreference.isSuppressed) {
                    player.removeManaBarDisplay();
                } else {
                    player.putManaBarDisplay();
                }
            }
        }

        if (player.getManaBarPosition() != PentamanaConfig.DefaultPreference.position) {
            if (player.isManaBarVisible() && !player.isManaBarSuppressed()) {
                player.removeManaBarDisplay();
                player.putManaBarDisplay(PentamanaConfig.DefaultPreference.position);
            }

            executeSetPosition(source, PentamanaConfig.DefaultPreference.position);
        }

        boolean different = false;

        if (player.getManaRenderType() != PentamanaConfig.DefaultPreference.type) {
            player.setManaRenderType(PentamanaConfig.DefaultPreference.type);
            different = true;
        }

        if (!player.getManaPattern().equals(PentamanaConfig.DefaultPreference.pattern)) {
            player.setManaPattern(PentamanaConfig.DefaultPreference.pattern.deepCopy());
            different = true;
        }

        if (player.getManaPointsPerCharacter() != PentamanaConfig.DefaultPreference.pointsPerCharacter) {
            player.setManaPointsPerCharacter(PentamanaConfig.DefaultPreference.pointsPerCharacter);
            different = true;
        }

        if (player.isManaRenderCompressed() != PentamanaConfig.DefaultPreference.isCompressed) {
            player.setManaRenderCompression(PentamanaConfig.DefaultPreference.isCompressed);
            different = true;
        }

        if (player.getManaRenderCompressionSize() != PentamanaConfig.DefaultPreference.compressionSize) {
            player.setManaRenderCompressionSize(PentamanaConfig.DefaultPreference.compressionSize);
            different = true;
        }

        if (!player.getManaCharset().equals(PentamanaConfig.DefaultPreference.charset)) {
            player.setManaCharset(PentamanaConfig.DefaultPreference.charset.deepCopy());
            different = true;
        }

        if (player.getManaBarColor() != PentamanaConfig.DefaultPreference.color) {
            player.setManaBarColor(PentamanaConfig.DefaultPreference.color);
            different = true;
        }

        if (player.getManaBarStyle() != PentamanaConfig.DefaultPreference.style) {
            player.setManaBarStyle(PentamanaConfig.DefaultPreference.style);
            different = true;
        }

        if (different && player.isManaBarVisible() && !player.isManaBarSuppressed()) {
            player.putManaBarDisplay();
        }

        source.method_9226(() -> class_2561.method_43470("Reset manabar options for player ").method_10852(player.method_5476()).method_27693("."), false);
        return 0;
    }

    public static int executeResetVisibility(class_2168 source) throws CommandSyntaxException {
        class_3222 player = source.method_9207();

        if (player.isManaBarVisible() != PentamanaConfig.DefaultPreference.isVisible) {
            player.setManaBarVisibility(PentamanaConfig.DefaultPreference.isVisible);

            if (!player.isManaBarSuppressed()) {
                if (PentamanaConfig.DefaultPreference.isVisible) {
                    player.putManaBarDisplay();
                } else {
                    player.removeManaBarDisplay();
                }
            }
        }

        source.method_9226(() -> class_2561.method_43470("Reset manabar visibility for player ").method_10852(player.method_5476()).method_27693("."), false);
        return 0;
    }

    public static int executeResetSuppression(class_2168 source) throws CommandSyntaxException {
        class_3222 player = source.method_9207();

        if (player.isManaBarSuppressed() != PentamanaConfig.DefaultPreference.isSuppressed) {
            player.setManaBarSuppression(PentamanaConfig.DefaultPreference.isSuppressed);

            if (player.isManaBarVisible()) {
                if (PentamanaConfig.DefaultPreference.isSuppressed) {
                    player.removeManaBarDisplay();
                } else {
                    player.putManaBarDisplay();
                }
            }
        }

        source.method_9226(() -> class_2561.method_43470("Reset manabar suppression for player ").method_10852(player.method_5476()).method_27693("."), false);
        return 1;
    }

    public static int executeResetPosition(class_2168 source) throws CommandSyntaxException {
        class_3222 player = source.method_9207();

        if (player.getManaBarPosition() != PentamanaConfig.DefaultPreference.position) {
            if (player.isManaBarVisible() && !player.isManaBarSuppressed()) {
                player.removeManaBarDisplay();
                player.putManaBarDisplay(PentamanaConfig.DefaultPreference.position);
            }

            executeSetPosition(source, PentamanaConfig.DefaultPreference.position);
        }

        source.method_9226(() -> class_2561.method_43470("Reset manabar position for player ").method_10852(player.method_5476()).method_27693("."), false);
        return 0;
    }

    public static int executeResetType(class_2168 source) throws CommandSyntaxException {
        class_3222 player = source.method_9207();

        if (player.getManaRenderType() != PentamanaConfig.DefaultPreference.type) {
            player.setManaRenderType(PentamanaConfig.DefaultPreference.type);

            if (player.isManaBarVisible() && !player.isManaBarSuppressed()) {
                player.putManaBarDisplay();
            }
        }

        source.method_9226(() -> class_2561.method_43470("Reset manabar type for player ").method_10852(player.method_5476()).method_27693("."), false);
        return 0;
    }

    public static int executeResetPattern(class_2168 source) throws CommandSyntaxException {
        class_3222 player = source.method_9207();

        if (!player.getManaPattern().equals(PentamanaConfig.DefaultPreference.pattern)) {
            player.setManaPattern(PentamanaConfig.DefaultPreference.pattern.deepCopy());

            if (player.isManaBarVisible() && !player.isManaBarSuppressed()) {
                player.putManaBarDisplay();
            }
        }

        source.method_9226(() -> class_2561.method_43470("Reset manabar pattern for player ").method_10852(player.method_5476()).method_27693("."), false);
        return 0;
    }

    public static int executeResetPointsPerCharacter(class_2168 source) throws CommandSyntaxException {
        class_3222 player = source.method_9207();

        if (player.getManaPointsPerCharacter() != PentamanaConfig.DefaultPreference.pointsPerCharacter) {
            player.setManaPointsPerCharacter(PentamanaConfig.DefaultPreference.pointsPerCharacter);

            if (player.isManaBarVisible() && !player.isManaBarSuppressed()) {
                player.putManaBarDisplay();
            }
        }

        source.method_9226(() -> class_2561.method_43470("Reset points per character for player ").method_10852(player.method_5476()).method_27693("."), false);
        return 0;
    }

    public static int executeResetCompression(class_2168 source) throws CommandSyntaxException {
        class_3222 player = source.method_9207();

        if (player.isManaRenderCompressed() != PentamanaConfig.DefaultPreference.isCompressed) {
            player.setManaRenderCompression(PentamanaConfig.DefaultPreference.isCompressed);

            if (player.isManaBarVisible() && !player.isManaBarSuppressed()) {
                player.putManaBarDisplay();
            }
        }

        source.method_9226(() -> class_2561.method_43470("Reset manabar compression for player ").method_10852(player.method_5476()).method_27693("."), false);
        return 0;
    }

    public static int executeResetCompressionSize(class_2168 source) throws CommandSyntaxException {
        class_3222 player = source.method_9207();

        if (player.getManaRenderCompressionSize() != PentamanaConfig.DefaultPreference.compressionSize) {
            player.setManaRenderCompressionSize(PentamanaConfig.DefaultPreference.compressionSize);

            if (player.isManaBarVisible() && !player.isManaBarSuppressed()) {
                player.putManaBarDisplay();
            }
        }

        source.method_9226(() -> class_2561.method_43470("Reset manabar compression size for player ").method_10852(player.method_5476()).method_27693("."), false);
        return 0;
    }

    public static int executeResetCharacter(class_2168 source) throws CommandSyntaxException {
        class_3222 player = source.method_9207();

        if (!player.getManaCharset().equals(PentamanaConfig.DefaultPreference.charset)) {
            player.setManaCharset(PentamanaConfig.DefaultPreference.charset.deepCopy());

            if (player.isManaBarVisible() && !player.isManaBarSuppressed()) {
                player.putManaBarDisplay();
            }
        }

        source.method_9226(() -> class_2561.method_43470("Reset mana character for player ").method_10852(player.method_5476()).method_27693("."), false);
        return 0;
    }

    public static int executeResetColor(class_2168 source) throws CommandSyntaxException {
        class_3222 player = source.method_9207();

        if (player.getManaBarColor() != PentamanaConfig.DefaultPreference.color) {
            player.setManaBarColor(PentamanaConfig.DefaultPreference.color);

            if (player.isManaBarVisible() && !player.isManaBarSuppressed()) {
                player.putManaBarDisplay();
            }
        }

        source.method_9226(() -> class_2561.method_43470("Reset manabar color for player ").method_10852(player.method_5476()).method_27693("."), false);
        return 0;
    }

    public static int executeResetStyle(class_2168 source) throws CommandSyntaxException {
        class_3222 player = source.method_9207();

        if (player.getManaBarStyle() != PentamanaConfig.DefaultPreference.style) {
            player.setManaBarStyle(PentamanaConfig.DefaultPreference.style);

            if (player.isManaBarVisible() && !player.isManaBarSuppressed()) {
                player.putManaBarDisplay();
            }
        }

        source.method_9226(() -> class_2561.method_43470("Reset manabar style for player ").method_10852(player.method_5476()).method_27693("."), false);
        return 0;
    }
}
