package net.cookedseafood.pentamana.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.cookedseafood.pentamana.Pentamana;
import net.cookedseafood.pentamana.data.PentamanaConfig;
import net.cookedseafood.pentamana.data.PentamanaPreference;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import net.minecraft.class_8828;

public class PentamanaCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess) {
        dispatcher.register(
            class_2170.method_9247(Pentamana.MOD_ID)
            .then(
                class_2170.method_9247("debug")
                .then(
                    class_2170.method_9247("preference")
                    .executes(context -> executeDebugPreference(context.getSource()))
                    .then(
                        class_2170.method_9244("player", class_2186.method_9305())
                        .executes(context -> executeDebugPreference(context.getSource(), class_2186.method_9315(context, "player")))
                    )
                )
            )
            .then(
                class_2170.method_9247("version")
                .executes(context -> executeVersion(context.getSource()))
            )
            .then(
                class_2170.method_9247("reload")
                .requires(source -> source.method_9259(2))
                .executes(context -> executeReload(context.getSource()))
            )
        );
    }

    public static int executeDebugPreference(class_2168 source) throws CommandSyntaxException {
        return executeDebugPreference(source, source.method_9207());
    }

    public static int executeDebugPreference(class_2168 source, class_3222 player) throws CommandSyntaxException {
        return executeDebugPreference(source, player, player.getPentamanaPreference());
    }

    public static int executeDebugPreference(class_2168 source, class_3222 player, PentamanaPreference preference) throws CommandSyntaxException {
        class_5250 feedback = class_5250.method_43477(class_8828.field_46625);
        feedback.method_10852(class_2561.method_43470("\n" + player.getMana() + "/" + player.getManaCapacity()).method_27692(class_124.field_1075));
        feedback.method_10852(class_2561.method_43470("\n- visibility "));
        feedback.method_10852(preference.isVisible ? class_2561.method_43470("true").method_27692(class_124.field_1060) : class_2561.method_43470("false").method_27692(class_124.field_1061));
        feedback.method_10852(class_2561.method_43470("\n- suppression "));
        feedback.method_10852(preference.isSuppressed ? class_2561.method_43470("true").method_27692(class_124.field_1060) : class_2561.method_43470("false").method_27692(class_124.field_1061));
        feedback.method_10852(class_2561.method_43470("\n- position "));
        feedback.method_10852(class_2561.method_43470(preference.position.getName()).method_27692(class_124.field_1054));
        feedback.method_10852(class_2561.method_43470("\n- pattern "));
        feedback.method_10852(class_2561.method_43470(preference.pattern.toText().toString()).method_27692(class_124.field_1054));
        feedback.method_10852(class_2561.method_43470("\n- renderType "));
        feedback.method_10852(class_2561.method_43470(preference.type.getName()).method_27692(class_124.field_1054));
        feedback.method_10852(class_2561.method_43470("\n- charset "));
        for (int i = 0; i < 10; i++) {
            feedback.method_10852(preference.charset.get(i).get(i));
        };
        feedback.method_10852(class_2561.method_43470("\n- pointsPerCharacter "));
        feedback.method_10852(class_2561.method_43470("" + preference.pointsPerCharacter).method_27692(class_124.field_1060));
        feedback.method_10852(class_2561.method_43470("\n- compression "));
        feedback.method_10852(preference.isCompressed ? class_2561.method_43470("true").method_27692(class_124.field_1060) : class_2561.method_43470("false").method_27692(class_124.field_1061));
        feedback.method_10852(class_2561.method_43470("\n- compressionSize "));
        feedback.method_10852(class_2561.method_43470("" + preference.compressionSize).method_27692(class_124.field_1060));
        feedback.method_10852(class_2561.method_43470("\n- color "));
        feedback.method_10852(class_2561.method_43470("" + preference.color.method_5421()).method_27692(class_124.field_1054));
        feedback.method_10852(class_2561.method_43470("\n- style "));
        feedback.method_10852(class_2561.method_43470("" + preference.style.method_5425()).method_27692(class_124.field_1054));

        source.method_9226(() -> feedback, false);
        return 0;
    }

    public static int executeVersion(class_2168 source) {
        source.method_9226(() -> class_2561.method_43470("Pentamana " + Pentamana.VERSION_MAJOR + "." + Pentamana.VERSION_MINOR + "." + Pentamana.VERSION_PATCH), false);
        return 0;
    }

    public static int executeReload(class_2168 source) {
        source.method_9226(() -> class_2561.method_43470("Reloading Pentamana!"), true);
        return PentamanaConfig.reload(source.method_9211());
    }
}
