package net.cookedseafood.pentamana.render;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.cookedseafood.pentamana.data.PentamanaConfig;
import net.cookedseafood.pentamana.data.PentamanaPreference;
import net.minecraft.class_124;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_7225;

public class ManaRender {
    private ManaRender.Type type;
    private ManaCharset charset;
    private int pointsPerCharacter;
    private boolean isCompressed;
    private byte compressionSize;

    public ManaRender(ManaRender.Type type, ManaCharset charset, int pointsPerCharacter, boolean isCompressed, byte compressionSize) {
        this.type = type;
        this.charset = charset;
        this.pointsPerCharacter = pointsPerCharacter;
        this.isCompressed = isCompressed;
        this.compressionSize = compressionSize;
    }

    public class_2561 toText(float manaCapacity, float manaSupply) {
        return this.type == ManaRender.Type.CHARACTER ?
            this.toTextInCharacter(manaCapacity, manaSupply) :
            this.type == ManaRender.Type.NUMERIC ?
            this.toTextInNumeric(manaCapacity, manaSupply) :
            this.type == ManaRender.Type.PERCENTAGE ?
            this.toTextInPercentage(manaCapacity, manaSupply) :
            this.type == ManaRender.Type.NONE ?
            this.toTextInNone() :
            class_2561.method_43473();
    }

    public class_2561 toTextInCharacter(float manaCapacity, float manaSupply) {
        int manaCapacityPoint;
        int manaSupplyPoint;

        if (this.isCompressed) {
            manaCapacityPoint = this.compressionSize * 2;
            manaSupplyPoint = (int)(manaSupply / manaCapacity * manaCapacityPoint);
        } else {
            manaCapacityPoint = (int)(manaCapacity / PentamanaConfig.manaPerPoint);
            manaSupplyPoint = (int)(manaSupply / PentamanaConfig.manaPerPoint);
        }

        int manaCapacityPointTrimmed = manaCapacityPoint - manaCapacityPoint % this.pointsPerCharacter;
        int manaPointTrimmed = manaSupplyPoint - manaSupplyPoint % this.pointsPerCharacter;

        manaCapacityPointTrimmed = Math.min(manaCapacityPointTrimmed, PentamanaConfig.manaPointLimit);

        class_5250 text = class_2561.method_43473();
        for (int manaPointIndex = 0; manaPointIndex < manaCapacityPointTrimmed; manaPointIndex += this.pointsPerCharacter) {
            int manaCharacterTypeIndex =
                manaPointIndex < manaPointTrimmed ?
                0 : manaPointIndex < manaSupplyPoint ?
                manaSupplyPoint - manaPointIndex : this.pointsPerCharacter;
            int manaCharacterIndex = manaPointIndex / this.pointsPerCharacter;

            class_2561 SelectedManaCharacter = this.charset.get(manaCharacterTypeIndex).get(manaCharacterIndex);
            text.method_10852(SelectedManaCharacter);
        }

        return text;
    }

    public class_2561 toTextInNumeric(float manaCapacity, float manaSupply) {
        return class_2561.method_43470((int)(manaSupply / PentamanaConfig.manaPerPoint) + "/" + (int)(manaCapacity / PentamanaConfig.manaPerPoint)).method_10862(class_2583.field_24360.method_10977(class_124.field_1075));
    }

    public class_2561 toTextInPercentage(float manaCapacity, float manaSupply) {
        return class_2561.method_43470((int)(manaSupply / manaCapacity * 100) + "%").method_10862(class_2583.field_24360.method_10977(class_124.field_1075));
    }

    public class_2561 toTextInNone() {
        return class_2561.method_43473();
    }

    public ManaRender.Type getType() {
        return this.type;
    }

    public void setType(ManaRender.Type type) {
        this.type = type;
    }

    public ManaRender withType(ManaRender.Type type) {
        this.setType(type);
        return this;
    }

    public ManaCharset getCharset() {
        return charset;
    }

    public void setCharset(ManaCharset charset) {
        this.charset = charset;
    }

    public ManaRender withCharset(ManaCharset charset) {
        this.setCharset(charset);
        return this;
    }

    public int getPointsPerCharacter() {
        return pointsPerCharacter;
    }

    public void setPointsPerCharacter(int pointsPerCharacter) {
        this.pointsPerCharacter = pointsPerCharacter;
    }

    public ManaRender withPointsPerCharacter(int pointsPerCharacter) {
        this.setPointsPerCharacter(pointsPerCharacter);
        return this;
    }

    public boolean isCompressed() {
        return this.isCompressed;
    }

    public void setCompression(boolean isCompressed) {
        this.isCompressed = isCompressed;
    }

    public ManaRender withCompression(boolean isCompressed) {
        this.setCompression(isCompressed);
        return this;
    }

    public byte getCompressionSize() {
        return this.compressionSize;
    }

    public void setCompressionSize(byte compressionSize) {
        this.compressionSize = compressionSize;
    }

    public ManaRender withCompressionSize(byte compressionSize) {
        this.setCompressionSize(compressionSize);
        return this;
    }

    /**
     * A shadow copy.
     * 
     * @return a new ManaRender
     * 
     * @see #deepCopy()
     */
    public ManaRender copy() {
        return new ManaRender(this.type, this.charset, this.pointsPerCharacter, this.isCompressed, this.compressionSize);
    }

    /**
     * A deep copy.
     * 
     * @return a new ManaRender
     * 
     * @see #copy()
     */
    public ManaRender deepCopy() {
        return new ManaRender(this.type, this.charset.deepCopy(), this.pointsPerCharacter, this.isCompressed, this.compressionSize);
    }

    public static ManaRender fromPreference(PentamanaPreference preference) {
        return new ManaRender(
            preference.type,
            preference.charset,
            preference.pointsPerCharacter,
            preference.isCompressed,
            preference.compressionSize
        );
    }

    public static ManaRender fromNbt(class_2487 nbtCompound, class_7225.class_7874 wrapperLookup) {
        return new ManaRender(
            nbtCompound.method_10545("type") ? ManaRender.Type.byName(nbtCompound.method_10558("type").get()) : PentamanaConfig.DefaultPreference.type,
            ManaCharset.fromNbt(nbtCompound.method_68569("charset"), wrapperLookup),
            nbtCompound.method_68083("pointsPerCharacter", PentamanaConfig.DefaultPreference.pointsPerCharacter),
            nbtCompound.method_68566("isCompressed", PentamanaConfig.DefaultPreference.isCompressed),
            nbtCompound.method_68562("compressionSize", PentamanaConfig.DefaultPreference.compressionSize)
        );
    }

    public class_2487 toNbt(class_7225.class_7874 wrapperLookup) {
        return new class_2487(
            new HashMap<>(
                Map.<String,class_2520>ofEntries(
                    Map.entry("type", class_2519.method_23256(this.type.name)),
                    Map.entry("charset", this.charset.toNbt(wrapperLookup)),
                    Map.entry("pointsPerCharacter", class_2497.method_23247(this.pointsPerCharacter)),
                    Map.entry("isCompressed", class_2481.method_23234(this.isCompressed)),
                    Map.entry("compressionSize", class_2481.method_23233(this.compressionSize))
                )
            )
        );
    }

    public static enum Type {
        CHARACTER((byte)1, "character"),
        NUMERIC((byte)2, "numeric"),
        PERCENTAGE((byte)3, "percentage"),
        NONE((byte)0, "none");
    
        private byte index;
        private String name;
    
        Type(byte index, String name) {
            this.index = index;
            this.name = name;
        }
    
        public byte getIndex() {
            return this.index;
        }
    
        public String getName() {
            return this.name;
        }
    
        public static byte getIndex(String name) {
            return Arrays.stream(Type.values())
                .filter(manaManabarType -> manaManabarType.name.equals(name))
                .map(manaManabarType -> manaManabarType.index)
                .findAny()
                .orElse((byte)0);
        }
    
        public static String getName(byte index) {
            return Arrays.stream(Type.values())
                .filter(manaManabarType -> manaManabarType.index == index)
                .map(manaManabarType -> manaManabarType.name)
                .findAny()
                .orElse("");
        }
    
        public static Type byIndex(byte index) {
            return Arrays.stream(Type.values())
                .filter(manaManabarType -> manaManabarType.index == index)
                .findAny()
                .get();
        }
    
        public static Type byName(String name) {
            return Arrays.stream(Type.values())
                .filter(manaManabarType -> manaManabarType.name.equals(name))
                .findAny()
                .get();
        }
    }
}
