package net.cookedseafood.pentamana.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.cookedseafood.pentamana.data.PentamanaConfig;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class ManaCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess) {
        dispatcher.register(
            class_2170.method_9247("mana")
            .then(
                class_2170.method_9247("get")
                .requires(source -> source.method_9259(2))
                .then(
                    class_2170.method_9244("amount", FloatArgumentType.floatArg())
                    .executes(context -> executeSet(context.getSource(), FloatArgumentType.getFloat(context, "amount")))
                )
            )
            .then(
                class_2170.method_9247("set")
                .requires(source -> source.method_9259(2))
                .then(
                    class_2170.method_9244("amount", FloatArgumentType.floatArg())
                    .executes(context -> executeSet(context.getSource(), FloatArgumentType.getFloat(context, "amount")))
                )
            )
            .then(
                class_2170.method_9247("add")
                .requires(source -> source.method_9259(2))
                .then(
                    class_2170.method_9244("amount", FloatArgumentType.floatArg())
                    .executes(context -> executeAdd(context.getSource(), FloatArgumentType.getFloat(context, "amount")))
                )
            )
            .then(
                class_2170.method_9247("subtract")
                .requires(source -> source.method_9259(2))
                .then(
                    class_2170.method_9244("amount", FloatArgumentType.floatArg())
                    .executes(context -> executeSubtract(context.getSource(), FloatArgumentType.getFloat(context, "amount")))
                )
            )
        );
    }

    public static int executeGet(class_2168 source) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        float supply = player.getMana();
        source.method_9226(() -> class_2561.method_43470(player.method_5820() + " has " + supply + " mana."), false);
        return (int)(supply / PentamanaConfig.manaPerPoint);
    }

    public static int executeSet(class_2168 source, float amount) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        player.setMana(amount);
        source.method_9226(() -> class_2561.method_43470("Set mana for player ").method_10852(player.method_5476()).method_27693(" to " + amount + "."), false);
        return (int)(amount / PentamanaConfig.manaPerPoint);
    }

    public static int executeAdd(class_2168 source, float amount) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        float targetSupply = player.getMana() + amount;
        player.setMana(targetSupply);
        source.method_9226(() -> class_2561.method_43470("Added " + amount + " mana for player ").method_10852(player.method_5476()).method_27693("."), false);
        return (int)(targetSupply / PentamanaConfig.manaPerPoint);
    }

    public static int executeSubtract(class_2168 source, float amount) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        float targetSupply = player.getMana() - amount;
        player.setMana(targetSupply);
        source.method_9226(() -> class_2561.method_43470("Subtracted " + amount + " mana for player ").method_10852(player.method_5476()).method_27693("."), false);
        return (int)(targetSupply / PentamanaConfig.manaPerPoint);
    }
}
