package net.cookedseafood.pentamana.mixin;

import java.util.HashMap;
import java.util.Map;
import net.cookedseafood.generalcustomdata.effect.CustomStatusEffectManager;
import net.cookedseafood.pentamana.api.LivingEntityApi;
import net.cookedseafood.pentamana.api.event.ConsumManaCallback;
import net.cookedseafood.pentamana.api.event.RegenManaCallback;
import net.cookedseafood.pentamana.api.event.TickManaCallback;
import net.cookedseafood.pentamana.attribute.PentamanaAttributeIdentifiers;
import net.cookedseafood.pentamana.data.PentamanaConfig;
import net.cookedseafood.pentamana.effect.PentamanaStatusEffectIdentifiers;
import net.cookedseafood.pentamana.enchantment.PentamanaEnchantmentIdentifiers;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1640;
import net.minecraft.class_2487;
import net.minecraft.class_2494;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1309.class)
public abstract class LivingEntityMixin implements LivingEntityApi {
    @Inject(
        method = "tick()V",
        at = @At("RETURN")
    )
    private void tickMana(CallbackInfo info) {
        this.tickMana();
    }

    @Override
    public void tickMana() {
        class_1309 entity = (class_1309)(Object)this;
        TickManaCallback.EVENT.invoker().interact(entity);
        CustomStatusEffectManager statusEffectManager = entity.getCustomStatusEffectManager();
        boolean isValueChanged = false;

        float capacity = (float)entity.getCustomModifiedValue(PentamanaAttributeIdentifiers.MANA_CAPACITY, PentamanaConfig.manaCapacityBase);
        capacity += PentamanaConfig.enchantmentCapacityBase * entity.method_59958().method_58657().getLevel(PentamanaEnchantmentIdentifiers.CAPACITY);
        capacity += statusEffectManager.containsKey(PentamanaStatusEffectIdentifiers.MANA_BOOST) ? PentamanaConfig.statusEffectManaBoostBase * (statusEffectManager.getActiveAmplifier(PentamanaStatusEffectIdentifiers.MANA_BOOST) + 1) : 0;
        capacity -= statusEffectManager.containsKey(PentamanaStatusEffectIdentifiers.MANA_REDUCTION) ? PentamanaConfig.statusEffectManaReductionBase * (statusEffectManager.getActiveAmplifier(PentamanaStatusEffectIdentifiers.MANA_REDUCTION) + 1) : 0;
        capacity += PentamanaConfig.shouldConvertExperienceLevel && entity instanceof class_3222 ? PentamanaConfig.experienceLevelConversionBase * ((class_3222)entity).field_7520 : 0;
        capacity = Math.max(capacity, 0.0f);

        if (this.getManaCapacity() != capacity) {
            this.setManaCapacity(capacity);
            isValueChanged = true;
        }

        float supply = this.getMana();

        if (supply < capacity && supply >= 0.0f) {
            isValueChanged |= this.regenMana();
        } else if (supply > capacity) {
            this.setMana(capacity);
            isValueChanged = true;
        } else if (supply < 0) {
            this.setMana(0.0f);
            isValueChanged = true;
        }

        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            if (player.isManaBarDisplayOutdate(isValueChanged)) {
                player.putManaBarDisplay();
            }
        }
    }

    /**
     * Add {@code amount} to supply and cap it at capacity and 0.
     * 
     * @param amount regeneration amount
     * @return {@code true} if supply changed
     * 
     * @see #regenMana()
     */
    @Override
    public boolean regenMana(float amount) {
        float presentedSupply = this.getMana();
        float targetSupply = presentedSupply + amount;
        targetSupply = Math.min(targetSupply, this.getManaCapacity());
        targetSupply = Math.max(targetSupply, 0.0f);

        this.setMana(targetSupply);
        return targetSupply != presentedSupply;
    }

    /**
     * Add {@link PentamanaConfig#manaRegenerationBase} to supply with custom modifiers
     * and enchantments applied.
     * 
     * @return {@code true} if supply changed
     * 
     * @see #regenMana(float)
     */
    @Override
    public boolean regenMana() {
        class_1309 entity = (class_1309)(Object)this;
        RegenManaCallback.EVENT.invoker().interact(entity);
        CustomStatusEffectManager statusEffectManager = entity.getCustomStatusEffectManager();

        float regen = (float)entity.getCustomModifiedValue(PentamanaAttributeIdentifiers.MANA_REGENERATION, PentamanaConfig.manaRegenerationBase);
        regen += PentamanaConfig.enchantmentStreamBase * entity.method_59958().method_58657().getLevel(PentamanaEnchantmentIdentifiers.STREAM);
        regen += statusEffectManager.containsKey(PentamanaStatusEffectIdentifiers.INSTANT_MANA) ? PentamanaConfig.statusEffectInstantManaBase * Math.pow(2, statusEffectManager.getActiveAmplifier(PentamanaStatusEffectIdentifiers.INSTANT_MANA)) : 0;
        regen -= statusEffectManager.containsKey(PentamanaStatusEffectIdentifiers.INSTANT_DEPLETE) ? PentamanaConfig.statusEffectInstantDepleteBase * Math.pow(2, statusEffectManager.getActiveAmplifier(PentamanaStatusEffectIdentifiers.INSTANT_DEPLETE)) : 0;
        regen += statusEffectManager.containsKey(PentamanaStatusEffectIdentifiers.MANA_REGENERATION) ? PentamanaConfig.manaPerPoint / (float)Math.max(1, PentamanaConfig.statusEffectManaRegenerationBase >> statusEffectManager.getActiveAmplifier(PentamanaStatusEffectIdentifiers.MANA_REGENERATION)) : 0;
        regen -= statusEffectManager.containsKey(PentamanaStatusEffectIdentifiers.MANA_INHIBITION) ? PentamanaConfig.manaPerPoint / (float)Math.max(1, PentamanaConfig.statusEffectManaInhibitionBase >> statusEffectManager.getActiveAmplifier(PentamanaStatusEffectIdentifiers.MANA_INHIBITION)) : 0;

        return this.regenMana(regen);
    }

    /**
     * Substract {@code amount} from supply with custom modifiers and enchantments
     * applied if supply >= {@code consum}.
     * 
     * @param amount consumption amount
     * @return true if successful
     */
    @Override
    public boolean consumMana(float amount) {
        class_1309 entity = (class_1309)(Object)this;
        ConsumManaCallback.EVENT.invoker().interact(entity);

        float targetConsum = (float)entity.getCustomModifiedValue(PentamanaAttributeIdentifiers.MANA_CONSUMPTION, amount);
        targetConsum *= 1 - PentamanaConfig.enchantmentManaEfficiencyBase * entity.method_59958().method_58657().getLevel(PentamanaEnchantmentIdentifiers.MANA_EFFICIENCY);

        float targetSupply = this.getMana() - targetConsum;
        if (targetSupply < 0.0f) {
            return false;
        }

        this.setMana(targetSupply);
        return true;
    }

    @Override
    public float getMana() {
        return ((class_1309)(Object)this).method_58695(class_9334.field_49628, class_9279.field_49302).method_57461().method_66563("mana", 0f);
    }

    @Override
    public void setMana(float value) {
        ((class_1309)(Object)this).method_66653(class_9334.field_49628, class_9279.method_57456(
            ((class_1309)(Object)this).method_58695(class_9334.field_49628, class_9279.field_49302).method_57461().method_10543(
                new class_2487(
                    new HashMap<>(
                        Map.<String, class_2520>of(
                            "mana",
                            class_2494.method_23244(value)
                        )
                    )
                )
            )
        ));
    }

    @Override
    public float getManaCapacity() {
        return ((class_1309)(Object)this).method_58695(class_9334.field_49628, class_9279.field_49302).method_57461().method_66563("mana_capacity", 0f);
    }

    @Override
    public void setManaCapacity(float value) {
        ((class_1309)(Object)this).method_66653(class_9334.field_49628, class_9279.method_57456(
            ((class_1309)(Object)this).method_58695(class_9334.field_49628, class_9279.field_49302).method_57461().method_10543(
                new class_2487(
                    new HashMap<>(
                        Map.<String, class_2520>of(
                            "mana_capacity",
                            class_2494.method_23244(value)
                        )
                    )
                )
            )
        ));
    }

    @Override
    public float getCastingDamageAgainst(class_1297 entity, float baseDamage) {
        class_1309 livingEntity = (class_1309)(Object)this;
        CustomStatusEffectManager statusEffectManager = livingEntity.getCustomStatusEffectManager();

        float manaCapacity = livingEntity.getManaCapacity();
        int potencyLevel = livingEntity.method_59958().method_58657().getLevel(PentamanaEnchantmentIdentifiers.POTENCY);

        float castingDamage = manaCapacity;
        castingDamage /= PentamanaConfig.manaCapacityBase;
        castingDamage *= (float)livingEntity.getCustomModifiedValue(PentamanaAttributeIdentifiers.CASTING_DAMAGE, baseDamage);
        castingDamage += potencyLevel != 0 ? ++potencyLevel * PentamanaConfig.enchantmentPotencyBase / Integer.MAX_VALUE : 0;
        castingDamage += statusEffectManager.containsKey(PentamanaStatusEffectIdentifiers.MANA_POWER) ? (statusEffectManager.getActiveAmplifier(PentamanaStatusEffectIdentifiers.MANA_POWER) + 1) * PentamanaConfig.statusEffectManaPowerBase : 0;
        castingDamage -= statusEffectManager.containsKey(PentamanaStatusEffectIdentifiers.MANA_SICKNESS) ? (statusEffectManager.getActiveAmplifier(PentamanaStatusEffectIdentifiers.MANA_SICKNESS) + 1) * PentamanaConfig.statusEffectManaSicknessBase : 0;
        castingDamage = Math.max(castingDamage, 0.0f);
        castingDamage *= entity instanceof class_1640 ? 0.15f : 1;
        return castingDamage;
    }
}
