package net.cookedseafood.pentamana.render;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.cookedseafood.candywrapper.util.BossBars;
import net.cookedseafood.pentamana.data.PentamanaConfig;
import net.cookedseafood.pentamana.data.PentamanaPreference;
import net.minecraft.class_1259;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2494;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_7225;

public class ManaBar {
    protected float capacity;
    protected float supply;
    protected ManaBar.Position position;
    protected ManaTextual textual;
    protected boolean isVisible;
    protected boolean isSuppressed;
    protected class_1259.class_1260 color;
    protected class_1259.class_1261 style;

    public ManaBar(float capacity, float supply, ManaBar.Position position, ManaTextual textual, boolean isVisible, boolean isSuppressed, class_1259.class_1260 color, class_1259.class_1261 style) {
        this.capacity = capacity;
        this.supply = supply;
        this.position = position;
        this.textual = textual;
        this.isVisible = isVisible;
        this.isSuppressed = isSuppressed;
        this.color = color;
        this.style = style;
    }

    public boolean isFull() {
        return this.supply == capacity;
    }

    public boolean isEmpty() {
        return this.supply == 0.0f;
    }

    public float getCapacity() {
        return this.capacity;
    }

    public void setCapacity(float capacity) {
        this.capacity = capacity;
    }

    public ManaBar withCapacity(float capacity) {
        this.setCapacity(capacity);
        return this;
    }

    public float getSupply() {
        return this.supply;
    }

    public void setSupply(float supply) {
        this.supply = supply;
    }

    public ManaBar withSupply(float supply) {
        this.setSupply(supply);
        return this;
    }

    public ManaBar.Position getPosition() {
        return this.position;
    }

    public void setPosition(ManaBar.Position position) {
        this.position = position;
    }

    public ManaBar withPosition(ManaBar.Position position) {
        this.setPosition(position);
        return this;
    }

    public ManaTextual getTextual() {
        return this.textual;
    }

    public void setTextual(ManaTextual textual) {
        this.textual = textual;
    }

    public ManaBar withTextual(ManaTextual textual) {
        this.setTextual(textual);
        return this;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisibility(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public ManaBar withVisibility(boolean isVisible) {
        this.setVisibility(isVisible);
        return this;
    }

    public boolean isSuppressed() {
        return this.isSuppressed;
    }

    public void setSuppression(boolean isSuppressed) {
        this.isSuppressed = isSuppressed;
    }

    public ManaBar withSuppression(boolean isSuppressed) {
        this.setSuppression(isSuppressed);
        return this;
    }

    public class_1259.class_1260 getColor() {
        return this.color;
    }

    public void setColor(class_1259.class_1260 color) {
        this.color = color;
    }

    public ManaBar withColor(class_1259.class_1260 color) {
        this.setColor(color);
        return this;
    }

    public class_1259.class_1261 getStyle() {
        return this.style;
    }

    public void setStyle(class_1259.class_1261 style) {
        this.style = style;
    }

    public ManaBar withStyle(class_1259.class_1261 style) {
        this.setStyle(style);
        return this;
    }

    /**
     * A shadow copy.
     * 
     * @return a new ManaBar
     * 
     * @see #deepCopy()
     */
    public ManaBar copy() {
        return new ManaBar(this.capacity, this.supply, this.position, this.textual, this.isVisible, this.isSuppressed, this.color, this.style);
    }

    /**
     * A deep copy.
     * 
     * @return a new ManaBar
     * 
     * @see #copy()
     */
    public ManaBar deepCopy() {
        return new ManaBar(this.capacity, this.supply, this.position, this.textual.deepCopy(), this.isVisible, this.isSuppressed, this.color, this.style);
    }

    public static ManaBar fromPreference(PentamanaPreference preference) {
        return new ManaBar(
            0,
            0,
            preference.position,
            ManaTextual.fromPreference(preference),
            preference.isVisible,
            preference.isSuppressed,
            preference.color,
            preference.style
        );
    }

    public static ManaBar fromNbt(class_2487 nbtCompound, class_7225.class_7874 wrapperLookup) {
        return new ManaBar(
            nbtCompound.method_66563("capacity", 0f),
            nbtCompound.method_66563("supply", 0f),
            nbtCompound.method_10545("position") ? ManaBar.Position.byName(nbtCompound.method_10558("position").get()) : PentamanaConfig.DefaultPreference.position,
            ManaTextual.fromNbt(nbtCompound.method_68568("textual"), wrapperLookup),
            nbtCompound.method_68566("isVisible", PentamanaConfig.DefaultPreference.isVisible),
            nbtCompound.method_68566("isSuppressed", PentamanaConfig.DefaultPreference.isSuppressed),
            nbtCompound.method_10545("color") ? BossBars.Colors.byName(nbtCompound.method_10558("color").get()) : PentamanaConfig.DefaultPreference.color,
            nbtCompound.method_10545("style") ? BossBars.Styles.byName(nbtCompound.method_10558("style").get()) : PentamanaConfig.DefaultPreference.style
        );
    }

    public class_2487 toNbt(class_7225.class_7874 wrapperLookup) {
        return new class_2487(
            new HashMap<>(
                Map.<String,class_2520>ofEntries(
                    Map.entry("capacity", class_2494.method_23244(this.capacity)),
                    Map.entry("supply", class_2494.method_23244(this.supply)),
                    Map.entry("position", class_2519.method_23256(this.position.name)),
                    Map.entry("textual", this.textual.toNbt(wrapperLookup)),
                    Map.entry("isVisible", class_2481.method_23234(this.isVisible)),
                    Map.entry("isSuppressed", class_2481.method_23234(this.isSuppressed)),
                    Map.entry("color", class_2519.method_23256(this.color.method_5421())),
                    Map.entry("style", class_2519.method_23256(this.style.method_5425()))
                )
            )
        );
    }

    public static enum Position {
        ACTIONBAR((byte)0, "actionbar"),
        BOSSBAR((byte)1, "bossbar"),
        SIDERBAR((byte)2, "siderbar");

        private byte index;
        private String name;

        Position(byte index, String name) {
            this.index = index;
            this.name = name;
        }

        public byte getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public static byte getIndex(String name) {
            return Arrays.stream(Position.values())
                .filter(position -> position.name.equals(name))
                .map(position -> position.index)
                .findAny()
                .orElse((byte)0);
        }

        public static String getName(byte index) {
            return Arrays.stream(Position.values())
                .filter(position -> position.index == index)
                .map(position -> position.name)
                .findAny()
                .orElse("");
        }

        public static Position byIndex(byte index) {
            return Arrays.stream(Position.values())
                .filter(position -> position.index == index)
                .findAny()
                .get();
        }

        public static Position byName(String name) {
            return Arrays.stream(Position.values())
                .filter(position -> position.name.equals(name))
                .findAny()
                .get();
        }
    }
}
