package net.cookedseafood.pentamana.render;

import java.util.HashMap;
import java.util.Map;
import net.cookedseafood.pentamana.Pentamana;
import net.cookedseafood.pentamana.data.PentamanaPreference;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7225;

public class ManaTextual {
    private ManaPattern pattern;
    private ManaRender render;

    public ManaTextual(ManaPattern pattern, ManaRender render) {
        this.pattern = pattern;
        this.render = render;
    }

    public class_2561 toText(float manaCapacity, float manaSupply) {
        if (!this.pattern.stream()
            .anyMatch(Pentamana.MANA_PATTERN_MATCHER::equals)) {
            return this.pattern.toText();
        }

        class_2561 renderText = this.render.toText(manaCapacity, manaSupply);
        class_5250 text = class_2561.method_43473();
        this.pattern.stream()
            .map(p -> Pentamana.MANA_PATTERN_MATCHER.equals(p) ? renderText : p)
            .forEach(text::method_10852);
        return text;
    }

    public ManaPattern getPattern() {
        return this.pattern;
    }

    public void setPattern(ManaPattern pattern) {
        this.pattern = pattern;
    }

    public ManaTextual withPattern(ManaPattern pattern) {
        this.setPattern(pattern);
        return this;
    }

    public ManaRender getRender() {
        return render;
    }

    public void setRender(ManaRender render) {
        this.render = render;
    }

    public ManaTextual withRender(ManaRender render) {
        this.setRender(render);
        return this;
    }

    /**
     * A shadow copy.
     * 
     * @return a new ManaTextual
     * 
     * @see #deepCopy()
     */
    public ManaTextual copy() {
        return new ManaTextual(this.pattern, this.render);
    }

    /**
     * A deep copy.
     * 
     * @return a new ManaTextual
     * 
     * @see #copy()
     */
    public ManaTextual deepCopy() {
        return new ManaTextual(this.pattern.deepCopy(), this.render.deepCopy());
    }

    public static ManaTextual fromPreference(PentamanaPreference preference) {
        return new ManaTextual(
            preference.pattern,
            ManaRender.fromPreference(preference)
        );
    }

    public static ManaTextual fromNbt(class_2487 nbtCompound, class_7225.class_7874 wrapperLookup) {
        return new ManaTextual(
            ManaPattern.fromNbt(nbtCompound.method_68569("pattern"), wrapperLookup),
            ManaRender.fromNbt(nbtCompound.method_68568("render"), wrapperLookup)
        );
    }

    public class_2487 toNbt(class_7225.class_7874 wrapperLookup) {
        return new class_2487(
            new HashMap<>(
                Map.<String,class_2520>ofEntries(
                    Map.entry("pattern", this.pattern.toNbt(wrapperLookup)),
                    Map.entry("render", this.render.toNbt(wrapperLookup))
                )
            )
        );
    }
}
