package net.cookedseafood.pentamana.render;

import java.util.UUID;
import net.cookedseafood.pentamana.data.PentamanaConfig;
import net.cookedseafood.pentamana.data.PentamanaPreference;
import net.minecraft.class_1259;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_2736;
import net.minecraft.class_274;
import net.minecraft.class_2751;
import net.minecraft.class_2960;
import net.minecraft.class_2995;
import net.minecraft.class_3002;
import net.minecraft.class_3004;
import net.minecraft.class_3222;
import net.minecraft.class_8646;
import net.minecraft.server.MinecraftServer;

public final class ServerManaBar extends ManaBar {
    private MinecraftServer server;
    private class_2995 scoreboard;
    private class_3004 bossBarManager;
    private class_3222 player;
    private UUID uuid;
    private String name;
    private class_2960 id;

    public ServerManaBar(class_3222 player, UUID uuid, String name, class_2960 id, float capacity, float supply, ManaBar.Position position, ManaTextual textual, boolean isVisible, boolean isSuppressed, class_1259.class_1260 color, class_1259.class_1261 style) {
        super(capacity, supply, position, textual, isVisible, isSuppressed, color, style);
        this.server = player.method_5682();
        this.scoreboard = player.method_5682().method_3845();
        this.bossBarManager = player.method_5682().method_3837();
        this.player = player;
        this.uuid = uuid;
        this.name = name;
        this.id = id;
    }

    public ServerManaBar(class_3222 player, UUID uuid, String name, class_2960 id, ManaBar manabar) {
        this(player, uuid, name, id, player.getManaCapacity(), player.getMana(), manabar.position, manabar.textual, manabar.isVisible, manabar.isSuppressed, manabar.color, manabar.style);
    }

    public ServerManaBar(class_3222 player, UUID uuid, String name, class_2960 id, PentamanaPreference preference) {
        this(player, uuid, name, id, ManaBar.fromPreference(preference));
    }

    public ServerManaBar(class_3222 player, UUID uuid, String name, class_2960 id) {
        this(player, uuid, name, id, player.getPentamanaPreference());
    }

    public void putDisplay(ManaBar.Position position) {
        if (position == ManaBar.Position.ACTIONBAR) {
            this.player.method_7353(this.textual.toText(capacity, supply), true);
        } else if (position == ManaBar.Position.BOSSBAR) {
            class_3002 bossbar = this.bossBarManager.getOrAdd(this.id, class_2561.method_43473());

            bossbar.method_12956((int)(this.capacity / PentamanaConfig.manaPerPoint));
            bossbar.method_12954((int)(this.supply / PentamanaConfig.manaPerPoint));
            bossbar.method_5413(this.textual.toText(capacity, supply));
            bossbar.method_5416(this.color);
            bossbar.method_5409(this.style);
            bossbar.method_14088(this.player);
        } else if (position == ManaBar.Position.SIDERBAR) {
            class_266 objective = this.scoreboard.method_1170(this.name);

            if (objective == null) {
                objective = this.scoreboard.method_1168(this.name, class_274.field_1468, class_2561.method_43473(), class_274.class_275.field_1472, true, null);
                this.player.field_13987.method_14364(new class_2751(objective, class_2751.field_33343));
                this.player.field_13987.method_14364(new class_2736(class_8646.field_45157, objective));
            }

            objective.method_1121(this.textual.toText(capacity, supply));
            this.player.field_13987.method_14364(new class_2751(objective, class_2751.field_33345));
        }
    }

    public void putDisplay() {
        this.putDisplay(this.position);
    }

    public void removeDisplay(ManaBar.Position position) {
        if (position == ServerManaBar.Position.ACTIONBAR) {
            this.player.method_7353(class_2561.method_43470(""), true);
        } else if (position == ServerManaBar.Position.BOSSBAR) {
            if (this.bossBarManager.containsKey(this.id)) {
                this.bossBarManager.method_12971(this.id).method_14094();
                this.bossBarManager.remove(this.id);
            }
        } else if (position == ManaBar.Position.SIDERBAR) {
            class_266 objective = this.scoreboard.method_1170(this.name);

            if (objective != null) {
                this.scoreboard.method_1194(objective);
                this.player.field_13987.method_14364(new class_2751(objective, class_2751.field_33344));
            }
        }
    }

    public void removeDisplay() {
        this.removeDisplay(this.position);
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    public void setServer(MinecraftServer server) {
        this.server = server;
    }

    public ServerManaBar withServer(MinecraftServer server) {
        this.setServer(server);
        return this;
    }

    public class_2995 getScoreboard() {
        return this.scoreboard;
    }

    public void setScoreboard(class_2995 scoreboard) {
        this.scoreboard = scoreboard;
    }

    public ServerManaBar withScoreboard(class_2995 scoreboard) {
        this.setScoreboard(scoreboard);
        return this;
    }

    public class_3004 getBossBarManager() {
        return this.bossBarManager;
    }

    public void setBossBarManager(class_3004 bossBarManager) {
        this.bossBarManager = bossBarManager;
    }

    public ServerManaBar withBossBarManager(class_3004 bossBarManager) {
        this.setBossBarManager(bossBarManager);
        return this;
    }

    public class_3222 getPlayer() {
        return this.player;
    }

    public void setPlayer(class_3222 player) {
        this.player = player;
    }

    public ServerManaBar withPlayer(class_3222 player) {
        this.setPlayer(player);
        return this;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public ServerManaBar withUuid(UUID uuid) {
        this.setUuid(uuid);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ServerManaBar withName(String name) {
        this.setName(name);
        return this;
    }

    public class_2960 getId() {
        return this.id;
    }

    public void setId(class_2960 id) {
        this.id = id;
    }

    public ServerManaBar withId(class_2960 id) {
        this.setId(id);
        return this;
    }

    @Override
    public void setCapacity(float capacity) {
        if (this.capacity == capacity) {
            return;
        }

        this.player.setManaCapacity(capacity);
        super.setCapacity(capacity);
    }

    public ServerManaBar withCapacity(float capacity) {
        this.setCapacity(capacity);
        return this;
    }

    @Override
    public void setSupply(float supply) {
        if (this.supply == supply) {
            return;
        }

        this.player.setMana(supply);
        super.setSupply(supply);
    }

    public ServerManaBar withSupply(float supply) {
        this.setSupply(supply);
        return this;
    }

    @Override
    public void setPosition(ManaBar.Position position) {
        if (this.position == position) {
            return;
        }

        this.player.setManaBarPosition(position);
        super.setPosition(position);
    }

    public ServerManaBar withPosition(ManaBar.Position position) {
        this.setPosition(position);
        return this;
    }

    @Override
    public void setVisibility(boolean isVisible) {
        if (this.isVisible == isVisible) {
            return;
        }

        this.player.setManaBarVisibility(isVisible);
        super.setVisibility(isVisible);
    }

    public ServerManaBar withVisibility(boolean isVisible) {
        this.setVisibility(isVisible);
        return this;
    }

    @Override
    public void setSuppression(boolean isSuppressed) {
        if (this.isSuppressed == isSuppressed) {
            return;
        }

        this.player.setManaBarSuppression(isSuppressed);
        super.setSuppression(isSuppressed);
    }

    public ServerManaBar withSuppression(boolean isSuppressed) {
        this.setSuppression(isSuppressed);
        return this;
    }

    @Override
    public void setColor(class_1259.class_1260 color) {
        if (this.color == color) {
            return;
        }

        this.player.setManaBarColor(color);
        super.setColor(color);
    }

    public ServerManaBar withColor(class_1259.class_1260 color) {
        this.setColor(color);
        return this;
    }

    @Override
    public void setStyle(class_1259.class_1261 style) {
        if (this.style == style) {
            return;
        }

        this.player.setManaBarStyle(style);
        super.setStyle(style);
    }

    public ServerManaBar withStyle(class_1259.class_1261 style) {
        this.setStyle(style);
        return this;
    }

    /**
     * A shadow copy.
     * 
     * @return a new ServerManaBar
     * 
     * @see #deepCopy()
     */
    @Override
    public ServerManaBar copy() {
        return new ServerManaBar(this.player, this.uuid, this.name, this.id, super.copy());
    }

    /**
     * A deep copy.
     * 
     * @return a new ServerManaBar
     * 
     * @see #copy()
     */
    @Override
    public ServerManaBar deepCopy() {
        return new ServerManaBar(this.player, this.uuid, this.name, class_2960.method_60654(this.id.toString()), super.deepCopy());
    }
}
